/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.engines.CipherEngine;
import com.maverick.crypto.engines.DESedeEngine;
import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.publickey.Dsa;
import com.maverick.crypto.publickey.DsaPrivateKey;
import com.maverick.crypto.publickey.RsaPrivateKey;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshDsaPrivateKey;
import com.maverick.ssh.SshRsaPrivateKey;
import com.maverick.ssh.cipher.CbcBlockCipher;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshKeyPair;
import com.sshtools.publickey.SshPrivateKeyFile;
import java.io.IOException;
import java.math.BigInteger;

class I
extends Base64EncodedFileFormat
implements SshPrivateKeyFile {
    public static String I = "---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    public static String K = "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private int H = 1391688382;
    byte[] J;

    I(byte[] byArray) throws IOException {
        super(I, K);
        this.J = this.getKeyBlob(byArray);
    }

    I(SshKeyPair sshKeyPair, String string, String string2) throws IOException {
        super(I, K);
        this.setHeaderValue("Comment", string2);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        if (sshKeyPair.B instanceof DsaPrivateKey) {
            DsaPrivateKey dsaPrivateKey = (DsaPrivateKey)sshKeyPair.B;
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(dsaPrivateKey.getP());
            byteArrayWriter.writeBigInteger(dsaPrivateKey.getQ());
            byteArrayWriter.writeBigInteger(dsaPrivateKey.getG());
            byteArrayWriter.writeBigInteger(dsaPrivateKey.getX());
            this.J = this.B(byteArrayWriter.toByteArray(), string);
        } else if (sshKeyPair.B instanceof RsaPrivateKey) {
            RsaPrivateKey rsaPrivateKey = (RsaPrivateKey)sshKeyPair.B;
            RsaPublicKey rsaPublicKey = (RsaPublicKey)sshKeyPair.A;
            byteArrayWriter.writeString("ssh-rsa");
            byteArrayWriter.writeBigInteger(rsaPublicKey.getPublicExponent());
            byteArrayWriter.writeBigInteger(rsaPublicKey.getModulus());
            byteArrayWriter.writeBigInteger(rsaPrivateKey.getPrivateExponent());
            this.J = this.B(byteArrayWriter.toByteArray(), string);
        } else {
            throw new IOException("Unsupported private key type!");
        }
    }

    public String getType() {
        return "SSHTools";
    }

    public boolean supportsPassphraseChange() {
        return true;
    }

    public boolean isPassphraseProtected() {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.J);
            String string = byteArrayReader.readString();
            if (string.equals("none")) {
                return false;
            }
            if (string.equalsIgnoreCase("3des-cbc")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private byte[] B(byte[] byArray, String string) throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        String string2 = "none";
        if (string != null && !string.trim().equals("")) {
            string2 = "3DES-CBC";
            byte[] byArray2 = this.B(string);
            byte[] byArray3 = new byte[8];
            SecureRandom secureRandom = SecureRandom.getInstance();
            secureRandom.nextBytes(byArray3);
            CbcBlockCipher cbcBlockCipher = new CbcBlockCipher(192, (CipherEngine)new DESedeEngine(), "");
            cbcBlockCipher.init(0, byArray3, byArray2);
            ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
            byteArrayWriter.writeString(string2);
            byteArrayWriter.write(byArray3);
            byteArrayWriter2.writeInt(this.H);
            byteArrayWriter2.writeBinaryString(byArray);
            if (byteArrayWriter2.size() % cbcBlockCipher.getBlockSize() != 0) {
                int n = cbcBlockCipher.getBlockSize() - byteArrayWriter2.size() % cbcBlockCipher.getBlockSize();
                byte[] byArray4 = new byte[n];
                for (int i = 0; i < n; ++i) {
                    byArray4[i] = (byte)n;
                }
                byteArrayWriter2.write(byArray4);
            }
            byte[] byArray5 = byteArrayWriter2.toByteArray();
            cbcBlockCipher.transform(byArray5, 0, byArray5, 0, byArray5.length);
            byteArrayWriter.writeBinaryString(byArray5);
            return byteArrayWriter.toByteArray();
        }
        byteArrayWriter.writeString(string2);
        byteArrayWriter.writeBinaryString(byArray);
        return byteArrayWriter.toByteArray();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] C(String string) throws IOException, InvalidPassphraseException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.J);
        String string2 = byteArrayReader.readString();
        if (!string2.equalsIgnoreCase("3des-cbc")) return byteArrayReader.readBinaryString();
        byte[] byArray = this.B(string);
        byte[] byArray2 = new byte[8];
        if (string2.equals("3DES-CBC")) {
            byteArrayReader.read(byArray2);
        }
        byte[] byArray3 = byteArrayReader.readBinaryString();
        CbcBlockCipher cbcBlockCipher = new CbcBlockCipher(192, (CipherEngine)new DESedeEngine(), "");
        cbcBlockCipher.init(1, byArray2, byArray);
        cbcBlockCipher.transform(byArray3, 0, byArray3, 0, byArray3.length);
        ByteArrayReader byteArrayReader2 = new ByteArrayReader(byArray3);
        if (byteArrayReader2.readInt() != (long)this.H) throw new InvalidPassphraseException();
        return byteArrayReader2.readBinaryString();
    }

    public byte[] getFormattedKey() throws IOException {
        return this.formatKey(this.J);
    }

    public SshKeyPair toKeyPair(String string) throws IOException, InvalidPassphraseException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.C(string));
        String string2 = byteArrayReader.readString();
        if (string2.equals("ssh-dss")) {
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            BigInteger bigInteger5 = Dsa.generatePublicKey((BigInteger)bigInteger3, (BigInteger)bigInteger, (BigInteger)bigInteger4);
            SshKeyPair sshKeyPair = new SshKeyPair();
            sshKeyPair.A = new Ssh2DsaPublicKey(bigInteger, bigInteger2, bigInteger3, bigInteger5);
            sshKeyPair.B = new SshDsaPrivateKey(bigInteger, bigInteger2, bigInteger3, bigInteger4);
            return sshKeyPair;
        }
        if (string2.equals("ssh-rsa")) {
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger6 = byteArrayReader.readBigInteger();
            BigInteger bigInteger7 = byteArrayReader.readBigInteger();
            SshKeyPair sshKeyPair = new SshKeyPair();
            sshKeyPair.A = new Ssh2RsaPublicKey(bigInteger6, bigInteger);
            sshKeyPair.B = new SshRsaPrivateKey(bigInteger6, bigInteger7);
            return sshKeyPair;
        }
        throw new IOException("Unsupported private key algorithm type " + string2);
    }

    public void changePassphrase(String string, String string2) throws IOException, InvalidPassphraseException {
        this.J = this.B(this.C(string), string2);
    }

    private byte[] B(String string) {
        Hash hash = new Hash("MD5");
        hash.putBytes(string.getBytes());
        byte[] byArray = hash.doFinal();
        hash.reset();
        hash.putBytes(string.getBytes());
        hash.putBytes(byArray);
        byte[] byArray2 = hash.doFinal();
        byte[] byArray3 = new byte[32];
        System.arraycopy(byArray, 0, byArray3, 0, 16);
        System.arraycopy(byArray2, 0, byArray3, 16, 16);
        return byArray3;
    }
}

