/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.io.ByteArrayReader;
import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.ssh.SshDsaPrivateKey;
import com.maverick.ssh.SshRsaPrivateCrtKey;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import com.maverick.ssh2.TripleDesCbc;
import com.sshtools.publickey.Base64EncodedFileFormat;
import com.sshtools.publickey.InvalidPassphraseException;
import com.sshtools.publickey.SshKeyPair;
import com.sshtools.publickey.SshPrivateKeyFile;
import java.io.IOException;
import java.math.BigInteger;

class H
extends Base64EncodedFileFormat
implements SshPrivateKeyFile {
    static String M = "---- BEGIN SSH2 ENCRYPTED PRIVATE KEY ----";
    static String O = "---- END SSH2 ENCRYPTED PRIVATE KEY ----";
    byte[] N;

    H(byte[] byArray) throws IOException {
        super(M, O);
        if (!H.D(byArray)) {
            throw new IOException("Key is not formatted in the ssh.com format");
        }
        this.N = byArray;
    }

    public String getType() {
        return "SSH Communications Security";
    }

    public static boolean D(byte[] byArray) {
        return Base64EncodedFileFormat.isFormatted(byArray, M, O);
    }

    public boolean supportsPassphraseChange() {
        return false;
    }

    public boolean isPassphraseProtected() {
        try {
            byte[] byArray = this.getKeyBlob(this.N);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            long l = byteArrayReader.readInt();
            if (l != 1064303083L) {
                throw new IOException("Invalid ssh.com key! Magic number not found");
            }
            long l2 = byteArrayReader.readInt();
            String string = byteArrayReader.readString();
            String string2 = byteArrayReader.readString();
            return string2.equals("3des-cbc");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public SshKeyPair toKeyPair(String string) throws IOException, InvalidPassphraseException {
        Object object;
        Object object2;
        TripleDesCbc tripleDesCbc;
        byte[] byArray = this.getKeyBlob(this.N);
        boolean bl = false;
        ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
        long l = byteArrayReader.readInt();
        if (l != 1064303083L) {
            throw new IOException("Invalid ssh.com key! Magic number not found");
        }
        long l2 = byteArrayReader.readInt();
        String string2 = byteArrayReader.readString();
        String string3 = byteArrayReader.readString();
        byte[] byArray2 = byteArrayReader.readBinaryString();
        if (!string3.equals("none")) {
            if (!string3.equals("3des-cbc")) {
                throw new IOException("Unsupported cipher type " + string3 + " in ssh.com private key");
            }
            tripleDesCbc = new TripleDesCbc();
            object2 = new byte[32];
            object = this.D(string);
            tripleDesCbc.init(1, object2, object);
            tripleDesCbc.transform(byArray2);
            bl = true;
        }
        try {
            tripleDesCbc = new ByteArrayReader(byArray2, 4, byArray2.length - 4);
            if (string2.startsWith("if-modn{sign{rsa")) {
                object2 = tripleDesCbc.readMPINT32();
                object = tripleDesCbc.readMPINT32();
                BigInteger bigInteger = tripleDesCbc.readMPINT32();
                BigInteger bigInteger2 = tripleDesCbc.readMPINT32();
                BigInteger bigInteger3 = tripleDesCbc.readMPINT32();
                BigInteger bigInteger4 = tripleDesCbc.readMPINT32();
                SshKeyPair sshKeyPair = new SshKeyPair();
                sshKeyPair.A = new Ssh2RsaPublicKey(bigInteger, (BigInteger)object2);
                sshKeyPair.B = new SshRsaPrivateCrtKey(bigInteger, (BigInteger)object2, (BigInteger)object, bigInteger3, bigInteger4, bigInteger2);
                return sshKeyPair;
            }
            if (string2.startsWith("dl-modp{sign{dsa")) {
                long l3 = tripleDesCbc.readInt();
                if (l3 != 0L) {
                    throw new IOException("Unexpected value in DSA key; this is an unsupported feature of ssh.com private keys");
                }
                BigInteger bigInteger = tripleDesCbc.readMPINT32();
                BigInteger bigInteger5 = tripleDesCbc.readMPINT32();
                BigInteger bigInteger6 = tripleDesCbc.readMPINT32();
                BigInteger bigInteger7 = tripleDesCbc.readMPINT32();
                BigInteger bigInteger8 = tripleDesCbc.readMPINT32();
                SshKeyPair sshKeyPair = new SshKeyPair();
                sshKeyPair.A = new Ssh2DsaPublicKey(bigInteger, bigInteger6, bigInteger5, bigInteger7);
                sshKeyPair.B = new SshDsaPrivateKey(bigInteger, bigInteger6, bigInteger5, bigInteger8);
                return sshKeyPair;
            }
            throw new IOException("Unsupported ssh.com key type " + string2);
        }
        catch (Throwable throwable) {
            if (bl) {
                throw new InvalidPassphraseException();
            }
            throw new IOException("Bad SSH.com private key format!");
        }
    }

    private byte[] D(String string) throws IOException {
        Hash hash = new Hash("MD5");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        hash.putBytes(string.getBytes());
        byte[] byArray = hash.doFinal();
        hash.reset();
        hash.putBytes(string.getBytes());
        hash.putBytes(byArray);
        byteArrayWriter.write(byArray);
        byteArrayWriter.write(hash.doFinal());
        return byteArrayWriter.toByteArray();
    }

    public void changePassphrase(String string, String string2) throws IOException {
        throw new IOException("Changing passphrase is not supported by the ssh.com key format engine");
    }

    public byte[] getFormattedKey() throws IOException {
        return this.N;
    }
}

