/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String string) {
        Log log = null;
        try {
            Object[] objectArray = new Object[]{string};
            log = (Log)logImplctor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            log = null;
        }
        if (log == null) {
            log = new NoOpLog(string);
        }
        return log;
    }

    private LogSource() {
    }

    public static String[] getLogNames() {
        String[] stringArray = new String[logs.size()];
        int n = 0;
        Enumeration enumeration = logs.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    static {
        try {
            log4jIsAvailable = Class.forName("org.apache.log4j.Logger") != null;
        }
        catch (Throwable throwable) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = Class.forName("java.util.logging.Logger") != null && Class.forName("org.apache.commons.logging.impl.Jdk14Logger") != null;
        }
        catch (Throwable throwable) {
            jdk14IsAvailable = false;
        }
        String string = null;
        try {
            string = System.getProperty("org.apache.commons.logging.log");
            if (string == null) {
                string = System.getProperty("org.apache.commons.logging.Log");
            }
        }
        catch (Throwable throwable) {}
        if (string != null) {
            try {
                LogSource.setLogImplementation(string);
            }
            catch (Throwable throwable) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable2) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable throwable) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable3) {}
            }
        }
    }

    public static void setLogImplementation(String string) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{"".getClass()};
            logImplctor = clazz.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class clazz) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] classArray = new Class[]{"".getClass()};
        logImplctor = clazz.getConstructor(classArray);
    }

    public static Log getInstance(String string) {
        Log log = (Log)logs.get(string);
        if (log == null) {
            log = LogSource.makeNewLogInstance(string);
            logs.put(string, log);
        }
        return log;
    }
}

