/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.ssh.SshException;
import com.maverick.ssh2.TransportProtocol;
import java.math.BigInteger;

public abstract class SshKeyExchange {
    protected BigInteger secret;
    protected byte[] exchangeHash;
    protected byte[] hostKey;
    protected byte[] signature;
    protected TransportProtocol transport;

    public abstract String getAlgorithm();

    public byte[] getExchangeHash() {
        return this.exchangeHash;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public BigInteger getSecret() {
        return this.secret;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void init(TransportProtocol transportProtocol) throws SshException {
        this.transport = transportProtocol;
    }

    public abstract void performClientExchange(String var1, String var2, byte[] var3, byte[] var4) throws SshException;

    public abstract boolean isKeyExchangeMessage(int var1);

    public void reset() {
        this.exchangeHash = null;
        this.hostKey = null;
        this.signature = null;
        this.secret = null;
    }
}

