/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.digests.HMac;
import com.maverick.ssh.SshException;
import java.io.IOException;

public class SshHmac {
    HMac B;
    String A;

    public SshHmac(String string, HMac hMac) {
        this.A = string;
        this.B = hMac;
    }

    public String getAlgorithm() {
        return this.A;
    }

    public int getMacLength() {
        return this.B.getMacSize();
    }

    public void generate(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)(l >> 0)};
        this.B.update(byArray3, 0, byArray3.length);
        this.B.update(byArray, n, n2);
        this.B.doFinal(byArray2, n3);
    }

    public void init(byte[] byArray) throws SshException {
        byte[] byArray2 = new byte[this.B.getMacSize()];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            this.B.init(byArray2);
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public boolean verify(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws SshException {
        if (byArray.length < n + n2) {
            throw new SshException("Not enough data for message and mac!", 5);
        }
        if (byArray2.length - n3 < this.getMacLength()) {
            throw new SshException(String.valueOf(this.getMacLength()) + " bytes of MAC data required!", 5);
        }
        byte[] byArray3 = new byte[this.getMacLength()];
        this.generate(l, byArray, n, n2, byArray3, 0);
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[n3 + i]) continue;
            return false;
        }
        return true;
    }
}

