/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh2;

import com.maverick.crypto.io.ByteArrayWriter;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.ssh.PublicKeyAuthentication;
import com.maverick.ssh.SshException;
import com.maverick.ssh2.C;
import com.maverick.ssh2.D;
import com.maverick.ssh2.E;
import com.maverick.ssh2.SignatureGenerator;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class Ssh2PublicKeyAuthentication
extends PublicKeyAuthentication
implements C {
    static final int T = 60;
    SignatureGenerator U;

    public void authenticate(D d, String string) throws SshException, E {
        try {
            byte[] byArray;
            Object object;
            String string2;
            RsaPublicKey rsaPublicKey;
            if (this.getPublicKey() == null) {
                throw new SshException("Public key not set!", 4);
            }
            if (this.getPrivateKey() == null && this.U == null && this.isAuthenticating()) {
                throw new SshException("Private key or signature generator not set!", 4);
            }
            if (this.getUsername() == null) {
                throw new SshException("Username not set!", 4);
            }
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeBinaryString(d.C());
            byteArrayWriter.write(50);
            byteArrayWriter.writeString(this.getUsername());
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeString("publickey");
            byteArrayWriter.writeBoolean(this.isAuthenticating());
            if (!(this.getPublicKey() instanceof Ssh2DsaPublicKey) && !(this.getPublicKey() instanceof Ssh2RsaPublicKey)) {
                try {
                    if (!this.getPublicKey().getClass().isAssignableFrom(Class.forName("com.maverick.ssh1.Ssh1RsaPublicKey"))) {
                        throw new SshException("Unsupported public key type " + this.getPublicKey().getAlgorithm(), 4);
                    }
                    rsaPublicKey = (RsaPublicKey)this.getPublicKey();
                    string2 = "ssh-rsa";
                    byteArrayWriter.writeString("ssh-rsa");
                    object = new ByteArrayWriter();
                    object.writeString("ssh-rsa");
                    object.writeBigInteger(rsaPublicKey.getPublicExponent());
                    object.writeBigInteger(rsaPublicKey.getModulus());
                    byArray = ((ByteArrayOutputStream)object).toByteArray();
                    byteArrayWriter.writeBinaryString(byArray);
                }
                catch (Throwable throwable) {
                    throw new SshException("Unsupported public key type " + this.getPublicKey().getAlgorithm(), 4);
                }
            } else {
                string2 = this.getPublicKey().getAlgorithm();
                byteArrayWriter.writeString(string2);
                byArray = this.getPublicKey().getEncoded();
                byteArrayWriter.writeBinaryString(byArray);
            }
            rsaPublicKey = new ByteArrayWriter();
            rsaPublicKey.writeBoolean(this.isAuthenticating());
            rsaPublicKey.writeString(string2);
            rsaPublicKey.writeBinaryString(byArray);
            if (this.isAuthenticating()) {
                object = this.U != null ? (Object)this.U.sign(this.getPublicKey(), byteArrayWriter.toByteArray()) : (Object)this.getPrivateKey().sign(byteArrayWriter.toByteArray());
                ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
                byteArrayWriter2.writeString(string2);
                byteArrayWriter2.writeBinaryString((byte[])object);
                rsaPublicKey.writeBinaryString(byteArrayWriter2.toByteArray());
            }
            d.A(this.getUsername(), string, "publickey", rsaPublicKey.toByteArray());
            object = d.A();
            if (object[0] == 60) {
                throw new E(5);
            }
            d.G.disconnect(2, "Unexpected message " + (int)object[0] + " received");
            throw new SshException("Unexpected message " + (int)object[0] + " received", 3);
        }
        catch (IOException iOException) {
            throw new SshException(iOException.getMessage(), 5);
        }
    }

    public void setSignatureGenerator(SignatureGenerator signatureGenerator) {
        this.U = signatureGenerator;
    }
}

