/*
 * Decompiled with CFR 0.152.
 */
package com.sslexplorer.vpn.base;

import com.sslexplorer.vpn.base.VPNTunnel;
import com.sslexplorer.vpn.base.VPNTunnelListener;
import com.sslexplorer.vpn.util.IOStreamConnector;
import com.sslexplorer.vpn.util.IOStreamConnectorListener;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VPNTCPTunnel
implements VPNTunnel {
    Socket tunnel;
    Socket client;
    String destinationHost;
    int destinationPort;
    IOStreamConnector tx;
    IOStreamConnector rx;
    IOStreamListener listener = new IOStreamListener();
    Vector listeners;
    IOStreamConnectorListener txListener;
    IOStreamConnectorListener rxListener;
    Log log = LogFactory.getLog((Class)(class$com$sslexplorer$vpn$base$AbstractVPNClient != null ? class$com$sslexplorer$vpn$base$AbstractVPNClient : (class$com$sslexplorer$vpn$base$AbstractVPNClient = VPNTCPTunnel.class$("com.sslexplorer.vpn.base.AbstractVPNClient"))));
    private static /* synthetic */ Class class$com$sslexplorer$vpn$base$AbstractVPNClient;

    public void addListener(VPNTunnelListener vPNTunnelListener) {
        if (vPNTunnelListener != null) {
            this.listeners.addElement(vPNTunnelListener);
        }
    }

    public void stop() {
        if (!this.rx.isClosed()) {
            this.rx.close();
        }
        if (!this.tx.isClosed()) {
            this.tx.close();
        }
        int n = 0;
        while (n < this.listeners.size()) {
            ((VPNTunnelListener)this.listeners.elementAt(n)).stopped(this);
            ++n;
        }
    }

    VPNTCPTunnel(Socket socket, Socket socket2, String string, int n, IOStreamConnectorListener iOStreamConnectorListener, IOStreamConnectorListener iOStreamConnectorListener2) {
        this.tunnel = socket;
        this.client = socket2;
        this.destinationHost = string;
        this.destinationPort = n;
        this.txListener = iOStreamConnectorListener;
        this.rxListener = iOStreamConnectorListener2;
        this.listeners = new Vector();
    }

    public String getDestinationHost() {
        return this.destinationHost;
    }

    public String getClientHost() {
        return this.client.getInetAddress().getHostName();
    }

    public void start() throws IOException {
        try {
            this.rx = new IOStreamConnector();
            this.rx.addListener(this.listener);
            if (this.rxListener != null) {
                this.rx.addListener(this.rxListener);
            }
            this.rx.setCloseInput(false);
            this.rx.connect(this.tunnel.getInputStream(), this.client.getOutputStream());
            this.tx = new IOStreamConnector();
            this.tx.addListener(this.listener);
            if (this.txListener != null) {
                this.tx.addListener(this.txListener);
            }
            this.tx.setCloseOutput(false);
            this.tx.connect(this.client.getInputStream(), this.tunnel.getOutputStream());
            int n = 0;
            while (n < this.listeners.size()) {
                ((VPNTunnelListener)this.listeners.elementAt(n)).started(this);
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable);
            try {
                this.client.close();
            }
            catch (Throwable throwable2) {}
            try {
                this.tunnel.close();
            }
            catch (Throwable throwable3) {}
            throw new IOException("The tunnel failed to start: " + throwable.getMessage());
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    class IOStreamListener
    implements IOStreamConnectorListener {
        boolean hasStopped;

        IOStreamListener() {
            VPNTCPTunnel.this.getClass();
            this.hasStopped = false;
        }

        public synchronized void connectorClosed(IOStreamConnector iOStreamConnector) {
            try {
                VPNTCPTunnel.this.client.close();
            }
            catch (IOException iOException) {}
            try {
                VPNTCPTunnel.this.tunnel.close();
            }
            catch (Exception exception) {}
            if (!this.hasStopped) {
                VPNTCPTunnel.this.stop();
                this.hasStopped = true;
            }
        }

        public void dataTransfered(byte[] byArray, int n) {
            int n2 = VPNTCPTunnel.this.listeners.size() - 1;
            while (n2 >= 0) {
                ((VPNTunnelListener)VPNTCPTunnel.this.listeners.elementAt(n2)).dataTransferred(VPNTCPTunnel.this, byArray, n);
                --n2;
            }
        }
    }
}

