/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ui.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class UIUtil {
    private static URL codebase;
    private static Hashtable imageCache;
    private static Frame sharedFrame;
    public static final int CENTER = 0;
    public static final int NORTH = 1;
    public static final int NORTH_EAST = 2;
    public static final int EAST = 3;
    public static final int SOUTH_EAST = 4;
    public static final int SOUTH = 5;
    public static final int SOUTH_WEST = 6;
    public static final int WEST = 7;
    public static final int NORTH_WEST = 8;

    public static void positionComponent(int n, Component component) {
        Rectangle rectangle = null;
        try {
            throw new Exception();
        }
        catch (Throwable throwable) {
            if (rectangle == null) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle = new Rectangle(0, 0, dimension != null ? dimension.width : 800, dimension != null ? dimension.height : 600);
                if (rectangle.width > 2 * rectangle.height) {
                    rectangle.width /= 2;
                }
            }
            switch (n) {
                case 8: {
                    component.setLocation(rectangle.x, rectangle.y);
                    break;
                }
                case 1: {
                    component.setLocation(rectangle.x + (rectangle.width - component.getSize().width) / 2, rectangle.y);
                    break;
                }
                case 2: {
                    component.setLocation(rectangle.x + (rectangle.width - component.getSize().width), rectangle.y);
                    break;
                }
                case 7: {
                    component.setLocation(rectangle.x, rectangle.y + (rectangle.height - component.getSize().height) / 2);
                    break;
                }
                case 6: {
                    component.setLocation(rectangle.x, rectangle.y + (rectangle.height - component.getSize().height));
                    break;
                }
                case 3: {
                    component.setLocation(rectangle.x + rectangle.width - component.getSize().width, rectangle.y + (rectangle.height - component.getSize().height) / 2);
                    break;
                }
                case 4: {
                    component.setLocation(rectangle.x + (rectangle.width - component.getSize().width), rectangle.y + (rectangle.height - component.getSize().height) - 30);
                    break;
                }
                case 0: {
                    component.setLocation(rectangle.x + (rectangle.width - component.getSize().width) / 2, rectangle.y + (rectangle.height - component.getSize().height) / 2);
                    break;
                }
            }
            return;
        }
    }

    public static void gridBagAdd(Container container, Component component, GridBagConstraints gridBagConstraints, int n) {
        if (!(container.getLayout() instanceof GridBagLayout)) {
            throw new IllegalArgumentException("parent must have a GridBagLayout");
        }
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        gridBagConstraints.gridwidth = n;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    public static Window getWindowAncestor(Component component) {
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public static Frame getSharedFrame() {
        if (sharedFrame == null) {
            sharedFrame = new Frame();
        }
        return sharedFrame;
    }

    public static void setCodeBase(URL uRL) {
        codebase = uRL;
    }

    public static Image loadImage(Class clazz, String string) {
        String string2 = string;
        URL uRL = clazz.getResource(string2);
        Image image = null;
        if (uRL != null) {
            image = (Image)imageCache.get(uRL.toExternalForm());
            if (image == null && (image = Toolkit.getDefaultToolkit().getImage(uRL)) != null) {
                imageCache.put(uRL.toExternalForm(), image);
            }
        } else if (codebase != null) {
            try {
                URL uRL2 = new URL(codebase, string);
                image = (Image)imageCache.get(uRL2.toExternalForm());
                if (image == null && (image = Toolkit.getDefaultToolkit().getImage(uRL2)) != null) {
                    imageCache.put(uRL2.toExternalForm(), image);
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                image = null;
            }
        }
        if (image == null && (image = (Image)imageCache.get(string2)) == null && (image = Toolkit.getDefaultToolkit().getImage(string2)) != null) {
            imageCache.put(string2, image);
        }
        if (image == null) {
            System.err.println("Could not locate image " + image);
        } else {
            System.err.println("Got image " + string + " as " + image);
        }
        return image;
    }

    static {
        imageCache = new Hashtable();
    }

    public static Image waitFor(Image image, Component component) {
        block3: {
            if (image != null) {
                MediaTracker mediaTracker = new MediaTracker(component);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                    return image;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    if (!mediaTracker.isErrorAny()) break block3;
                    System.err.println("Image did not load. " + image.toString());
                }
            }
        }
        System.err.println("No image???");
        return null;
    }

    public static Frame getFrameAncestor(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }
}

