/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl.https;

import com.maverick.http.ConnectMethod;
import com.maverick.http.HttpClient;
import com.maverick.http.HttpException;
import com.maverick.http.HttpResponse;
import com.maverick.http.PasswordCredentials;
import com.maverick.http.UnsupportedAuthenticationException;
import com.maverick.ssl.SSLException;
import com.maverick.ssl.SSLIOException;
import com.maverick.ssl.SSLSocket;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpsURLConnection
extends HttpURLConnection {
    boolean debugging;
    ByteArrayOutputStream output = new ByteArrayOutputStream();
    Vector requestKeys;
    Vector requestValues;
    Vector headers = new Vector();
    Vector headerKeys = new Vector();
    Hashtable headerValues = new Hashtable();
    Socket socket;
    PushbackInputStream input;
    int responseCode = -1;
    String responseMessage;
    private static Log log = LogFactory.getLog((Class)(class$com$maverick$ssl$https$HttpsURLConnection != null ? class$com$maverick$ssl$https$HttpsURLConnection : (class$com$maverick$ssl$https$HttpsURLConnection = HttpsURLConnection.class$("com.maverick.ssl.https.HttpsURLConnection"))));
    public static final String httpProxyHostProperty = "com.maverick.ssl.https.HTTPProxyHostname";
    public static final String httpProxyPortProperty = "com.maverick.ssl.https.HTTPProxyPort";
    public static final String httpProxyUsernameProperty = "com.maverick.ssl.https.HTTPProxyUsername";
    public static final String httpProxyPasswordProperty = "com.maverick.ssl.https.HTTPProxyPassword";
    public static final String httpProxySecureProperty = "com.maverick.ssl.https.HTTPProxySecure";
    public static final String httpProxyNonProxyHostsProperty = "com.maverick.ssl.https.HTTPProxyNonProxyHosts";
    static Vector defaultRequestKeys = new Vector();
    static Vector defaultRequestValues = new Vector();
    private static /* synthetic */ Class class$com$maverick$ssl$https$HttpsURLConnection;

    private boolean isNonProxiedHost(String string) {
        String string2 = System.getProperty(httpProxyNonProxyHostsProperty);
        if (string2 == null || string2.equals("")) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (stringTokenizer.hasMoreTokens()) {
            if (!string.equalsIgnoreCase(stringTokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    public static void setDefaultRequestProperty(String string, String string2) {
        Vector vector = defaultRequestKeys;
        synchronized (vector) {
            block5: {
                int n = 0;
                while (n < defaultRequestKeys.size() && !string.equalsIgnoreCase((String)defaultRequestKeys.elementAt(n))) {
                    ++n;
                }
                if (n < defaultRequestKeys.size()) {
                    defaultRequestValues.removeElementAt(n);
                    defaultRequestKeys.removeElementAt(n);
                }
                if (string2 == null) break block5;
                defaultRequestValues.addElement(string2);
                defaultRequestKeys.addElement(string);
            }
            Object var4_4 = null;
        }
    }

    public static String getDefaultRequestProperty(String string) {
        Vector vector = defaultRequestKeys;
        synchronized (vector) {
            int n = 0;
            while (n < defaultRequestKeys.size() && !string.equalsIgnoreCase((String)defaultRequestKeys.elementAt(n))) {
                ++n;
            }
            if (n < defaultRequestKeys.size()) {
                String string2 = (String)defaultRequestValues.elementAt(n);
                Object var3_5 = null;
                return string2;
            }
            String string3 = null;
            Object var3_6 = null;
            return string3;
        }
    }

    public synchronized void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        int n = 0;
        while (n < this.requestKeys.size() && !string.equalsIgnoreCase((String)this.requestKeys.elementAt(n))) {
            ++n;
        }
        if (n < this.requestKeys.size()) {
            this.requestValues.removeElementAt(n);
            this.requestKeys.removeElementAt(n);
        }
        if (string2 != null) {
            this.requestValues.addElement(string2);
            this.requestKeys.addElement(string);
        }
    }

    public String getRequestProperty(String string) {
        int n = 0;
        while (n < this.requestKeys.size() && !string.equalsIgnoreCase((String)this.requestKeys.elementAt(n))) {
            ++n;
        }
        if (n < this.requestKeys.size()) {
            return (String)this.requestValues.elementAt(n);
        }
        return null;
    }

    void readResponse(PushbackInputStream pushbackInputStream) throws IOException {
        String string;
        DataInputStream dataInputStream = new DataInputStream(pushbackInputStream);
        while ((string = dataInputStream.readLine()) != null && string.length() > 0) {
            Object object;
            this.headers.addElement(string);
            int n = string.indexOf(58);
            if (n >= 0) {
                object = string.substring(0, n);
                String string2 = string.substring(n + 1).trim();
                this.headerKeys.addElement(object);
                this.headerValues.put(((String)object).toLowerCase(), string2);
                continue;
            }
            if (this.headerValues.size() != 0) continue;
            if (string.startsWith("HTTP/")) {
                try {
                    int n2 = string.indexOf(32);
                    while (string.charAt(++n2) == ' ') {
                    }
                    this.responseMessage = string.substring(n2 + 4);
                    this.responseCode = Integer.parseInt(string.substring(n2, n2 + 3));
                }
                catch (Throwable throwable) {
                    this.responseCode = 200;
                }
                continue;
            }
            this.responseCode = 200;
            object = string.getBytes();
            pushbackInputStream.unread((byte[])object);
            break;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new IOException("Protocol input not configured.");
        }
        this.connect();
        return this.input;
    }

    public HttpsURLConnection(URL uRL) {
        super(uRL);
        Vector vector = defaultRequestKeys;
        synchronized (vector) {
            this.requestKeys = (Vector)defaultRequestKeys.clone();
            this.requestValues = (Vector)defaultRequestValues.clone();
            Object var3_3 = null;
        }
    }

    public int getResponseCode() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        return this.responseCode;
    }

    public boolean usingProxy() {
        return System.getProperty(httpProxyHostProperty) != null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.doOutput) {
            throw new IOException("Protocol output not configured.");
        }
        if (this.connected) {
            throw new IOException("Already connected");
        }
        return this.output;
    }

    public void disconnect() {
    }

    public String getResponseMessage() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        this.getResponseCode();
        return this.responseMessage;
    }

    public Socket getSocket() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        return this.socket;
    }

    static {
        defaultRequestKeys.addElement("User-agent");
        defaultRequestValues.addElement("Maverick/SSL");
    }

    public String getHeaderField(String string) {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        return (String)this.headerValues.get(string.toLowerCase());
    }

    public String getHeaderField(int n) {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        if (n < this.headers.size()) {
            return (String)this.headers.elementAt(n);
        }
        return null;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void addRequestProperty(String string, String string2) {
        this.setRequestProperty(string, string2);
    }

    void writeRequest(OutputStream outputStream) throws IOException {
        Object object;
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
        if (this.doOutput && this.output == null) {
            throw new IOException("No POST data specified");
        }
        if (this.ifModifiedSince != 0L) {
            Date date = new Date(this.ifModifiedSince);
            object = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("GMT"));
            this.setRequestProperty("If-Modified-Since", ((DateFormat)object).format(date));
        }
        if (this.doOutput) {
            this.setRequestProperty("Content-length", "" + this.output.size());
        }
        dataOutputStream.writeBytes((this.doOutput ? "POST" : "GET") + " " + (this.url.getFile().equals("") ? "/" : this.url.getFile()) + " HTTP/1.0\r\n");
        int n = 0;
        while (n < this.requestKeys.size()) {
            object = (String)this.requestKeys.elementAt(n);
            if (!((String)object).startsWith("Proxy-")) {
                dataOutputStream.writeBytes((String)object + ": " + this.requestValues.elementAt(n) + "\r\n");
            }
            ++n;
        }
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.flush();
        if (this.doOutput) {
            this.output.writeTo(outputStream);
        }
        outputStream.flush();
    }

    public String getHeaderFieldKey(int n) {
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        if (n < this.headerKeys.size()) {
            return (String)this.headerKeys.elementAt(n);
        }
        return null;
    }

    public synchronized void connect() throws IOException {
        if (!this.connected) {
            log.info((Object)("Connecting HTTPS URL to " + this.url.getHost() + ":" + (this.url.getPort() == -1 ? 443 : this.url.getPort())));
            String string = System.getProperty(httpProxyHostProperty);
            if (string != null && !this.isNonProxiedHost(this.url.getHost())) {
                boolean bl = Boolean.valueOf(System.getProperty(httpProxySecureProperty, "true"));
                String string2 = System.getProperty(httpProxyPortProperty);
                String string3 = System.getProperty(httpProxyUsernameProperty);
                String string4 = System.getProperty(httpProxyPasswordProperty);
                log.info((Object)("Requires proxy connection through " + (bl ? "https" : "http://") + string + ":" + string2));
                log.info((Object)("Proxy username is " + (string3 == null || string3.equals("") ? "not set" : string3)));
                if (string2 == null) {
                    throw new IOException("No proxy port configured.");
                }
                try {
                    int n = Integer.parseInt(string2);
                    HttpClient httpClient = new HttpClient();
                    ConnectMethod connectMethod = new ConnectMethod(this.url.getHost(), this.url.getPort() == -1 ? 443 : this.url.getPort(), true);
                    PasswordCredentials passwordCredentials = new PasswordCredentials();
                    passwordCredentials.setUsername(string3);
                    passwordCredentials.setPassword(string4);
                    httpClient.setCredentials(string, passwordCredentials);
                    HttpResponse httpResponse = httpClient.execute(connectMethod, string, n, bl);
                    this.socket = httpResponse.getConnection().getSocket();
                }
                catch (HttpException httpException) {
                    log.info((Object)("Proxy connection failed: " + httpException.getMessage() + " [" + httpException.getStatus() + "]"));
                    throw new IOException("Proxy connection failed: " + httpException.getMessage() + " [" + httpException.getStatus() + "]");
                }
                catch (UnsupportedAuthenticationException unsupportedAuthenticationException) {
                    log.info((Object)"Proxy authentication failed", (Throwable)unsupportedAuthenticationException);
                    throw new IOException(unsupportedAuthenticationException.getMessage());
                }
            }
            String string5 = this.url.getHost();
            if (string5 == null) {
                throw new IOException("No host specified.");
            }
            int n = this.url.getPort();
            try {
                this.socket = new SSLSocket(string5, n == -1 ? 443 : n);
            }
            catch (SSLException sSLException) {
                throw new SSLIOException(sSLException);
            }
            try {
                this.writeRequest(this.socket.getOutputStream());
                this.input = new PushbackInputStream(this.socket.getInputStream(), 2048);
                this.readResponse(this.input);
            }
            catch (IOException iOException) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException2) {}
                throw iOException;
            }
            this.connected = true;
        }
    }
}

