/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl;

import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.DERInputStream;
import com.maverick.crypto.asn1.x509.CertificateException;
import com.maverick.crypto.asn1.x509.X509Certificate;
import com.maverick.crypto.asn1.x509.X509CertificateStructure;
import com.maverick.crypto.digests.MD5Digest;
import com.maverick.crypto.digests.SHA1Digest;
import com.maverick.crypto.publickey.PublicKey;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPublicKey;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssl.SSLCipherSuite;
import com.maverick.ssl.SSLCipherSuiteID;
import com.maverick.ssl.SSLContext;
import com.maverick.ssl.SSLException;
import com.maverick.ssl.SSLTransport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SSLHandshakeProtocol {
    static final int HANDSHAKE_PROTOCOL_MSG = 22;
    static final int HELLO_REQUEST_MSG = 0;
    static final int CLIENT_HELLO_MSG = 1;
    static final int SERVER_HELLO_MSG = 2;
    static final int CERTIFICATE_MSG = 11;
    static final int KEY_EXCHANGE_MSG = 12;
    static final int CERTIFICATE_REQUEST_MSG = 13;
    static final int SERVER_HELLO_DONE_MSG = 14;
    static final int CERTIFICATE_VERIFY_MSG = 15;
    static final int CLIENT_KEY_EXCHANGE_MSG = 16;
    static final int FINISHED_MSG = 20;
    static final int HANDSHAKE_PENDING_OR_COMPLETE = -1;
    SSLContext context;
    SSLTransport socket;
    MD5Digest handshakeMD5 = new MD5Digest();
    SHA1Digest handshakeSHA1 = new SHA1Digest();
    SSLCipherSuiteID cipherSuiteID;
    int compressionID;
    byte[] sessionID;
    int majorVersion;
    int minorVersion;
    byte[] clientRandom;
    byte[] serverRandom;
    byte[] premasterSecret;
    byte[] masterSecret;
    X509Certificate x509;
    SSLCipherSuite pendingCipherSuite;
    int currentHandshakeStep = -1;
    Log log = LogFactory.getLog((Class)(class$com$maverick$ssl$SSLHandshakeProtocol != null ? class$com$maverick$ssl$SSLHandshakeProtocol : (class$com$maverick$ssl$SSLHandshakeProtocol = SSLHandshakeProtocol.class$("com.maverick.ssl.SSLHandshakeProtocol"))));
    private static /* synthetic */ Class class$com$maverick$ssl$SSLHandshakeProtocol;

    public void startHandshake() throws SSLException {
        if (this.currentHandshakeStep != -1) {
            throw new SSLException(999, "Handshake cannot be started as a handshake operation is in progress");
        }
        this.log.debug((Object)"Starting SSL Handshake");
        this.sendClientHello();
    }

    private void sendHandshakeFinished() throws SSLException {
        this.completeHandshakeHashes();
        this.log.debug((Object)"Sending client FINISHED");
        byte[] byArray = new byte[this.handshakeMD5.getDigestSize() + this.handshakeSHA1.getDigestSize()];
        this.handshakeMD5.doFinal(byArray, 0);
        this.handshakeSHA1.doFinal(byArray, this.handshakeMD5.getDigestSize());
        this.sendMessage(20, byArray);
        this.currentHandshakeStep = 20;
    }

    public SSLHandshakeProtocol(SSLTransport sSLTransport, SSLContext sSLContext) throws IOException {
        this.socket = sSLTransport;
        this.context = sSLContext;
    }

    SSLCipherSuite getPendingCipherSuite() {
        return this.pendingCipherSuite;
    }

    private void debugBytes(byte[] byArray, String string) {
        System.out.print(string + ": ");
        int n = 0;
        while (n < byArray.length) {
            System.out.print(Integer.toHexString(byArray[n] & 0xFF));
            ++n;
        }
        System.out.println();
    }

    private void sendMessage(int n, byte[] byArray) throws SSLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(n);
            byteArrayOutputStream.write(byArray.length >> 16 & 0xFF);
            byteArrayOutputStream.write(byArray.length >> 8 & 0xFF);
            byteArrayOutputStream.write(byArray.length);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (n != 20) {
            this.updateHandshakeHashes(byArray2);
        }
        this.socket.sendMessage(22, byArray2);
    }

    void updateHandshakeHashes(byte[] byArray) {
        this.log.debug((Object)"Updating handshake hashes");
        this.handshakeMD5.update(byArray, 0, byArray.length);
        this.handshakeSHA1.update(byArray, 0, byArray.length);
    }

    private void completeHandshakeHashes() {
        this.log.debug((Object)"Completing handshake hashes");
        this.handshakeMD5.update((byte)67);
        this.handshakeMD5.update((byte)76);
        this.handshakeMD5.update((byte)78);
        this.handshakeMD5.update((byte)84);
        this.handshakeMD5.update(this.masterSecret, 0, this.masterSecret.length);
        int n = 0;
        do {
            this.handshakeMD5.update((byte)54);
        } while (++n < 48);
        byte[] byArray = new byte[this.handshakeMD5.getDigestSize()];
        this.handshakeMD5.doFinal(byArray, 0);
        this.handshakeMD5.reset();
        this.log.debug((Object)("Master secret is " + this.masterSecret.length + " bytes long and first byte is " + this.masterSecret[0]));
        this.handshakeMD5.update(this.masterSecret, 0, this.masterSecret.length);
        int n2 = 0;
        do {
            this.handshakeMD5.update((byte)92);
        } while (++n2 < 48);
        this.handshakeMD5.update(byArray, 0, byArray.length);
        this.handshakeSHA1.update((byte)67);
        this.handshakeSHA1.update((byte)76);
        this.handshakeSHA1.update((byte)78);
        this.handshakeSHA1.update((byte)84);
        this.handshakeSHA1.update(this.masterSecret, 0, this.masterSecret.length);
        n2 = 0;
        do {
            this.handshakeSHA1.update((byte)54);
        } while (++n2 < 40);
        byArray = new byte[this.handshakeSHA1.getDigestSize()];
        this.handshakeSHA1.doFinal(byArray, 0);
        this.handshakeSHA1.reset();
        this.handshakeSHA1.update(this.masterSecret, 0, this.masterSecret.length);
        n2 = 0;
        do {
            this.handshakeSHA1.update((byte)92);
        } while (++n2 < 40);
        this.handshakeSHA1.update(byArray, 0, byArray.length);
    }

    private void onServerHelloDoneMsg() throws SSLException {
        Object object;
        BigInteger bigInteger;
        Object object2;
        Object object3;
        Object object4;
        block9: {
            this.calculatePreMasterSecret();
            object4 = null;
            try {
                object3 = new BigInteger(1, this.premasterSecret);
                PublicKey publicKey = this.x509.getPublicKey();
                if (publicKey instanceof RsaPublicKey) {
                    object2 = Rsa.padPKCS1((BigInteger)object3, (int)2, (int)128, (SecureRandom)new SecureRandom());
                    bigInteger = Rsa.doPublic((BigInteger)object2, (BigInteger)((RsaPublicKey)publicKey).getModulus(), (BigInteger)((RsaPublicKey)publicKey).getPublicExponent());
                    object4 = bigInteger.toByteArray();
                    break block9;
                }
                throw new SSLException(43);
            }
            catch (CertificateException certificateException) {
                throw new SSLException(43, certificateException.getMessage());
            }
            catch (IOException iOException) {
                throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
            }
        }
        if (object4[0] == 0) {
            object3 = new byte[((byte[])object4).length - 1];
            System.arraycopy(object4, 1, object3, 0, ((byte[])object4).length - 1);
            object4 = object3;
        }
        this.sendMessage(16, (byte[])object4);
        this.calculateMasterSecret();
        this.log.debug((Object)"Generating key data");
        int n = 0;
        n += this.pendingCipherSuite.getKeyLength() * 2;
        n += this.pendingCipherSuite.getMACLength() * 2;
        n += this.pendingCipherSuite.getIVLength() * 2;
        object2 = new ByteArrayOutputStream();
        bigInteger = new MD5Digest();
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n2 = 0;
        while (((ByteArrayOutputStream)object2).size() < n) {
            bigInteger.reset();
            sHA1Digest.reset();
            int n3 = 0;
            while (n3 <= n2) {
                sHA1Digest.update((byte)(65 + n2));
                ++n3;
            }
            sHA1Digest.update(this.masterSecret, 0, this.masterSecret.length);
            sHA1Digest.update(this.serverRandom, 0, this.serverRandom.length);
            sHA1Digest.update(this.clientRandom, 0, this.clientRandom.length);
            bigInteger.update(this.masterSecret, 0, this.masterSecret.length);
            object = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal((byte[])object, 0);
            bigInteger.update((byte[])object, 0, ((Object)object).length);
            object = new byte[bigInteger.getDigestSize()];
            bigInteger.doFinal((byte[])object, 0);
            ((ByteArrayOutputStream)object2).write((byte[])object, 0, ((Object)object).length);
            ++n2;
        }
        object3 = ((ByteArrayOutputStream)object2).toByteArray();
        object = new ByteArrayInputStream((byte[])object3);
        byte[] byArray = new byte[this.pendingCipherSuite.getKeyLength()];
        byte[] byArray2 = new byte[this.pendingCipherSuite.getIVLength()];
        byte[] byArray3 = new byte[this.pendingCipherSuite.getMACLength()];
        byte[] byArray4 = new byte[this.pendingCipherSuite.getKeyLength()];
        byte[] byArray5 = new byte[this.pendingCipherSuite.getIVLength()];
        byte[] byArray6 = new byte[this.pendingCipherSuite.getMACLength()];
        try {
            ((InputStream)object).read(byArray3);
            ((InputStream)object).read(byArray6);
            ((InputStream)object).read(byArray);
            ((InputStream)object).read(byArray4);
            ((InputStream)object).read(byArray2);
            ((InputStream)object).read(byArray5);
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        this.pendingCipherSuite.init(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
        this.currentHandshakeStep = 14;
        this.socket.sendCipherChangeSpec(this.pendingCipherSuite);
        this.sendHandshakeFinished();
    }

    void processMessage(byte[] byArray, int n, int n2) throws SSLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        this.updateHandshakeHashes(byArray);
        block11: while (byteArrayInputStream.available() > 0 && !this.isComplete()) {
            int n3 = byteArrayInputStream.read();
            int n4 = (byteArrayInputStream.read() & 0xFF) << 16 | (byteArrayInputStream.read() & 0xFF) << 8 | byteArrayInputStream.read() & 0xFF;
            this.log.debug((Object)("Handshake protocol is processing type " + n3 + " with " + n4 + " bytes of message data"));
            byte[] byArray2 = new byte[n4];
            try {
                byteArrayInputStream.read(byArray2);
            }
            catch (IOException iOException) {
                throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
            }
            switch (n3) {
                case 0: {
                    this.log.debug((Object)"Received HELLO request");
                    if (this.currentHandshakeStep != -1) continue block11;
                    this.startHandshake();
                    break;
                }
                case 2: {
                    this.log.debug((Object)"Received server HELLO message");
                    if (this.currentHandshakeStep != 1) {
                        throw new SSLException(999, "Server HELLO message received but not expected (" + this.currentHandshakeStep + ")");
                    }
                    this.onServerHelloMsg(byArray2);
                    break;
                }
                case 11: {
                    this.log.debug((Object)"Received server certificate");
                    if (this.currentHandshakeStep != 2) {
                        throw new SSLException(999, "Certificate message received but not expected (" + this.currentHandshakeStep + ")");
                    }
                    this.onCertificateMsg(byArray2);
                    break;
                }
                case 12: {
                    this.log.debug((Object)"Received server key exchange [Unsupported operation]");
                    throw new SSLException(998, "We currently dont support server key exchange!");
                }
                case 13: {
                    this.log.debug((Object)"Received client certificate request [Unsupported operation]");
                    throw new SSLException(998, "We currently dont support certifcate requests!");
                }
                case 14: {
                    this.log.debug((Object)"Received server HELLO DONE");
                    if (this.currentHandshakeStep != 11) {
                        throw new SSLException(999, "Server HELLO DONE message received but not expected (" + this.currentHandshakeStep + ")");
                    }
                    this.onServerHelloDoneMsg();
                    break;
                }
                case 20: {
                    this.log.debug((Object)"Received server FINISHED");
                    if (this.currentHandshakeStep != 20) {
                        throw new SSLException(999);
                    }
                    this.currentHandshakeStep = -1;
                    break;
                }
            }
        }
    }

    private void onCertificateMsg(byte[] byArray) throws SSLException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        byteArrayInputStream.read();
        try {
            boolean bl = false;
            while (byteArrayInputStream.available() > 0 && !bl) {
                byteArrayInputStream.read();
                byteArrayInputStream.read();
                byteArrayInputStream.read();
                DERInputStream dERInputStream = new DERInputStream((InputStream)byteArrayInputStream);
                ASN1Sequence aSN1Sequence = (ASN1Sequence)dERInputStream.readObject();
                this.x509 = new X509Certificate(X509CertificateStructure.getInstance((Object)aSN1Sequence));
                bl = this.context.getTrustedCACerts().isTrustedCertificate(this.x509, this.context.isInvalidCertificateAllowed(), this.context.isUntrustedCertificateAllowed());
            }
            if (!bl) {
                throw new SSLException(42, "The server certificate was either invalid or untrusted");
            }
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage());
        }
        this.log.debug((Object)"Server X509 Certificate...");
        this.log.debug((Object)("Subject DN: " + this.x509.getSubjectDN()));
        this.log.debug((Object)("Issuer DN: " + this.x509.getIssuerDN()));
        this.currentHandshakeStep = 11;
    }

    private void onServerHelloMsg(byte[] byArray) throws SSLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.majorVersion = byteArrayInputStream.read();
            this.minorVersion = byteArrayInputStream.read();
            this.serverRandom = new byte[32];
            byteArrayInputStream.read(this.serverRandom);
            this.sessionID = new byte[byteArrayInputStream.read() & 0xFF];
            byteArrayInputStream.read(this.sessionID);
            this.cipherSuiteID = new SSLCipherSuiteID(byteArrayInputStream.read(), byteArrayInputStream.read());
            this.pendingCipherSuite = (SSLCipherSuite)this.context.getCipherSuiteClass(this.cipherSuiteID).newInstance();
            this.compressionID = byteArrayInputStream.read();
            this.currentHandshakeStep = 2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SSLException(997, illegalAccessException.getMessage() == null ? illegalAccessException.getClass().getName() : illegalAccessException.getMessage());
        }
        catch (InstantiationException instantiationException) {
            throw new SSLException(997, instantiationException.getMessage() == null ? instantiationException.getClass().getName() : instantiationException.getMessage());
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
    }

    private void sendClientHello() throws SSLException {
        this.log.debug((Object)"Sending client HELLO");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.clientRandom = new byte[32];
            this.context.getRND().nextBytes(this.clientRandom);
            long l = System.currentTimeMillis();
            this.clientRandom[0] = (byte)(l >> 24 & 0xFFL);
            this.clientRandom[1] = (byte)(l >> 16 & 0xFFL);
            this.clientRandom[2] = (byte)(l >> 8 & 0xFFL);
            this.clientRandom[3] = (byte)(l & 0xFFL);
            byteArrayOutputStream.write(3);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(this.clientRandom);
            byteArrayOutputStream.write(0);
            SSLCipherSuiteID[] sSLCipherSuiteIDArray = this.context.getCipherSuiteIDs();
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(sSLCipherSuiteIDArray.length * 2);
            int n = 0;
            while (n < sSLCipherSuiteIDArray.length) {
                byteArrayOutputStream.write(sSLCipherSuiteIDArray[n].id1);
                byteArrayOutputStream.write(sSLCipherSuiteIDArray[n].id2);
                ++n;
            }
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(0);
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
        this.sendMessage(1, byteArrayOutputStream.toByteArray());
        this.currentHandshakeStep = 1;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    boolean isComplete() {
        return this.currentHandshakeStep == -1;
    }

    private void calculateMasterSecret() throws SSLException {
        this.log.debug((Object)"Calculating master secret");
        try {
            MD5Digest mD5Digest = new MD5Digest();
            SHA1Digest sHA1Digest = new SHA1Digest();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String[] stringArray = new String[]{"A", "BB", "CCC"};
            int n = 0;
            while (n < stringArray.length) {
                mD5Digest.reset();
                sHA1Digest.reset();
                sHA1Digest.update(stringArray[n].getBytes(), 0, stringArray[n].getBytes().length);
                sHA1Digest.update(this.premasterSecret, 0, this.premasterSecret.length);
                sHA1Digest.update(this.clientRandom, 0, this.clientRandom.length);
                sHA1Digest.update(this.serverRandom, 0, this.serverRandom.length);
                mD5Digest.update(this.premasterSecret, 0, this.premasterSecret.length);
                byte[] byArray = new byte[sHA1Digest.getDigestSize()];
                sHA1Digest.doFinal(byArray, 0);
                mD5Digest.update(byArray, 0, byArray.length);
                byArray = new byte[mD5Digest.getDigestSize()];
                mD5Digest.doFinal(byArray, 0);
                byteArrayOutputStream.write(byArray);
                ++n;
            }
            this.masterSecret = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SSLException(997, iOException.getMessage() == null ? iOException.getClass().getName() : iOException.getMessage());
        }
    }

    private void calculatePreMasterSecret() {
        this.log.debug((Object)"Generating pre-master secret");
        this.premasterSecret = new byte[48];
        this.context.getRND().nextBytes(this.premasterSecret);
        this.premasterSecret[0] = 3;
        this.premasterSecret[1] = 0;
    }
}

