/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssl;

import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssl.SSLCipherSuiteID;
import com.maverick.ssl.TrustedCACertStore;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class SSLContext {
    Hashtable cipherClassesByID = new Hashtable();
    Hashtable cipherIDsByName = new Hashtable();
    Vector cipherIDs = new Vector();
    SecureRandom rnd = SecureRandom.getInstance();
    boolean allowUntrustedCertificates = false;
    boolean allowInvalidCertificates = false;
    TrustedCACertStore cacerts = new TrustedCACertStore();
    private static /* synthetic */ Class class$com$maverick$ssl$SSL_RSA_WITH_RC4_128_MD5;

    public TrustedCACertStore getTrustedCACerts() {
        return this.cacerts;
    }

    public void addCipherSuite(int n, int n2, String string, Class clazz) {
        SSLCipherSuiteID sSLCipherSuiteID = new SSLCipherSuiteID(n, n2);
        this.cipherClassesByID.put(sSLCipherSuiteID, clazz);
        this.cipherIDsByName.put(string, sSLCipherSuiteID);
        this.cipherIDs.addElement(sSLCipherSuiteID);
    }

    public boolean isUntrustedCertificateAllowed() {
        return this.allowUntrustedCertificates;
    }

    public SSLContext() throws IOException {
        this.addCipherSuite(0, 4, "SSL_RSA_WITH_RC4_128_MD5", class$com$maverick$ssl$SSL_RSA_WITH_RC4_128_MD5 != null ? class$com$maverick$ssl$SSL_RSA_WITH_RC4_128_MD5 : (class$com$maverick$ssl$SSL_RSA_WITH_RC4_128_MD5 = SSLContext.class$("com.maverick.ssl.SSL_RSA_WITH_RC4_128_MD5")));
        try {
            this.allowUntrustedCertificates = Boolean.valueOf(System.getProperty("com.maverick.ssl.allowUntrustedCertificates", "false"));
        }
        catch (Exception exception) {}
        try {
            this.allowInvalidCertificates = Boolean.valueOf(System.getProperty("com.maverick.ssl.allowInvalidCertificates", "false"));
        }
        catch (Exception exception) {}
    }

    public boolean isInvalidCertificateAllowed() {
        return this.allowInvalidCertificates;
    }

    public Class getCipherSuiteClass(SSLCipherSuiteID sSLCipherSuiteID) {
        Enumeration enumeration = this.cipherClassesByID.keys();
        while (enumeration.hasMoreElements()) {
            SSLCipherSuiteID sSLCipherSuiteID2 = (SSLCipherSuiteID)enumeration.nextElement();
            if (!sSLCipherSuiteID2.equals(sSLCipherSuiteID)) continue;
            return (Class)this.cipherClassesByID.get(sSLCipherSuiteID2);
        }
        return null;
    }

    public Random getRND() {
        return this.rnd;
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SSLCipherSuiteID[] getCipherSuiteIDs() {
        Object[] objectArray = new SSLCipherSuiteID[this.cipherIDs.size()];
        this.cipherIDs.copyInto(objectArray);
        return objectArray;
    }
}

