/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.http.NameValuePair;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

class ParameterParser {
    private char[] chars = null;
    private int pos = 0;
    private int len = 0;
    private int i1 = 0;
    private int i2 = 0;

    public Vector parse(String string, char c) {
        if (string == null) {
            return new Vector();
        }
        return this.parse(string.toCharArray(), c);
    }

    public Vector parse(char[] cArray, char c) {
        if (cArray == null) {
            return new Vector();
        }
        return this.parse(cArray, 0, cArray.length, c);
    }

    public Vector parse(char[] cArray, int n, int n2, char c) {
        if (cArray == null) {
            return new Vector();
        }
        Vector<NameValuePair> vector = new Vector<NameValuePair>();
        this.chars = cArray;
        this.pos = n;
        this.len = n2;
        String string = null;
        String string2 = null;
        while (this.hasChar()) {
            string = this.parseToken(new char[]{'=', c});
            string2 = null;
            if (this.hasChar() && cArray[this.pos] == '=') {
                ++this.pos;
                string2 = this.parseQuotedToken(new char[]{c});
            }
            if (this.hasChar() && cArray[this.pos] == c) {
                ++this.pos;
            }
            if (string == null || string.length() <= 0) continue;
            vector.addElement(new NameValuePair(string, string2));
        }
        return vector;
    }

    private boolean isOneOf(char c, char[] cArray) {
        boolean bl = false;
        int n = 0;
        while (n < cArray.length) {
            if (c == cArray[n]) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private String getToken(boolean bl) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            this.i2 += -1;
        }
        if (bl && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            this.i2 += -1;
        }
        String string = null;
        if (this.i2 > this.i1) {
            string = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return string;
    }

    public static Hashtable extractParams(String string) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Challenge may not be null");
        }
        int n = string.indexOf(32);
        if (n == -1) {
            throw new IOException("Invalid challenge: " + string);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ParameterParser parameterParser = new ParameterParser();
        Vector vector = parameterParser.parse(string.substring(n + 1, string.length()), ',');
        int n2 = 0;
        while (n2 < vector.size()) {
            NameValuePair nameValuePair = (NameValuePair)vector.elementAt(n2);
            hashtable.put(nameValuePair.getName().toLowerCase(), nameValuePair.getValue());
            ++n2;
        }
        return hashtable;
    }

    private boolean hasChar() {
        return this.pos < this.len;
    }

    private String parseToken(char[] cArray) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar()) {
            char c = this.chars[this.pos];
            if (this.isOneOf(c, cArray)) break;
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    private String parseQuotedToken(char[] cArray) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean bl = false;
        while (this.hasChar()) {
            char c = this.chars[this.pos];
            if (!bl && this.isOneOf(c, cArray)) break;
            if (c == '\"') {
                bl = !bl;
            }
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }
}

