/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.http.HttpConnection;
import com.maverick.http.HttpHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HttpResponse
extends HttpHeader {
    private String version = "";
    private int status;
    private String reason = "";
    boolean closeConnection = false;
    long contentLength = 0L;
    ByteArrayInputStream in = null;
    HttpConnection con;

    public InputStream getInputStream() {
        return this.in;
    }

    public HttpResponse(HttpConnection httpConnection) throws IOException {
        this.con = httpConnection;
        this.begin = this.readLine(httpConnection.getInputStream());
        while (this.begin.trim().length() == 0) {
            this.begin = this.readLine(httpConnection.getInputStream());
        }
        this.processResponse();
        this.processHeaderFields(httpConnection.getInputStream());
        if (this.getHeaderField("Content-Length") != null) {
            this.contentLength = Long.parseLong(this.getHeaderField("Content-Length"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((long)byteArrayOutputStream.size() < this.contentLength) {
                int n = httpConnection.getInputStream().read();
                if (n == -1) {
                    throw new IOException("Unexpected EOF in Http Response");
                }
                byteArrayOutputStream.write(n);
            }
            this.in = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        } else {
            this.in = new ByteArrayInputStream(new byte[0]);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getReason() {
        return this.reason;
    }

    public int getStatus() {
        return this.status;
    }

    public HttpConnection getConnection() {
        return this.con;
    }

    private void processResponse() throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.begin, " \t\r", false);
        try {
            this.version = stringTokenizer.nextToken();
            this.status = Integer.parseInt(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                this.reason = this.reason + stringTokenizer.nextToken() + " ";
            }
            this.reason = this.reason.trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException("Failed to read HTTP repsonse header");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Failed to read HTTP resposne header");
        }
    }
}

