/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.http;

import com.maverick.crypto.digests.Digest;
import com.maverick.crypto.digests.Hash;
import com.maverick.crypto.digests.MD5Digest;
import com.maverick.http.HttpAuthenticator;
import com.maverick.http.HttpRequest;
import com.maverick.http.HttpResponse;
import com.maverick.http.ParameterParser;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DigestAuthentication
extends HttpAuthenticator {
    Hashtable params;
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private boolean complete;
    private static final String NC = "00000001";
    private static final int QOP_MISSING = 0;
    private static final int QOP_AUTH_INT = 1;
    private static final int QOP_AUTH = 2;
    private int qopVariant = 0;
    private String cnonce;
    private String realm;
    private String nonce;
    boolean isAuthenticated = false;

    private String createDigestHeader(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = (String)this.params.get("uri");
        String string4 = (String)this.params.get("realm");
        String string5 = (String)this.params.get("nonce");
        String cfr_ignored_0 = (String)this.params.get("nc");
        String string6 = (String)this.params.get("opaque");
        String string7 = string2;
        String cfr_ignored_1 = (String)this.params.get("qop");
        String string8 = (String)this.params.get("algorithm");
        stringBuffer.append("username=\"" + string + "\"").append(", realm=\"" + string4 + "\"").append(", nonce=\"" + string5 + "\"").append(", uri=\"" + string3 + "\"").append(", response=\"" + string7 + "\"");
        if (this.qopVariant != 0) {
            stringBuffer.append(", qop=\"" + this.getQopVariantString() + "\"").append(", nc=" + NC).append(", cnonce=\"" + this.cnonce + "\"");
        }
        if (string8 != null) {
            stringBuffer.append(", algorithm=\"" + string8 + "\"");
        }
        if (string6 != null) {
            stringBuffer.append(", opaque=\"" + string6 + "\"");
        }
        return stringBuffer.toString();
    }

    public void setChallenge(String string) {
        try {
            this.params = ParameterParser.extractParams(string);
            this.realm = (String)this.params.get("realm");
            this.nonce = (String)this.params.get("nonce");
            boolean bl = false;
            String string2 = (String)this.params.get("qop");
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken().trim();
                    if (string3.equals("auth")) {
                        this.qopVariant = 2;
                        break;
                    }
                    if (string3.equals("auth-int")) {
                        this.qopVariant = 1;
                        continue;
                    }
                    bl = true;
                }
            }
            this.cnonce = DigestAuthentication.createCnonce();
        }
        catch (IOException iOException) {
            this.realm = "";
        }
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public DigestAuthentication() {
        super("Digest");
    }

    private static String encode(byte[] byArray) {
        if (byArray.length != 16) {
            return null;
        }
        char[] cArray = new char[32];
        int n = 0;
        do {
            int n2 = byArray[n] & 0xF;
            int n3 = (byArray[n] & 0xF0) >> 4;
            cArray[n * 2] = HEXADECIMAL[n3];
            cArray[n * 2 + 1] = HEXADECIMAL[n2];
        } while (++n < 16);
        return new String(cArray);
    }

    private String createDigest(String string, String string2, String string3) throws IOException {
        String string4;
        CharSequence charSequence;
        CharSequence charSequence2;
        String string5;
        String string6 = (String)this.params.get("uri");
        String string7 = (String)this.params.get("realm");
        String string8 = (String)this.params.get("nonce");
        String cfr_ignored_0 = (String)this.params.get("qop");
        String string9 = (String)this.params.get("methodname");
        String string10 = (String)this.params.get("algorithm");
        if (string10 == null) {
            string10 = "MD5";
        }
        if (this.qopVariant == 1) {
            throw new IOException("Unsupported qop in HTTP Digest authentication");
        }
        Hash hash = new Hash((Digest)new MD5Digest());
        StringBuffer stringBuffer = new StringBuffer(string.length() + string7.length() + string2.length() + 2);
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string7);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        String string11 = stringBuffer.toString();
        if (string10.equals("MD5-sess")) {
            hash.putBytes(string11.getBytes("US-ASCII"));
            string5 = DigestAuthentication.encode(hash.doFinal());
            charSequence2 = new StringBuffer(string5.length() + string8.length() + this.cnonce.length() + 2);
            ((StringBuffer)charSequence2).append(string5);
            ((StringBuffer)charSequence2).append(':');
            ((StringBuffer)charSequence2).append(string8);
            ((StringBuffer)charSequence2).append(':');
            ((StringBuffer)charSequence2).append(this.cnonce);
            string11 = ((StringBuffer)charSequence2).toString();
        } else if (!string10.equals("MD5")) {
            // empty if block
        }
        hash.reset();
        hash.putBytes(string11.getBytes("US-ASCII"));
        string5 = DigestAuthentication.encode(hash.doFinal());
        charSequence2 = null;
        if (this.qopVariant != 1) {
            charSequence2 = string9 + ":" + string6;
        }
        hash.reset();
        hash.putBytes(((String)charSequence2).getBytes("US-ASCII"));
        String string12 = DigestAuthentication.encode(hash.doFinal());
        if (this.qopVariant == 0) {
            charSequence = new StringBuffer(string5.length() + string8.length() + string12.length());
            ((StringBuffer)charSequence).append(string5);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(string8);
            ((StringBuffer)charSequence).append(':');
            ((StringBuffer)charSequence).append(string12);
            string4 = ((StringBuffer)charSequence).toString();
        } else {
            charSequence = this.getQopVariantString();
            StringBuffer stringBuffer2 = new StringBuffer(string5.length() + string8.length() + NC.length() + this.cnonce.length() + ((String)charSequence).length() + string12.length() + 5);
            stringBuffer2.append(string5);
            stringBuffer2.append(':');
            stringBuffer2.append(string8);
            stringBuffer2.append(':');
            stringBuffer2.append(NC);
            stringBuffer2.append(':');
            stringBuffer2.append(this.cnonce);
            stringBuffer2.append(':');
            stringBuffer2.append((String)charSequence);
            stringBuffer2.append(':');
            stringBuffer2.append(string12);
            string4 = stringBuffer2.toString();
        }
        hash.reset();
        hash.putBytes(string4.getBytes("US-ASCII"));
        charSequence = DigestAuthentication.encode(hash.doFinal());
        return charSequence;
    }

    public static String createCnonce() {
        Hash hash = new Hash((Digest)new MD5Digest());
        String string = Long.toString(System.currentTimeMillis());
        hash.putBytes(string.getBytes());
        string = DigestAuthentication.encode(hash.doFinal());
        return string;
    }

    public boolean wantsPrompt() {
        return this.credentials == null;
    }

    public boolean processResponse(HttpResponse httpResponse) {
        this.isAuthenticated = httpResponse.getStatus() == 200;
        return true;
    }

    public void authenticate(HttpRequest httpRequest, String string) throws IOException {
        this.params.put("methodname", httpRequest.getMethod().getName());
        this.params.put("uri", string);
        String string2 = this.createDigest(this.credentials.getUsername(), this.credentials.getPassword(), "US-ASCII");
        httpRequest.setHeaderField(this.authorizationHeader, "Digest " + this.createDigestHeader(this.credentials.getUsername(), string2));
    }

    private String getQopVariantString() {
        String string = this.qopVariant == 1 ? "auth-int" : "auth";
        return string;
    }
}

