/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.AccumulativeRunnable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.retroweaver.runtime.java.lang.Enum;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SwingWorker<T, V>
implements Future<T>,
Runnable {
    private static final int MAX_WORKER_THREADS = 10;
    private volatile int progress;
    private volatile StateValue state;
    private final FutureTask<T> future;
    private final PropertyChangeSupport propertyChangeSupport;
    private AccumulativeRunnable<V> doProcess;
    private AccumulativeRunnable<Integer> doNotifyProgressChange;
    private static final AccumulativeRunnable<Runnable> doSubmit = new DoSubmitAccumulativeRunnable();
    private static ExecutorService executorService = null;

    public SwingWorker() {
        Callable callable = new Callable<T>(){

            @Override
            public T call() throws Exception {
                SwingWorker.this.setState(StateValue.STARTED);
                return SwingWorker.this.doInBackground();
            }
        };
        this.future = new FutureTask<T>(callable){

            @Override
            protected void done() {
                SwingWorker.this.doneEDT();
                SwingWorker.this.setState(StateValue.DONE);
            }
        };
        this.state = StateValue.PENDING;
        this.propertyChangeSupport = new SwingWorkerPropertyChangeSupport(this);
        this.doProcess = null;
        this.doNotifyProgressChange = null;
    }

    protected abstract T doInBackground() throws Exception;

    @Override
    public final void run() {
        this.future.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void publish(V ... VArray) {
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doProcess == null) {
                this.doProcess = new AccumulativeRunnable<V>(){

                    @Override
                    public void run(List<V> list) {
                        SwingWorker.this.process(list);
                    }

                    @Override
                    protected void submit() {
                        doSubmit.add(this);
                    }
                };
            }
        }
        this.doProcess.add(VArray);
    }

    protected void process(List<V> list) {
    }

    protected void done() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProgress(int n) {
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("the value should be from 0 to 100");
        }
        if (this.progress == n) {
            return;
        }
        int n2 = this.progress;
        this.progress = n;
        if (!this.getPropertyChangeSupport().hasListeners("progress")) {
            return;
        }
        SwingWorker swingWorker = this;
        synchronized (swingWorker) {
            if (this.doNotifyProgressChange == null) {
                this.doNotifyProgressChange = new AccumulativeRunnable<Integer>(){

                    @Override
                    public void run(List<Integer> list) {
                        SwingWorker.this.firePropertyChange("progress", list.get(0), list.get(list.size() - 1));
                    }

                    @Override
                    protected void submit() {
                        doSubmit.add(this);
                    }
                };
            }
        }
        this.doNotifyProgressChange.add((Integer[])new Integer[]{Integer_.valueOf((int)n2), Integer_.valueOf((int)n)});
    }

    public final int getProgress() {
        return this.progress;
    }

    public final void execute() {
        SwingWorker.getWorkersExecutorService().execute(this);
    }

    @Override
    public final boolean cancel(boolean bl) {
        return this.future.cancel(bl);
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public final T get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public final T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(l, timeUnit);
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    public final PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public final StateValue getState() {
        if (this.isDone()) {
            return StateValue.DONE;
        }
        return this.state;
    }

    private void setState(StateValue stateValue) {
        StateValue stateValue2 = this.state;
        this.state = stateValue;
        this.firePropertyChange("state", (Object)stateValue2, (Object)stateValue);
    }

    private void doneEDT() {
        Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.done();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            doSubmit.add((Runnable[])new Runnable[]{runnable});
        }
    }

    private static synchronized ExecutorService getWorkersExecutorService() {
        if (executorService == null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                final AtomicInteger threadNumber = new AtomicInteger(1);

                public Thread newThread(Runnable runnable) {
                    StringBuffer stringBuffer = new StringBuffer("SwingWorker-pool-");
                    stringBuffer.append(System.identityHashCode(this));
                    stringBuffer.append("-thread-");
                    stringBuffer.append(this.threadNumber.getAndIncrement());
                    Thread thread = new Thread(runnable, stringBuffer.toString());
                    if (thread.isDaemon()) {
                        thread.setDaemon(false);
                    }
                    if (thread.getPriority() != 5) {
                        thread.setPriority(5);
                    }
                    return thread;
                }
            };
            executorService = new ThreadPoolExecutor(0, 10, 5L, TimeUnit.SECONDS, (BlockingQueue)new LinkedBlockingQueue(), threadFactory){
                private final ReentrantLock pauseLock = new ReentrantLock();
                private final Condition unpaused = this.pauseLock.newCondition();
                private boolean isPaused = false;
                private final ReentrantLock executeLock = new ReentrantLock();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Runnable runnable) {
                    this.executeLock.lock();
                    try {
                        this.pauseLock.lock();
                        try {
                            this.isPaused = true;
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                        this.setCorePoolSize(10);
                        super.execute(runnable);
                        this.setCorePoolSize(0);
                        this.pauseLock.lock();
                        try {
                            this.isPaused = false;
                            this.unpaused.signalAll();
                        }
                        finally {
                            this.pauseLock.unlock();
                        }
                    }
                    finally {
                        this.executeLock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void afterExecute(Runnable runnable, Throwable throwable) {
                    super.afterExecute(runnable, throwable);
                    this.pauseLock.lock();
                    try {
                        while (this.isPaused) {
                            this.unpaused.await();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.pauseLock.unlock();
                    }
                }
            };
        }
        return executorService;
    }

    private class SwingWorkerPropertyChangeSupport
    extends PropertyChangeSupport {
        SwingWorkerPropertyChangeSupport(Object object) {
            super(object);
        }

        public void firePropertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (SwingUtilities.isEventDispatchThread()) {
                super.firePropertyChange(propertyChangeEvent);
            } else {
                doSubmit.add(new Runnable(){

                    public void run() {
                        SwingWorkerPropertyChangeSupport.this.firePropertyChange(propertyChangeEvent);
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DoSubmitAccumulativeRunnable
    extends AccumulativeRunnable<Runnable>
    implements ActionListener {
        private static final int DELAY = 33;

        private DoSubmitAccumulativeRunnable() {
        }

        @Override
        protected void run(List<Runnable> list) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }

        @Override
        protected void submit() {
            Timer timer = new Timer(33, this);
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StateValue
    extends Enum<StateValue> {
        public static final /* enum */ StateValue PENDING = new StateValue("PENDING", 0);
        public static final /* enum */ StateValue STARTED = new StateValue("STARTED", 1);
        public static final /* enum */ StateValue DONE = new StateValue("DONE", 2);
        private static final /* synthetic */ StateValue[] $VALUES;
        private static final /* synthetic */ long serialVersionUID = 0L;
        private static final /* synthetic */ Class class$com$jidesoft$utils$SwingWorker$StateValue;

        public static StateValue[] values() {
            return (StateValue[])$VALUES.clone();
        }

        public static StateValue valueOf(String string) {
            Class<?> clazz = class$com$jidesoft$utils$SwingWorker$StateValue;
            if (clazz == null) {
                clazz = class$com$jidesoft$utils$SwingWorker$StateValue = new StateValue[0].getClass().getComponentType();
            }
            return (StateValue)Enum.valueOf((Class)clazz, (String)string);
        }

        private StateValue(String string, int n) {
            super(string, n);
        }

        static {
            $VALUES = new StateValue[]{PENDING, STARTED, DONE};
            StateValue[] stateValueArray = StateValue.values();
            Class<?> clazz = class$com$jidesoft$utils$SwingWorker$StateValue;
            if (clazz == null) {
                clazz = class$com$jidesoft$utils$SwingWorker$StateValue = new StateValue[0].getClass().getComponentType();
            }
            Enum.setEnumValues((Object[])stateValueArray, (Class)clazz);
        }
    }
}

