/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.retroweaver.harmony.runtime.java.math.BigDecimal_;
import net.sourceforge.retroweaver.harmony.runtime.java.math.MathContext;
import net.sourceforge.retroweaver.harmony.runtime.java.math.RoundingMode;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BigDecimalMathUtils {
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);

    protected BigDecimalMathUtils() {
    }

    public static BigDecimal sum(List<BigDecimal> list) {
        BigDecimal bigDecimal = BigDecimal_.BigDecimal((int)0);
        for (BigDecimal bigDecimal2 : list) {
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return bigDecimal;
    }

    public static BigDecimal mean(List<BigDecimal> list, MathContext mathContext) {
        BigDecimal bigDecimal = BigDecimalMathUtils.sum(list);
        return BigDecimal_.divide((BigDecimal)bigDecimal, (BigDecimal)BigDecimal_.BigDecimal((int)list.size()), (MathContext)mathContext);
    }

    public static BigDecimal min(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).first();
    }

    public static BigDecimal max(List<BigDecimal> list) {
        return new TreeSet<BigDecimal>(list).last();
    }

    public static BigDecimal stddev(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n = list.size();
        BigDecimal bigDecimal = n > 0 ? (n > 1 ? BigDecimalMathUtils.sqrt(BigDecimalMathUtils.var(list, bl, mathContext)) : BigDecimal_.ZERO) : BigDecimal_.valueOf((double)Double.NaN);
        return bigDecimal;
    }

    public static BigDecimal var(List<BigDecimal> list, boolean bl, MathContext mathContext) {
        int n = list.size();
        if (n == 0) {
            return BigDecimal_.valueOf((double)Double.NaN);
        }
        if (n == 1) {
            return BigDecimal_.ZERO;
        }
        BigDecimal bigDecimal = BigDecimalMathUtils.mean(list, mathContext);
        ArrayList<BigDecimal> arrayList = new ArrayList<BigDecimal>();
        for (BigDecimal bigDecimal2 : list) {
            BigDecimal bigDecimal3 = bigDecimal2.subtract(bigDecimal);
            arrayList.add(BigDecimal_.pow((BigDecimal)bigDecimal3, (int)2, (MathContext)mathContext));
        }
        BigDecimal bigDecimal4 = BigDecimalMathUtils.sum(arrayList);
        return BigDecimal_.divide((BigDecimal)bigDecimal4, (BigDecimal)BigDecimal_.BigDecimal((int)(bl ? list.size() - 1 : list.size())), (MathContext)mathContext);
    }

    public static BigDecimal sqrt(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4 = null;
        BigDecimal bigDecimal5 = null;
        int n = BigDecimal_.precision((BigDecimal)bigDecimal);
        MathContext mathContext = new MathContext(n, RoundingMode.HALF_UP);
        BigDecimal bigDecimal6 = bigDecimal;
        double d = bigDecimal6.doubleValue();
        if (mathContext.getPrecision() == 0) {
            throw new IllegalArgumentException("\nRoots need a MathContext precision > 0");
        }
        if (d < 0.0) {
            throw new ArithmeticException("\nCannot calculate the square root of a negative number");
        }
        if (d == 0.0) {
            return BigDecimal_.round((BigDecimal)bigDecimal, (MathContext)mathContext);
        }
        if (mathContext.getPrecision() < 50) {
            n += 10;
        }
        int n2 = 1;
        if (d == Double.POSITIVE_INFINITY) {
            BigInteger bigInteger = bigDecimal6.unscaledValue();
            int n3 = bigInteger.bitLength();
            int n4 = n3 / 2;
            bigInteger = bigInteger.shiftRight(n4);
            bigDecimal3 = new BigDecimal(bigInteger);
            MathContext mathContext2 = new MathContext(5, RoundingMode.HALF_DOWN);
            n += 10;
            bigDecimal2 = BigDecimal_.divide((BigDecimal)BigDecimal_.ONE, (BigDecimal)BigDecimal_.multiply((BigDecimal)TWO, (BigDecimal)bigDecimal3, (MathContext)mathContext2), (MathContext)mathContext2);
        } else {
            double d2 = Math.sqrt(d);
            bigDecimal3 = new BigDecimal(d2);
            bigDecimal2 = new BigDecimal(0.5 / d2);
            n2 = 64;
        }
        int n5 = mathContext.getPrecision() + n;
        MathContext mathContext3 = new MathContext(n2, mathContext.getRoundingMode());
        return BigDecimalMathUtils.sqrtProcedure(mathContext3, n5, bigDecimal6, bigDecimal3, bigDecimal2, bigDecimal4, bigDecimal5);
    }

    private static BigDecimal sqrtProcedure(MathContext mathContext, int n, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        bigDecimal4 = BigDecimal_.subtract((BigDecimal)BigDecimal_.ONE, (BigDecimal)BigDecimal_.multiply((BigDecimal)BigDecimal_.multiply((BigDecimal)TWO, (BigDecimal)bigDecimal2, (MathContext)mathContext), (BigDecimal)bigDecimal3, (MathContext)mathContext), (MathContext)mathContext);
        bigDecimal3 = BigDecimal_.add((BigDecimal)bigDecimal3, (BigDecimal)BigDecimal_.multiply((BigDecimal)bigDecimal4, (BigDecimal)bigDecimal3, (MathContext)mathContext), (MathContext)mathContext);
        bigDecimal5 = BigDecimal_.subtract((BigDecimal)bigDecimal, (BigDecimal)BigDecimal_.multiply((BigDecimal)bigDecimal2, (BigDecimal)bigDecimal2, (MathContext)mathContext), (MathContext)mathContext);
        bigDecimal2 = BigDecimal_.add((BigDecimal)bigDecimal2, (BigDecimal)BigDecimal_.multiply((BigDecimal)bigDecimal5, (BigDecimal)bigDecimal3, (MathContext)mathContext), (MathContext)mathContext);
        int n2 = mathContext.getPrecision();
        n2 = n2 < 2 ? ++n2 : n2 * 2 - 1;
        if (n2 < 2 * n) {
            mathContext = new MathContext(n2, mathContext.getRoundingMode());
            BigDecimalMathUtils.sqrtProcedure(mathContext, n, bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4, bigDecimal5);
        }
        return bigDecimal2;
    }

    public static void main(String[] stringArray) {
        System.out.println(BigDecimalMathUtils.sqrt(new BigDecimal("25029.33333")));
    }
}

