/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

public class DefaultOverlayable
extends JPanel
implements Overlayable,
ComponentListener {
    private JComponent _actualComponent;
    private Insets _overlayLocationInsets = new Insets(0, 0, 0, 0);
    private List<JComponent> _overlayComponents;
    private Map<JComponent, Integer> _overlayLocations;

    public DefaultOverlayable() {
        this.initComponents();
    }

    public DefaultOverlayable(JComponent jComponent) {
        this.initComponents();
        this.setActualComponent(jComponent);
    }

    public DefaultOverlayable(JComponent jComponent, JComponent jComponent2, int n) {
        this.initComponents();
        this.setActualComponent(jComponent);
        this.addOverlayComponent(jComponent2, n);
    }

    public DefaultOverlayable(JComponent jComponent, JComponent jComponent2) {
        this.initComponents();
        this.setActualComponent(jComponent);
        this.addOverlayComponent(jComponent2, 0);
    }

    private void initComponents() {
        this.setLayout(null);
        this._overlayComponents = new Vector<JComponent>();
        this._overlayLocations = new Hashtable<JComponent, Integer>();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getPreferredSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            dimension.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            dimension.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return dimension;
    }

    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (dimension != null && (insets = this.getOverlayLocationInsets()) != null) {
                dimension.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                dimension.width = Math.max(0, dimension.width);
                dimension.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                dimension.height = Math.max(0, dimension.height);
            }
            this.getActualComponent().setPreferredSize(dimension);
        }
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getActualComponent() == null ? new Dimension(0, 0) : this.getActualComponent().getMinimumSize();
        Insets insets = this.getOverlayLocationInsets();
        if (insets != null) {
            dimension.width += Math.max(0, insets.left) + Math.max(0, insets.right);
            dimension.height += Math.max(0, insets.top) + Math.max(0, insets.bottom);
        }
        return dimension;
    }

    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
        if (this.getActualComponent() != null) {
            Insets insets;
            if (dimension != null && (insets = this.getOverlayLocationInsets()) != null) {
                dimension.width -= Math.max(0, insets.left) + Math.max(0, insets.right);
                dimension.width = Math.max(0, dimension.width);
                dimension.height -= Math.max(0, insets.top) + Math.max(0, insets.bottom);
                dimension.height = Math.max(0, dimension.height);
            }
            this.getActualComponent().setMinimumSize(dimension);
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Insets insets = this.getOverlayLocationInsets();
        n = Math.max(0, insets.left);
        n2 = Math.max(0, insets.top);
        this.getActualComponent().setBounds(n, n2, n3 -= Math.max(0, insets.left) + Math.max(0, insets.right), n4 -= Math.max(0, insets.top) + Math.max(0, insets.bottom));
        this.updateLocation();
    }

    private void updateLocation() {
        JComponent[] jComponentArray;
        JComponent[] jComponentArray2 = jComponentArray = this.getOverlayComponents();
        int n = jComponentArray2.length;
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = jComponentArray2[i];
            if (jComponent == null) {
                return;
            }
            if (!jComponent.isVisible()) continue;
            Rectangle rectangle = this.getOverlayComponentBounds(jComponent);
            jComponent.setBounds(rectangle);
        }
    }

    private Rectangle getOverlayComponentBounds(JComponent jComponent) {
        JComponent jComponent2 = this.getActualComponent();
        Rectangle rectangle = jComponent2.getBounds();
        if (jComponent2 != this.getActualComponent()) {
            rectangle = SwingUtilities.convertRectangle(jComponent2.getParent(), rectangle, this.getActualComponent());
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        Insets insets = this.getOverlayLocationInsets();
        rectangle2.x -= insets.left;
        rectangle2.y -= insets.top;
        rectangle2.width += insets.left + insets.right;
        rectangle2.height += insets.top + insets.bottom;
        int n = 0;
        int n2 = 0;
        Dimension dimension = jComponent.getPreferredSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        switch (this.getOverlayLocation(jComponent)) {
            case 0: {
                n = rectangle.x + (rectangle.width - n3) / 2;
                n2 = rectangle.y + (rectangle.height - n4) / 2;
                break;
            }
            case 1: {
                n = rectangle.x + (rectangle.width - n3) / 2;
                n2 = rectangle2.y;
                break;
            }
            case 5: {
                n = rectangle.x + (rectangle.width - n3) / 2;
                n2 = rectangle2.y + rectangle2.height - n4;
                break;
            }
            case 7: {
                n = rectangle2.x;
                n2 = rectangle.y + (rectangle.height - n4) / 2;
                break;
            }
            case 3: {
                n = rectangle2.x + rectangle2.width - n3;
                n2 = rectangle.y + (rectangle.height - n4) / 2;
                break;
            }
            case 8: {
                n = rectangle2.x;
                n2 = rectangle2.y;
                break;
            }
            case 2: {
                n = rectangle2.x + rectangle2.width - n3;
                n2 = rectangle2.y;
                break;
            }
            case 6: {
                n = rectangle2.x;
                n2 = rectangle2.y + rectangle2.height - n4;
                break;
            }
            case 4: {
                n = rectangle2.x + rectangle2.width - n3;
                n2 = rectangle2.y + rectangle2.height - n4;
            }
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public int getOverlayLocation(JComponent jComponent) {
        Integer n = this._overlayLocations.get(jComponent);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public void setOverlayLocation(JComponent jComponent, int n) {
        this.setOverlayLocation(jComponent, null, n);
    }

    private void setOverlayLocation(JComponent jComponent, Component component, int n) {
        boolean bl = false;
        int n2 = this.getOverlayLocation(jComponent);
        if (n2 != n) {
            this._overlayLocations.put(jComponent, Integer_.valueOf((int)n));
            bl = true;
        }
        if (bl) {
            this.updateLocation();
        }
    }

    public void addOverlayComponent(JComponent jComponent) {
        this.addOverlayComponent(jComponent, 0, -1);
    }

    public void addOverlayComponent(JComponent jComponent, int n) {
        this.addOverlayComponent(jComponent, n, -1);
    }

    public void addOverlayComponent(JComponent jComponent, int n, int n2) {
        this.addOverlayComponent(jComponent, null, n, n2);
    }

    private void addOverlayComponent(JComponent jComponent, Component component, int n, int n2) {
        if (this._overlayComponents.contains(jComponent)) {
            this._overlayComponents.remove(jComponent);
        }
        if (n2 == -1) {
            this._overlayComponents.add(jComponent);
            this.add((Component)jComponent, this.getComponentCount() - 1);
        } else {
            this._overlayComponents.add(n2, jComponent);
            this.add((Component)jComponent, n2);
        }
        this.setOverlayLocation(jComponent, component, n);
    }

    public void removeOverlayComponent(JComponent jComponent) {
        if (this._overlayComponents.contains(jComponent)) {
            this._overlayComponents.remove(jComponent);
            this._overlayLocations.remove(jComponent);
            this.remove(jComponent);
        }
    }

    public JComponent[] getOverlayComponents() {
        return this._overlayComponents.toArray(new JComponent[this._overlayComponents.size()]);
    }

    public JComponent getActualComponent() {
        return this._actualComponent;
    }

    public void setActualComponent(JComponent jComponent) {
        if (this._actualComponent != null) {
            this.remove(this._actualComponent);
            this._actualComponent.putClientProperty("Overlayable.overlayable", null);
        }
        this._actualComponent = jComponent;
        this._actualComponent.putClientProperty("Overlayable.overlayable", this);
        this.add(this._actualComponent);
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    public Insets getOverlayLocationInsets() {
        return this._overlayLocationInsets;
    }

    public void setOverlayLocationInsets(Insets insets) {
        this._overlayLocationInsets = insets;
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
        }
    }

    public void setOverlayVisible(boolean bl) {
        JComponent[] jComponentArray;
        JComponent[] jComponentArray2 = jComponentArray = this.getOverlayComponents();
        int n = jComponentArray2.length;
        for (int i = 0; i < n; ++i) {
            JComponent jComponent = jComponentArray2[i];
            jComponent.setVisible(bl);
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.updateLocation();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.updateLocation();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.updateLocation();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.updateLocation();
    }
}

