/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class Animator
implements ActionListener {
    private final Component _source;
    private Timer _timer;
    private final int _totalSteps;
    private int _currentStep;
    private EventListenerList _listenerList = new EventListenerList();
    private static final /* synthetic */ Class class$com$jidesoft$swing$AnimatorListener;

    public Animator(Component component) {
        this(component, 50, 10, 10);
    }

    public Animator(Component component, int n, int n2, int n3) {
        this._source = component;
        this._totalSteps = n3;
        this._timer = this.createTimer(n2, this);
        this._timer.setInitialDelay(n);
    }

    protected Timer createTimer(int n, ActionListener actionListener) {
        return new Timer(n, actionListener);
    }

    public void addAnimatorListener(AnimatorListener animatorListener) {
        Class<?> clazz = class$com$jidesoft$swing$AnimatorListener;
        if (clazz == null) {
            clazz = class$com$jidesoft$swing$AnimatorListener = new AnimatorListener[0].getClass().getComponentType();
        }
        this._listenerList.add(clazz, animatorListener);
    }

    public void removeAnimatorListener(AnimatorListener animatorListener) {
        Class<?> clazz = class$com$jidesoft$swing$AnimatorListener;
        if (clazz == null) {
            clazz = class$com$jidesoft$swing$AnimatorListener = new AnimatorListener[0].getClass().getComponentType();
        }
        this._listenerList.remove(clazz, animatorListener);
    }

    public AnimatorListener[] getAnimatorListeners() {
        Class<?> clazz = class$com$jidesoft$swing$AnimatorListener;
        if (clazz == null) {
            clazz = class$com$jidesoft$swing$AnimatorListener = new AnimatorListener[0].getClass().getComponentType();
        }
        return (AnimatorListener[])this._listenerList.getListeners(clazz);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this._source != null) {
            AnimatorListener animatorListener;
            int n;
            int n2;
            AnimatorListener[] animatorListenerArray;
            AnimatorListener[] animatorListenerArray2;
            if (this._listenerList != null) {
                animatorListenerArray = animatorListenerArray2 = this.getAnimatorListeners();
                n2 = animatorListenerArray.length;
                for (n = 0; n < n2; ++n) {
                    animatorListener = animatorListenerArray[n];
                    animatorListener.animationFrame(this._source, this._totalSteps, this._currentStep);
                }
            }
            ++this._currentStep;
            if (this._totalSteps != -1 && this._currentStep > this._totalSteps) {
                this.stop();
                if (this._listenerList != null) {
                    animatorListenerArray = animatorListenerArray2 = this.getAnimatorListeners();
                    n2 = animatorListenerArray.length;
                    for (n = 0; n < n2; ++n) {
                        animatorListener = animatorListenerArray[n];
                        animatorListener.animationEnds(this._source);
                    }
                }
            }
        }
    }

    public void start() {
        if (this._listenerList != null) {
            AnimatorListener[] animatorListenerArray;
            AnimatorListener[] animatorListenerArray2 = animatorListenerArray = this.getAnimatorListeners();
            int n = animatorListenerArray2.length;
            for (int i = 0; i < n; ++i) {
                AnimatorListener animatorListener = animatorListenerArray2[i];
                animatorListener.animationStarts(this._source);
            }
        }
        if (this._timer != null) {
            this._timer.start();
        }
        this._currentStep = 0;
    }

    public void stop() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._currentStep = 0;
    }

    public void interrupt() {
        if (this._timer != null) {
            this._timer.stop();
        }
    }

    public boolean isRunning() {
        return this._timer != null && this._timer.isRunning();
    }

    public void setDelay(int n) {
        this._timer.setDelay(n);
    }

    public void dispose() {
        this.stop();
        this._timer.removeActionListener(this);
        this._timer = null;
    }
}

