/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.LazyActionMap;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.UIAction;
import com.jidesoft.plaf.eclipse.EclipseMenuUI;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class EclipseJideSplitButtonUI
extends EclipseMenuUI {
    protected ThemePainter _painter;
    protected Color _shadowColor;
    protected Color _darkShadowColor;
    protected Color _highlight;
    protected Color _lightHighlightColor;
    protected int _splitButtonMargin = 12;
    protected int _splitButtonMarginOnMenu = 20;
    private FocusListener _focusListener;
    private static final String propertyPrefix = "JideSplitButton";
    private static final /* synthetic */ Class class$com$jidesoft$plaf$eclipse$EclipseJideSplitButtonUI;

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new EclipseJideSplitButtonUI();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._shadowColor = UIDefaultsLookup.getColor("controlShadow");
        this._darkShadowColor = UIDefaultsLookup.getColor("controlDkShadow");
        this._highlight = UIDefaultsLookup.getColor("controlHighlight");
        this._lightHighlightColor = UIDefaultsLookup.getColor("controlLtHighlight");
        super.installDefaults();
    }

    protected void uninstallDefaults() {
        this._painter = null;
        this._shadowColor = null;
        this._highlight = null;
        this._lightHighlightColor = null;
        this._darkShadowColor = null;
        super.uninstallDefaults();
    }

    protected void installListeners() {
        super.installListeners();
        if (this._focusListener == null) {
            this._focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }

                public void focusLost(FocusEvent focusEvent) {
                    EclipseJideSplitButtonUI.this.menuItem.repaint();
                }
            };
        }
        this.menuItem.addFocusListener(this._focusListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this._focusListener != null) {
            this.menuItem.removeFocusListener(this._focusListener);
        }
    }

    static Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public InputMap getInputMap(int n, JComponent jComponent) {
        if (n == 0) {
            EclipseJideSplitButtonUI eclipseJideSplitButtonUI;
            ButtonUI buttonUI = ((JideSplitButton)jComponent).getUI();
            Class<?> clazz = class$com$jidesoft$plaf$eclipse$EclipseJideSplitButtonUI;
            if (clazz == null) {
                clazz = class$com$jidesoft$plaf$eclipse$EclipseJideSplitButtonUI = new EclipseJideSplitButtonUI[0].getClass().getComponentType();
            }
            if ((eclipseJideSplitButtonUI = (EclipseJideSplitButtonUI)EclipseJideSplitButtonUI.getUIOfType(buttonUI, clazz)) != null) {
                return (InputMap)UIDefaultsLookup.get(eclipseJideSplitButtonUI.getPropertyPrefix() + ".focusInputMap");
            }
        }
        return null;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        JMenuItem jMenuItem = this.menuItem;
        Class<?> clazz = class$com$jidesoft$plaf$eclipse$EclipseJideSplitButtonUI;
        if (clazz == null) {
            clazz = class$com$jidesoft$plaf$eclipse$EclipseJideSplitButtonUI = new EclipseJideSplitButtonUI[0].getClass().getComponentType();
        }
        LazyActionMap.installLazyActionMap(jMenuItem, clazz, "JideSplitButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jMenuItem);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, inputMap);
    }

    protected void uninstallKeyboardActions() {
        JMenuItem jMenuItem = this.menuItem;
        SwingUtilities.replaceUIInputMap(jMenuItem, 2, null);
        SwingUtilities.replaceUIInputMap(jMenuItem, 0, null);
        SwingUtilities.replaceUIActionMap(jMenuItem, null);
        super.uninstallKeyboardActions();
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MouseInputHandler();
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        Serializable serializable;
        ButtonModel buttonModel = jMenuItem.getModel();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (!((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            Color color2 = graphics.getColor();
            if (jMenuItem.isEnabled()) {
                if (buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                    graphics.setColor(this.selectionForeground);
                    graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                } else {
                    graphics.setColor(jMenuItem.getForeground());
                    graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                    JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
                }
            } else {
                graphics.setColor(UIDefaultsLookup.getColor("controlDkShadow"));
                graphics.drawLine(n - this._splitButtonMarginOnMenu, 0, n - this._splitButtonMarginOnMenu, n2 - 2);
                JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n - this._splitButtonMarginOnMenu / 2 - 2, n2 / 2 - 3, 7, 1);
            }
            graphics.setColor(color2);
            return;
        }
        if (jMenuItem.isOpaque()) {
            serializable = graphics.getColor();
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor((Color)serializable);
        }
        if (jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            this.getPainter().paintSelectedMenu(jMenuItem, graphics, new Rectangle(0, 0, n, n2), JideSwingUtilities.getOrientationOf(jMenuItem), 3);
        } else if (buttonModel.isArmed() || buttonModel.isPressed()) {
            serializable = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
            this.getPainter().paintButtonBackground(jMenuItem, graphics, (Rectangle)serializable, JideSwingUtilities.getOrientationOf(jMenuItem), 1);
            serializable = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
            this.getPainter().paintButtonBackground(jMenuItem, graphics, (Rectangle)serializable, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
        } else if (this.isMouseOver() && buttonModel.isEnabled()) {
            serializable = new Rectangle(0, 0, n - this._splitButtonMargin, n2);
            this.getPainter().paintButtonBackground(jMenuItem, graphics, (Rectangle)serializable, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
            serializable = new Rectangle(n - this._splitButtonMargin - 1 + this.getOffset(), 0, this._splitButtonMargin - this.getOffset(), n2);
            this.getPainter().paintButtonBackground(jMenuItem, graphics, (Rectangle)serializable, JideSwingUtilities.getOrientationOf(jMenuItem), 2);
        }
        if (jMenuItem.isEnabled()) {
            JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n - 10, n2 / 2 - 1, 5, 0);
        } else {
            JideSwingUtilities.paintArrow(graphics, UIDefaultsLookup.getColor("controlDkShadow"), n - 10, n2 / 2 - 1, 5, 0);
        }
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMinimumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
            }
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getMaximumSize(jComponent);
        }
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
                dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            } else {
                dimension.height = (int)((float)dimension.height + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            }
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (!(jComponent instanceof JMenu) || !((JMenu)jComponent).isTopLevelMenu()) {
            return super.getPreferredSize(jComponent);
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        boolean bl = true;
        if (JideSwingUtilities.getOrientationOf(jComponent) == 1) {
            bl = false;
        }
        Dimension dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, this.defaultTextIconGap);
        int n = ((JMenu)this.menuItem).isTopLevelMenu() ? this._splitButtonMargin : this._splitButtonMarginOnMenu;
        dimension.width += n;
        if (bl) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    protected void paintIcon(JMenuItem jMenuItem, Graphics graphics) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (jMenuItem.getIcon() != null) {
            Icon icon;
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                graphics.translate(0, jMenuItem.getWidth() - 1);
                ((Graphics2D)graphics).rotate(-1.5707963267948966);
            }
            if (!buttonModel.isEnabled()) {
                icon = jMenuItem.getDisabledIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                    icon = icon instanceof ImageIcon ? IconsFactory.createGrayImage(((ImageIcon)icon).getImage()) : IconsFactory.createGrayImage(jMenuItem, icon);
                }
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = jMenuItem.getPressedIcon();
                if (icon == null) {
                    icon = jMenuItem.getIcon();
                }
            } else {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, EclipseJideSplitButtonUI.iconRect.x, EclipseJideSplitButtonUI.iconRect.y);
            }
            if (JideSwingUtilities.getOrientationOf(jMenuItem) == 1) {
                ((Graphics2D)graphics).rotate(1.5707963267948966);
                graphics.translate(0, -jMenuItem.getHeight() + 1);
            }
        }
    }

    protected int getOffset() {
        return 1;
    }

    public static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("pressed"));
        lazyActionMap.put(new Actions("released"));
        lazyActionMap.put(new Actions("downPressed"));
        lazyActionMap.put(new Actions("downReleased"));
    }

    protected static void downButtonPressed(JMenu jMenu) {
        Object object;
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        if (jMenu.isTopLevelMenu()) {
            if (jMenu.isSelected()) {
                menuSelectionManager.clearSelectedPath();
            } else {
                object = EclipseJideSplitButtonUI.getFirstParentMenuElement(jMenu);
                if (object != null && object instanceof MenuElement) {
                    ArrayList<MenuElement[]> arrayList = new ArrayList<MenuElement[]>();
                    while (object instanceof MenuElement) {
                        arrayList.add(0, (MenuElement[])object);
                        if (object instanceof JPopupMenu) {
                            object = (Container)((JPopupMenu)object).getInvoker();
                            continue;
                        }
                        object = EclipseJideSplitButtonUI.getFirstParentMenuElement((Component)object);
                    }
                    MenuElement[] menuElementArray = new MenuElement[arrayList.size() + 1];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Container container = (Container)arrayList.get(i);
                        menuElementArray[i] = (MenuElement)((Object)container);
                    }
                    menuElementArray[arrayList.size()] = jMenu;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                } else {
                    MenuElement[] menuElementArray = new MenuElement[]{jMenu};
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }
        if (((MenuElement[])(object = menuSelectionManager.getSelectedPath())).length > 0 && object[((MenuElement[])object).length - 1] != jMenu.getPopupMenu()) {
            if (jMenu.isTopLevelMenu() || jMenu.getDelay() == 0) {
                EclipseJideSplitButtonUI.appendPath(object, jMenu.getPopupMenu());
            } else {
                EclipseJideSplitButtonUI.setupPostTimer(jMenu);
            }
        }
    }

    protected static Container getFirstParentMenuElement(Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof MenuElement)) continue;
            return container;
        }
        return null;
    }

    private static class Actions
    extends UIAction {
        private static final String PRESS = "pressed";
        private static final String RELEASE = "released";
        private static final String DOWN_PRESS = "downPressed";
        private static final String DOWN_RELEASE = "downReleased";

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            String string = this.getName();
            if (PRESS.equals(string) && ((JideSplitButton)abstractButton).isAlwaysDropdown()) {
                string = DOWN_PRESS;
            }
            if (PRESS.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setArmed(true);
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus()) {
                    abstractButton.requestFocus();
                }
            } else if (RELEASE.equals(string)) {
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            } else if (DOWN_PRESS.equals(string)) {
                EclipseJideSplitButtonUI.downButtonPressed((JMenu)abstractButton);
            } else if (DOWN_RELEASE.equals(string)) {
                // empty if block
            }
        }

        public boolean isEnabled(Object object) {
            return object == null || !(object instanceof AbstractButton) || ((AbstractButton)object).getModel().isEnabled();
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.cancelMenuIfNecessary(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            EclipseJideSplitButtonUI.this.setMouseOver(true);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu)) {
                if (((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                    jMenu.getModel().setArmed(true);
                    jMenu.getModel().setPressed(true);
                }
                if (!jMenu.hasFocus() && jMenu.isRequestFocusEnabled()) {
                    jMenu.requestFocus();
                }
            } else {
                EclipseJideSplitButtonUI.downButtonPressed(jMenu);
            }
        }

        private boolean isClickOnButton(MouseEvent mouseEvent, JMenu jMenu) {
            int n;
            if (((JideSplitButton)jMenu).isAlwaysDropdown()) {
                return false;
            }
            boolean bl = false;
            int n2 = n = ((JMenu)EclipseJideSplitButtonUI.this.menuItem).isTopLevelMenu() ? EclipseJideSplitButtonUI.this._splitButtonMargin : EclipseJideSplitButtonUI.this._splitButtonMarginOnMenu;
            if (JideSwingUtilities.getOrientationOf(EclipseJideSplitButtonUI.this.menuItem) == 0) {
                if (mouseEvent.getPoint().getX() < (double)(jMenu.getWidth() - n)) {
                    bl = true;
                }
            } else if (mouseEvent.getPoint().getY() < (double)(jMenu.getHeight() - n)) {
                bl = true;
            }
            return bl;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (!this.isClickOnButton(mouseEvent, jMenu)) {
                EclipseJideSplitButtonUI.this.menuItem.getModel().setArmed(false);
                EclipseJideSplitButtonUI.this.menuItem.getModel().setPressed(false);
            }
            this.cancelMenuIfNecessary(mouseEvent);
        }

        private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            if (this.isClickOnButton(mouseEvent, jMenu) && ((JideSplitButton)EclipseJideSplitButtonUI.this.menuItem).isButtonEnabled()) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    jMenu.getModel().setPressed(false);
                    jMenu.getModel().setArmed(false);
                } else {
                    jMenu.getModel().setArmed(false);
                    jMenu.getModel().setPressed(false);
                }
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
                for (int i = menuElementArray.length - 1; i >= 0; --i) {
                    MenuElement menuElement = menuElementArray[i];
                    if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(jMenu)) continue;
                    jMenu.getModel().setRollover(false);
                    EclipseJideSplitButtonUI.this.setMouseOver(false);
                    menuSelectionManager.clearSelectedPath();
                }
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (!jMenu.isTopLevelMenu()) {
                if (menuElementArray.length <= 0 || menuElementArray[menuElementArray.length - 1] != jMenu.getPopupMenu()) {
                    if (jMenu.getDelay() == 0) {
                        EclipseMenuUI.appendPath(EclipseJideSplitButtonUI.this.getPath(), jMenu.getPopupMenu());
                    } else {
                        menuSelectionManager.setSelectedPath(EclipseJideSplitButtonUI.this.getPath());
                        EclipseMenuUI.setupPostTimer(jMenu);
                    }
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0] == jMenu.getParent()) {
                MenuElement[] menuElementArray2 = new MenuElement[]{(MenuElement)((Object)jMenu.getParent()), jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            }
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                EclipseJideSplitButtonUI.this.setMouseOver(true);
            }
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            EclipseJideSplitButtonUI.this.setMouseOver(false);
            EclipseJideSplitButtonUI.this.menuItem.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JMenu jMenu = (JMenu)EclipseJideSplitButtonUI.this.menuItem;
            if (!jMenu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

