/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFolderChooserIconsFactory;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FolderToolBar
extends JToolBar {
    private static final FileSystemView _fsv = FileSystemView.getFileSystemView();
    private JButton _deleteFolderBtn;
    private JButton _newFolderBtn;
    private JComboBox _recentFoldersList;
    private List<FolderToolBarListener> _listeners = new ArrayList<FolderToolBarListener>(1);
    private static final String DELETE_BUTTON_NAME = "FolderChooser.toolbar.delete";
    private static final String NEW_BUTTON_NAME = "FolderChooser.toolbar.new";
    private static final String REFRESH_BUTTON_NAME = "FolderChooser.toolbar.refresh";
    private static final String DESKTOP_BUTTON_NAME = "FolderChooser.toolbar.desktop";
    private static final String MY_DOCUMENTS_BUTTON_NAME = "FolderChooser.toolbar.mydocuments";

    public FolderToolBar(boolean bl, List<String> list) {
        this.setFloatable(false);
        this.setupToolBar(bl, list);
    }

    public void enableDelete() {
        this._deleteFolderBtn.setEnabled(true);
    }

    public void disableDelete() {
        this._deleteFolderBtn.setEnabled(false);
    }

    public void enableNewFolder() {
        this._newFolderBtn.setEnabled(true);
    }

    public void disableNewFolder() {
        this._newFolderBtn.setEnabled(false);
    }

    private void setupToolBar(boolean bl, List<String> list) {
        Accessible accessible;
        Object object;
        if (bl) {
            this._recentFoldersList = new JComboBox(new DefaultComboBoxModel());
            if (list != null && list.size() > 0) {
                this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            }
            this._recentFoldersList.setEditable(false);
            this._recentFoldersList.setRenderer(new FileListCellRenderer());
            this._recentFoldersList.addPopupMenuListener(new PopupMenuListener(){
                private boolean m_wasCancelled = false;

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.m_wasCancelled = false;
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (popupMenuEvent.getSource() instanceof JComboBox) {
                        JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
                        Object object = jComboBox.getModel().getSelectedItem();
                        if (!this.m_wasCancelled && object != null) {
                            if (object instanceof File) {
                                FolderToolBar.this.recentFolderSelected((File)object);
                            } else {
                                FolderToolBar.this.recentFolderSelected(new File("" + object));
                            }
                        }
                    }
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.m_wasCancelled = true;
                }
            });
            this._recentFoldersList.setPrototypeDisplayValue("AAAAAAAAAAAAAAAAAA");
            object = FolderChooserResource.getResourceBundle(Locale.getDefault());
            this.add(new JLabel(((ResourceBundle)object).getString("FolderChooser.toolbar.recent")));
            this.add(this._recentFoldersList);
        } else {
            this.add(Box.createHorizontalGlue());
        }
        object = new NoFocusButton(new ToolBarAction(null, SystemInfo.isWindows() ? _fsv.getSystemIcon(_fsv.getHomeDirectory()) : BasicFolderChooserIconsFactory.getImageIcon("icons/home.png")){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderToolBar.this.desktopButtonClicked();
            }
        });
        ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
        ((JComponent)object).setToolTipText(SystemInfo.isWindows() ? resourceBundle.getString(DESKTOP_BUTTON_NAME) : resourceBundle.getString("FolderChooser.toolbar.home"));
        ((Component)object).setName(DESKTOP_BUTTON_NAME);
        this.add((Component)object);
        if (SystemInfo.isWindows()) {
            accessible = new NoFocusButton(new ToolBarAction(null, _fsv.getSystemIcon(_fsv.getDefaultDirectory())){

                public void actionPerformed(ActionEvent actionEvent) {
                    FolderToolBar.this.myDocumentsButtonClicked();
                }
            });
            ((JComponent)((Object)accessible)).setToolTipText(resourceBundle.getString(MY_DOCUMENTS_BUTTON_NAME));
            ((Component)((Object)accessible)).setName(MY_DOCUMENTS_BUTTON_NAME);
            this.add((Component)((Object)accessible));
        }
        accessible = BasicFolderChooserIconsFactory.getImageIcon("icons/delete.png");
        this._deleteFolderBtn = new NoFocusButton(new ToolBarAction(null, (Icon)((Object)accessible)){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderToolBar.this.deleteFolderButtonClicked();
            }
        });
        this._deleteFolderBtn.setToolTipText(resourceBundle.getString(DELETE_BUTTON_NAME));
        this._deleteFolderBtn.setName(DELETE_BUTTON_NAME);
        ImageIcon imageIcon = BasicFolderChooserIconsFactory.getImageIcon("icons/new.png");
        this._newFolderBtn = new NoFocusButton(new ToolBarAction(null, imageIcon){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderToolBar.this.newFolderButtonClicked();
            }
        });
        this._newFolderBtn.setToolTipText(resourceBundle.getString(NEW_BUTTON_NAME));
        this._newFolderBtn.setName(NEW_BUTTON_NAME);
        ImageIcon imageIcon2 = BasicFolderChooserIconsFactory.getImageIcon("icons/refresh.png");
        NoFocusButton noFocusButton = new NoFocusButton(new ToolBarAction(null, imageIcon2){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderToolBar.this.refreshButtonClicked();
            }
        });
        noFocusButton.setToolTipText(resourceBundle.getString(REFRESH_BUTTON_NAME));
        noFocusButton.setName(REFRESH_BUTTON_NAME);
        this.add(this._deleteFolderBtn);
        this.add(this._newFolderBtn);
        this.add(noFocusButton);
    }

    boolean isButtonVisible(String string, int n) {
        if (DELETE_BUTTON_NAME.equals(string)) {
            return (n & 1) != 0;
        }
        if (NEW_BUTTON_NAME.equals(string)) {
            return (n & 2) != 0;
        }
        if (REFRESH_BUTTON_NAME.equals(string)) {
            return (n & 4) != 0;
        }
        if (DESKTOP_BUTTON_NAME.equals(string)) {
            return (n & 8) != 0;
        }
        if (MY_DOCUMENTS_BUTTON_NAME.equals(string)) {
            return (n & 0x10) != 0;
        }
        return true;
    }

    public void addListener(FolderToolBarListener folderToolBarListener) {
        this._listeners.add(folderToolBarListener);
    }

    public void removeListener(FolderToolBarListener folderToolBarListener) {
        this._listeners.remove(folderToolBarListener);
    }

    public void clearListeners() {
        this._listeners.clear();
    }

    private void deleteFolderButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.deleteFolderButtonClicked();
        }
    }

    private void newFolderButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.newFolderButtonClicked();
        }
    }

    private void refreshButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.refreshButtonClicked();
        }
    }

    private void myDocumentsButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.myDocumentsButtonClicked();
        }
    }

    private void desktopButtonClicked() {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.desktopButtonClicked();
        }
    }

    private void recentFolderSelected(File file) {
        for (FolderToolBarListener folderToolBarListener : this._listeners) {
            folderToolBarListener.recentFolderSelected(file);
        }
    }

    public void setRecentList(List<String> list) {
        if (list != null) {
            this._recentFoldersList.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        }
    }

    static class NoFocusButton
    extends JButton {
        public NoFocusButton(Action action) {
            super(action);
            this.setRequestFocusEnabled(false);
            this.setFocusable(false);
            Insets insets = this.getMargin();
            insets.left = insets.top;
            insets.right = insets.bottom;
            this.setMargin(insets);
        }
    }

    private abstract class ToolBarAction
    extends AbstractAction {
        public ToolBarAction(String string, Icon icon) {
            super(string, icon);
        }
    }

    private class FileListCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer m_defaultRenderer = new DefaultListCellRenderer();

        private FileListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)this.m_defaultRenderer.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = null;
            if (object instanceof File) {
                file = (File)object;
            } else if (object != null) {
                file = new File(object.toString());
            }
            if (file != null && file.exists()) {
                String string = _fsv.getSystemDisplayName(file);
                Icon icon = _fsv.getSystemIcon(file);
                jLabel.setIcon(icon);
                jLabel.setText(string);
                jLabel.setToolTipText(file.getAbsolutePath());
            } else {
                String string = object == null ? "" : object.toString();
                jLabel.setText(string);
                jLabel.setToolTipText(string);
            }
            return jLabel;
        }
    }
}

