/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.plaf.aqua.XMLElement;
import com.jidesoft.utils.Base64;
import com.jidesoft.utils.SecurityUtils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.sourceforge.retroweaver.runtime.java.lang.Double_;
import net.sourceforge.retroweaver.runtime.java.lang.Float_;
import net.sourceforge.retroweaver.runtime.java.lang.Long_;

class BinaryPListParser {
    private int refCount;
    private int offsetCount;
    private int objectCount;
    private int topLevelOffset;
    private ArrayList objectTable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            int n = randomAccessFile.readInt();
            int n2 = randomAccessFile.readInt();
            if (n != 1651534953 || n2 != 1936994352) {
                throw new IOException("parseHeader: File does not start with 'bplist00' magic.");
            }
            randomAccessFile.seek(randomAccessFile.length() - 32L);
            this.offsetCount = (int)randomAccessFile.readLong();
            this.refCount = (int)randomAccessFile.readLong();
            this.objectCount = (int)randomAccessFile.readLong();
            this.topLevelOffset = (int)randomAccessFile.readLong();
            byArray = new byte[this.topLevelOffset - 8];
            randomAccessFile.seek(8L);
            randomAccessFile.readFully(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
        this.objectTable = new ArrayList();
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.parseObjectTable((DataInputStream)filterInputStream);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
        XMLElement xMLElement = new XMLElement(new HashMap(), false, false);
        xMLElement.setName("plist");
        xMLElement.setAttribute("version", "1.0");
        this.convertObjectTableToXML(xMLElement, this.objectTable.get(0));
        return xMLElement;
    }

    private void convertObjectTableToXML(XMLElement xMLElement, Object object) {
        XMLElement xMLElement2 = xMLElement.createAnotherElement();
        if (object instanceof BPLDict) {
            BPLDict bPLDict = (BPLDict)object;
            xMLElement2.setName("dict");
            for (int i = 0; i < bPLDict.keyref.length; ++i) {
                XMLElement xMLElement3 = xMLElement.createAnotherElement();
                xMLElement3.setName("key");
                xMLElement3.setContent(bPLDict.getKey(i));
                xMLElement2.addChild(xMLElement3);
                this.convertObjectTableToXML(xMLElement2, bPLDict.getValue(i));
            }
        } else if (object instanceof BPLArray) {
            BPLArray bPLArray = (BPLArray)object;
            xMLElement2.setName("array");
            for (int i = 0; i < bPLArray.objref.length; ++i) {
                this.convertObjectTableToXML(xMLElement2, bPLArray.getValue(i));
            }
        } else if (object instanceof String) {
            xMLElement2.setName("string");
            xMLElement2.setContent((String)object);
        } else if (object instanceof Integer) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Long) {
            xMLElement2.setName("integer");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Float) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Double) {
            xMLElement2.setName("real");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof Boolean) {
            xMLElement2.setName("boolean");
            xMLElement2.setContent(object.toString());
        } else if (object instanceof byte[]) {
            xMLElement2.setName("data");
            xMLElement2.setContent(Base64.encodeBytes((byte[])object));
        } else if (object instanceof Date) {
            xMLElement2.setName("date");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            xMLElement2.setContent(simpleDateFormat.format((Date)object));
        } else {
            xMLElement2.setName("unsupported");
            xMLElement2.setContent(object.toString());
        }
        xMLElement.addChild(xMLElement2);
    }

    private void parseObjectTable(DataInputStream dataInputStream) throws IOException {
        int n;
        while ((n = dataInputStream.read()) != -1) {
            switch ((n & 0xF0) >> 4) {
                case 0: {
                    this.parsePrimitive(dataInputStream, n & 0xF);
                    break;
                }
                case 1: {
                    int n2 = 1 << (n & 0xF);
                    this.parseInt(dataInputStream, n2);
                    break;
                }
                case 2: {
                    int n2 = 1 << (n & 0xF);
                    this.parseReal(dataInputStream, n2);
                    break;
                }
                case 3: {
                    if ((n & 0xF) != 3) {
                        throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    }
                    this.parseDate(dataInputStream);
                    break;
                }
                case 4: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseData(dataInputStream, n2);
                    break;
                }
                case 5: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseAsciiString(dataInputStream, n2);
                    break;
                }
                case 6: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    this.parseUnicodeString(dataInputStream, n2);
                    break;
                }
                case 7: {
                    System.out.println("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                    return;
                }
                case 8: {
                    int n2 = (n & 0xF) + 1;
                    System.out.println("uid " + n2);
                    break;
                }
                case 9: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 10: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 255) {
                        this.parseShortArray(dataInputStream, n2);
                        break;
                    }
                    this.parseByteArray(dataInputStream, n2);
                    break;
                }
                case 11: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 12: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 13: {
                    int n2 = n & 0xF;
                    if (n2 == 15) {
                        n2 = this.readCount(dataInputStream);
                    }
                    if (this.refCount > 256) {
                        this.parseShortDict(dataInputStream, n2);
                        break;
                    }
                    this.parseByteDict(dataInputStream, n2);
                    break;
                }
                case 14: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
                case 15: {
                    throw new IOException("parseObjectTable: illegal marker " + Integer.toBinaryString(n));
                }
            }
        }
    }

    private int readCount(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.read();
        if (n == -1) {
            throw new IOException("variableLengthInt: Illegal EOF in marker");
        }
        if ((n & 0xF0) >> 4 != 1) {
            throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(n));
        }
        int n2 = 1 << (n & 0xF);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            int n4 = dataInputStream.read();
            if (n4 == -1) {
                throw new IOException("variableLengthInt: Illegal EOF in value");
            }
            n3 = n3 << 8 | n4;
        }
        return n3;
    }

    private void parsePrimitive(DataInputStream dataInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                this.objectTable.add(null);
                break;
            }
            case 8: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case 9: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + Integer.toBinaryString(n));
            }
        }
    }

    private void parseByteArray(DataInputStream dataInputStream, int n) throws IOException {
        BPLArray bPLArray = new BPLArray();
        bPLArray.objectTable = this.objectTable;
        bPLArray.objref = new int[n];
        for (int i = 0; i < n; ++i) {
            bPLArray.objref[i] = dataInputStream.readByte() & 0xFF;
            if (bPLArray.objref[i] != -1) continue;
            throw new IOException("parseByteArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseShortArray(DataInputStream dataInputStream, int n) throws IOException {
        BPLArray bPLArray = new BPLArray();
        bPLArray.objectTable = this.objectTable;
        bPLArray.objref = new int[n];
        for (int i = 0; i < n; ++i) {
            bPLArray.objref[i] = dataInputStream.readShort() & 0xFFFF;
            if (bPLArray.objref[i] != -1) continue;
            throw new IOException("parseShortArray: illegal EOF in objref*");
        }
        this.objectTable.add(bPLArray);
    }

    private void parseData(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this.objectTable.add(byArray);
    }

    private void parseByteDict(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        BPLDict bPLDict = new BPLDict();
        bPLDict.objectTable = this.objectTable;
        bPLDict.keyref = new int[n];
        bPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.keyref[n2] = dataInputStream.readByte() & 0xFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.objref[n2] = dataInputStream.readByte() & 0xFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseShortDict(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        BPLDict bPLDict = new BPLDict();
        bPLDict.objectTable = this.objectTable;
        bPLDict.keyref = new int[n];
        bPLDict.objref = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.keyref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        for (n2 = 0; n2 < n; ++n2) {
            bPLDict.objref[n2] = dataInputStream.readShort() & 0xFFFF;
        }
        this.objectTable.add(bPLDict);
    }

    private void parseAsciiString(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "ASCII");
        this.objectTable.add(string);
    }

    private void parseInt(DataInputStream dataInputStream, int n) throws IOException {
        if (n > 8) {
            throw new IOException("parseInt: unsupported byte count:" + n);
        }
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.read();
            if (n2 == -1) {
                throw new IOException("parseInt: Illegal EOF in value");
            }
            l = l << 8 | (long)n2;
        }
        this.objectTable.add(Long_.valueOf((long)l));
    }

    private void parseReal(DataInputStream dataInputStream, int n) throws IOException {
        switch (n) {
            case 4: {
                this.objectTable.add(Float_.valueOf((float)dataInputStream.readFloat()));
                break;
            }
            case 8: {
                this.objectTable.add(Double_.valueOf((double)dataInputStream.readDouble()));
                break;
            }
            default: {
                throw new IOException("parseReal: unsupported byte count:" + n);
            }
        }
    }

    private void parseDate(DataInputStream dataInputStream) throws IOException {
        double d = dataInputStream.readDouble();
        this.objectTable.add(new Date());
    }

    private void parseUnicodeString(DataInputStream dataInputStream, int n) throws IOException {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        String string = new String(cArray);
        this.objectTable.add(string);
    }

    public static void main(String[] stringArray) {
        try {
            File[] fileArray = new File(SecurityUtils.getProperty("user.home", ""), "Library/Preferences").listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (fileArray[i].isDirectory() || !string.endsWith(".plist") || string.endsWith("internetconfig.plist")) continue;
                try {
                    System.out.println(fileArray[i]);
                    BinaryPListParser binaryPListParser = new BinaryPListParser();
                    XMLElement xMLElement = binaryPListParser.parse(fileArray[i]);
                    System.out.println(xMLElement);
                    continue;
                }
                catch (IOException iOException) {
                    if (iOException.getMessage() != null && (iOException.getMessage().startsWith("parseHeader") || iOException.getMessage().startsWith("parseTrailer"))) {
                        System.out.println(iOException);
                        continue;
                    }
                    throw iOException;
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static class BPLDict {
        ArrayList objectTable;
        int[] keyref;
        int[] objref;

        private BPLDict() {
        }

        public String getKey(int n) {
            return this.objectTable.get(this.keyref[n]).toString();
        }

        public Object getValue(int n) {
            return this.objectTable.get(this.objref[n]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("BPLDict{");
            for (int i = 0; i < this.keyref.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.keyref[i] < 0 || this.keyref[i] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.keyref[i]);
                } else if (this.objectTable.get(this.keyref[i]) == this) {
                    stringBuffer.append("*" + this.keyref[i]);
                } else {
                    stringBuffer.append(this.objectTable.get(this.keyref[i]));
                }
                stringBuffer.append(":");
                if (this.objref[i] < 0 || this.objref[i] >= this.objectTable.size()) {
                    stringBuffer.append("#" + this.objref[i]);
                    continue;
                }
                if (this.objectTable.get(this.objref[i]) == this) {
                    stringBuffer.append("*" + this.objref[i]);
                    continue;
                }
                stringBuffer.append(this.objectTable.get(this.objref[i]));
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }

    private static class BPLArray {
        ArrayList objectTable;
        int[] objref;

        private BPLArray() {
        }

        public Object getValue(int n) {
            return this.objectTable.get(this.objref[n]);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("Array{");
            for (int i = 0; i < this.objref.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                if (this.objectTable.size() > this.objref[i] && this.objectTable.get(this.objref[i]) != this) {
                    stringBuffer.append(this.objectTable.get(this.objref[i]));
                    continue;
                }
                stringBuffer.append("*" + this.objref[i]);
            }
            stringBuffer.append('}');
            return stringBuffer.toString();
        }
    }
}

