/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.icons;

import com.jidesoft.icons.IconSet;
import com.jidesoft.icons.IconsFactory;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class IconSetManager {
    private Map<String, IconSet> _availableStyles;
    private String _activeIconSetName = null;
    private IconSet _activeIconSet = null;
    private static final /* synthetic */ Class class$com$jidesoft$icons$IconSetManager;

    public IconSet findIconSet(String string) {
        if (this._availableStyles == null) {
            return null;
        }
        return this._availableStyles.get(string);
    }

    public String getActiveIconSetName() {
        return this._activeIconSetName;
    }

    public IconSet getActiveIconSet() {
        return this._activeIconSet;
    }

    public void add(String string, int[] nArray, String string2) {
        if (this._availableStyles == null) {
            this._availableStyles = new HashMap<String, IconSet>();
        }
        this._availableStyles.put(string, new IconSet(string, nArray, string2));
        if (this._availableStyles.size() == 1) {
            this.setActiveIconSetName(string);
        }
    }

    public void remove(String string) {
        if (this._availableStyles != null) {
            this._availableStyles.remove(string);
        }
    }

    public void setActiveIconSetName(String string) {
        IconSet iconSet = this.findIconSet(string);
        if (iconSet == null) {
            throw new IllegalArgumentException("Icon set \"" + string + "\" not found");
        }
        this._activeIconSet = iconSet;
        this._activeIconSetName = string;
    }

    public ImageIcon getImageIcon(String string) {
        return this.getImageIcon(string, 16);
    }

    public ImageIcon getImageIcon(String string, int n) {
        String string2 = this._activeIconSet.getPackageName();
        int n2 = this._activeIconSet.getNextAvailableSize(n);
        String string3 = string2 + "/png/" + n2 + "x" + n2 + "/" + string;
        Class<?> clazz = class$com$jidesoft$icons$IconSetManager;
        if (clazz == null) {
            clazz = class$com$jidesoft$icons$IconSetManager = new IconSetManager[0].getClass().getComponentType();
        }
        ImageIcon imageIcon = IconsFactory.getImageIcon(clazz, string3);
        if (n2 == n) {
            return imageIcon;
        }
        return IconsFactory.getScaledImage(null, imageIcon, n, n);
    }

    public ImageIcon getOverlayImageIcon(String string, int n, String string2, int n2) {
        return this.getOverlayImageIcon(string, n, string2, n2, new Insets(0, 0, 0, 0));
    }

    public ImageIcon getOverlayImageIcon(String string, int n, String string2, int n2, Insets insets) {
        ImageIcon imageIcon = this.getImageIcon(string, n);
        if (imageIcon == null) {
            return null;
        }
        ImageIcon imageIcon2 = this.getImageIcon(string2, n);
        if (imageIcon2 == null) {
            return imageIcon;
        }
        imageIcon2 = IconsFactory.getIcon(null, imageIcon2, n / 4, n / 4, n / 2, n / 2);
        return IconsFactory.getOverlayIcon(null, imageIcon, imageIcon2, n2, insets);
    }

    public ImageIcon getOverlayImageIcon(String string, int n, String string2, int n2, int n3, Insets insets) {
        ImageIcon imageIcon = this.getImageIcon(string, n);
        if (imageIcon == null) {
            return null;
        }
        ImageIcon imageIcon2 = this.getImageIcon(string2, n2);
        if (imageIcon2 == null) {
            return imageIcon;
        }
        return IconsFactory.getOverlayIcon(null, imageIcon, imageIcon2, n3, insets);
    }
}

