/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonEvent;
import com.jidesoft.dialog.ButtonListener;
import com.jidesoft.dialog.ButtonNames;
import com.jidesoft.dialog.ButtonPanelLayout;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ArrowKeyNavigationSupport;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class ButtonPanel
extends JPanel
implements ButtonListener,
ButtonNames {
    public static final int SAME_SIZE = 0;
    public static final int NO_LESS_THAN = 1;
    public static final String KEEP_PREFERRED_WIDTH = "keepPreferredWidth";
    public static final String AFFIRMATIVE_BUTTON = "AFFIRMATIVE";
    public static final String CANCEL_BUTTON = "CANCEL";
    public static final String HELP_BUTTON = "HELP";
    public static final String OTHER_BUTTON = "ALTERNATIVE";
    private String _defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
    private String _defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
    private int _defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
    private int _defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
    private int _defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
    private int _alignment;
    private ButtonPanelLayout _layout;
    private boolean _addNotify = false;
    private JButton _defaultButton;
    private static final /* synthetic */ Class class$javax$swing$AbstractButton;

    public ButtonPanel() {
        this(11);
    }

    public ButtonPanel(int n) {
        this(n, 0);
    }

    public ButtonPanel(int n, int n2) {
        this._alignment = n;
        if (n != 2 && n != 4 && n != 10 && n != 11 && n != 1 && n != 3 && n != 0) {
            throw new IllegalArgumentException("Invalid alignment");
        }
        int n3 = this._alignment == 0 || this._alignment == 2 || this._alignment == 4 || this._alignment == 11 || this._alignment == 10 ? 0 : 1;
        this._layout = new ButtonPanelLayout(this, n3, this._alignment, n2, this._defaultOrder, this._defaultOppositeOrder, this._defaultButtonGap, this._defaultGroupGap);
        this.setLayout(this._layout);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$javax$swing$AbstractButton;
        if (clazz == null) {
            clazz = class$javax$swing$AbstractButton = new AbstractButton[0].getClass().getComponentType();
        }
        classArray[0] = clazz;
        new ArrowKeyNavigationSupport(classArray).install(this);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("ButtonPanel.buttonGap") == null && UIDefaultsLookup.get("ButtonPanel.order") == null && UIDefaultsLookup.get("ButtonPanel.groupGap") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
        this.reinstallDefaults();
    }

    protected void reinstallDefaults() {
        if (this._layout != null) {
            if (this._defaultButtonGap == this._layout.getButtonGap()) {
                this._defaultButtonGap = UIDefaultsLookup.getInt("ButtonPanel.buttonGap");
                this._layout.setButtonGap(this._defaultButtonGap);
            }
            if (this._defaultGroupGap == this._layout.getGroupGap()) {
                this._defaultGroupGap = UIDefaultsLookup.getInt("ButtonPanel.groupGap");
                this._layout.setGroupGap(this._defaultGroupGap);
            }
            if (this._defaultOrder.equals(this._layout.getButtonOrder())) {
                this._defaultOrder = UIDefaultsLookup.getString("ButtonPanel.order");
                this._layout.setButtonOrder(this._defaultOrder);
            }
            if (this._defaultOppositeOrder.equals(this._layout.getOppositeButtonOrder())) {
                this._defaultOppositeOrder = UIDefaultsLookup.getString("ButtonPanel.oppositeOrder");
                this._layout.setOppositeButtonOrder(this._defaultOppositeOrder);
            }
            if (this._defaultButtonWidth == this._layout.getMinButtonWidth()) {
                this._defaultButtonWidth = UIDefaultsLookup.getInt("ButtonPanel.minButtonWidth");
                this._layout.setMinButtonWidth(this._defaultButtonWidth);
            }
        }
    }

    public void setAlignment(int n) {
        this._alignment = n;
        int n2 = this._alignment == 0 || this._alignment == 2 || this._alignment == 4 || this._alignment == 10 || this._alignment == 11 ? 0 : 1;
        this._layout.setAlignment(this._alignment);
        this._layout.setAxis(n2);
        this._layout.layoutContainer(this);
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void addButton(AbstractButton abstractButton) {
        this.addButton(abstractButton, AFFIRMATIVE_BUTTON);
    }

    public void addButton(AbstractButton abstractButton, int n) {
        this.addButton(abstractButton, AFFIRMATIVE_BUTTON, n);
    }

    public void addButton(AbstractButton abstractButton, Object object) {
        this.addButton(abstractButton, object, -1);
    }

    public void addButton(AbstractButton abstractButton, Object object, int n) {
        this.add(abstractButton, object, n);
    }

    protected void addImpl(Component component, Object object, int n) {
        if (object == null) {
            object = AFFIRMATIVE_BUTTON;
        }
        super.addImpl(component, object, n);
    }

    public void removeButton(AbstractButton abstractButton) {
        this.remove(abstractButton);
    }

    public String getButtonOrder() {
        return this._layout.getButtonOrder();
    }

    public void setButtonOrder(String string) {
        this._layout.setButtonOrder(string);
    }

    public String getOppositeButtonOrder() {
        return this._layout.getOppositeButtonOrder();
    }

    public void setOppositeButtonOrder(String string) {
        this._layout.setOppositeButtonOrder(string);
    }

    public int getSizeConstraint() {
        return this._layout.getSizeConstraint();
    }

    public void setSizeConstraint(int n) {
        this._layout.setSizeConstraint(n);
    }

    public int getGroupGap() {
        return this._layout.getGroupGap();
    }

    public void setGroupGap(int n) {
        this._layout.setGroupGap(n);
    }

    public int getButtonGap() {
        return this._layout.getButtonGap();
    }

    public void setButtonGap(int n) {
        this._layout.setButtonGap(n);
    }

    public int getMinButtonWidth() {
        return this._layout.getMinButtonWidth();
    }

    public void setMinButtonWidth(int n) {
        this._layout.setMinButtonWidth(n);
    }

    public void buttonEventFired(ButtonEvent buttonEvent) {
        block17: {
            block16: {
                if (buttonEvent.getID() != 3308) break block16;
                JRootPane jRootPane = this.getRootPane();
                if (jRootPane == null || jRootPane.getDefaultButton() == null) break block17;
                jRootPane.setDefaultButton(null);
                break block17;
            }
            for (int i = 0; i < this.getComponentCount(); ++i) {
                final Component component = this.getComponent(i);
                if (!buttonEvent.getButtonName().equals(component.getName())) continue;
                switch (buttonEvent.getID()) {
                    case 3301: {
                        component.setVisible(true);
                        if (component instanceof JButton && ((JButton)component).getAction() != null) {
                            ((JButton)component).getAction().setEnabled(true);
                        }
                        component.setEnabled(true);
                        break;
                    }
                    case 3302: {
                        component.setEnabled(false);
                        if (component instanceof JButton && ((JButton)component).getAction() != null) {
                            ((JButton)component).getAction().setEnabled(false);
                        }
                        component.setVisible(true);
                        break;
                    }
                    case 3299: {
                        component.setVisible(true);
                        break;
                    }
                    case 3300: {
                        component.setVisible(false);
                        JRootPane jRootPane = this.getRootPane();
                        if (jRootPane != null && jRootPane.getDefaultButton() == component) {
                            jRootPane.setDefaultButton(null);
                        }
                        if (jRootPane == null || jRootPane.getClientProperty("initialDefaultButton") != component) break;
                        jRootPane.putClientProperty("initialDefaultButton", null);
                        break;
                    }
                    case 3303: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setText(buttonEvent.getUserObject());
                        break;
                    }
                    case 3304: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setMnemonic(buttonEvent.getUserObject().charAt(0));
                        break;
                    }
                    case 3305: {
                        if (!(component instanceof AbstractButton)) break;
                        ((AbstractButton)component).setToolTipText(buttonEvent.getUserObject());
                        break;
                    }
                    case 3306: {
                        Runnable runnable = new Runnable(){

                            public void run() {
                                component.requestFocus();
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                        break;
                    }
                    case 3307: {
                        if (!(component instanceof JButton)) break;
                        if (this.getRootPane() != null) {
                            this.getRootPane().setDefaultButton((JButton)component);
                            break;
                        }
                        this._defaultButton = (JButton)component;
                        this._addNotify = true;
                    }
                }
                break;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this._addNotify) {
            JRootPane jRootPane = this.getRootPane();
            if (this._defaultButton != null && jRootPane != null) {
                jRootPane.setDefaultButton(this._defaultButton);
                this._addNotify = false;
                this._defaultButton = null;
            }
        }
    }

    public Component getButtonByName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!string.equals(component.getName())) continue;
            return component;
        }
        return null;
    }
}

