/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.BigDecimalConverter;
import com.jidesoft.converter.BooleanConverter;
import com.jidesoft.converter.ByteConverter;
import com.jidesoft.converter.CacheMap;
import com.jidesoft.converter.CalendarConverter;
import com.jidesoft.converter.ColorConverter;
import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.CurrencyConverter;
import com.jidesoft.converter.DateConverter;
import com.jidesoft.converter.DefaultArrayConverter;
import com.jidesoft.converter.DefaultObjectConverter;
import com.jidesoft.converter.DimensionConverter;
import com.jidesoft.converter.DoubleConverter;
import com.jidesoft.converter.FileConverter;
import com.jidesoft.converter.FloatConverter;
import com.jidesoft.converter.FontConverter;
import com.jidesoft.converter.FontNameConverter;
import com.jidesoft.converter.HexColorConverter;
import com.jidesoft.converter.InsetsConverter;
import com.jidesoft.converter.IntegerConverter;
import com.jidesoft.converter.LongConverter;
import com.jidesoft.converter.MonthConverter;
import com.jidesoft.converter.MonthNameConverter;
import com.jidesoft.converter.MultilineStringConverter;
import com.jidesoft.converter.NaturalNumberConverter;
import com.jidesoft.converter.NumberConverter;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.PasswordConverter;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.converter.PointConverter;
import com.jidesoft.converter.QuarterNameConverter;
import com.jidesoft.converter.RectangleConverter;
import com.jidesoft.converter.RegistrationListener;
import com.jidesoft.converter.RgbColorConverter;
import com.jidesoft.converter.ShortConverter;
import com.jidesoft.converter.StringArrayConverter;
import com.jidesoft.converter.YearNameConverter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectConverterManager {
    private static CacheMap<ObjectConverter, ConverterContext> _cache = new CacheMap(ConverterContext.DEFAULT_CONTEXT);
    private static ObjectConverter _defaultConverter = new DefaultObjectConverter();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;
    private static final /* synthetic */ Class class$java$math$BigDecimal;
    private static final /* synthetic */ Class array$Ljava$lang$Number;
    private static final /* synthetic */ Class array$Ljava$lang$Object;
    private static final /* synthetic */ Class array$Ljava$lang$Double;
    private static final /* synthetic */ Class array$Ljava$util$Calendar;
    private static final /* synthetic */ Class array$Ljava$lang$String;
    private static final /* synthetic */ Class class$java$awt$Font;
    private static final /* synthetic */ Class class$java$io$File;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$java$util$Calendar;
    private static final /* synthetic */ Class class$java$awt$Dimension;
    private static final /* synthetic */ Class array$Ljava$util$Date;
    private static final /* synthetic */ Class class$java$lang$Short;
    private static final /* synthetic */ Class class$java$lang$Float;
    private static final /* synthetic */ Class array$J;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$java$lang$Long;
    private static final /* synthetic */ Class array$I;
    private static final /* synthetic */ Class array$D;
    private static final /* synthetic */ Class class$java$lang$Double;
    private static final /* synthetic */ Class array$C;
    private static final /* synthetic */ Class array$F;
    private static final /* synthetic */ Class class$java$awt$Point;
    private static final /* synthetic */ Class class$java$lang$Number;
    private static final /* synthetic */ Class array$Ljava$lang$Float;
    private static final /* synthetic */ Class class$java$awt$Rectangle;
    private static final /* synthetic */ Class array$Ljava$lang$Short;
    private static final /* synthetic */ Class array$S;
    private static final /* synthetic */ Class array$Ljava$lang$Integer;
    private static final /* synthetic */ Class class$java$util$Date;
    private static final /* synthetic */ Class class$java$lang$Byte;
    private static final /* synthetic */ Class class$java$lang$Boolean;
    private static final /* synthetic */ Class class$java$awt$Insets;
    private static final /* synthetic */ Class class$java$awt$Color;
    private static final /* synthetic */ Class class$java$lang$Integer;
    private static final /* synthetic */ Class array$Ljava$lang$Long;

    public static void registerConverter(Class<?> clazz, ObjectConverter objectConverter, ConverterContext converterContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter class cannot be null");
        }
        if (converterContext == null) {
            converterContext = ConverterContext.DEFAULT_CONTEXT;
        }
        if (ObjectConverterManager.isAutoInit() && !_initing) {
            ObjectConverterManager.initDefaultConverter();
        }
        _cache.register(clazz, objectConverter, converterContext);
    }

    public static void registerConverter(Class<?> clazz, ObjectConverter objectConverter) {
        ObjectConverterManager.registerConverter(clazz, objectConverter, ConverterContext.DEFAULT_CONTEXT);
    }

    public static void unregisterConverter(Class<?> clazz, ConverterContext converterContext) {
        if (converterContext == null) {
            converterContext = ConverterContext.DEFAULT_CONTEXT;
        }
        if (ObjectConverterManager.isAutoInit() && !_initing) {
            ObjectConverterManager.initDefaultConverter();
        }
        _cache.unregister(clazz, converterContext);
    }

    public static void unregisterConverter(Class<?> clazz) {
        ObjectConverterManager.unregisterConverter(clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static void unregisterAllConverters() {
        _cache.clear();
    }

    public static ObjectConverter getConverter(Class<?> clazz, ConverterContext converterContext) {
        ObjectConverter objectConverter;
        if (ObjectConverterManager.isAutoInit()) {
            ObjectConverterManager.initDefaultConverter();
        }
        if (converterContext == null) {
            converterContext = ConverterContext.DEFAULT_CONTEXT;
        }
        if ((objectConverter = _cache.getRegisteredObject(clazz, converterContext)) != null) {
            return objectConverter;
        }
        return _defaultConverter;
    }

    public static ObjectConverter getConverter(Class<?> clazz) {
        return ObjectConverterManager.getConverter(clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static String toString(Object object) {
        if (object != null) {
            return ObjectConverterManager.toString(object, object.getClass(), ConverterContext.DEFAULT_CONTEXT);
        }
        return "";
    }

    public static String toString(Object object, Class<?> clazz) {
        return ObjectConverterManager.toString(object, clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static String toString(Object object, Class<?> clazz, ConverterContext converterContext) {
        ObjectConverter objectConverter = ObjectConverterManager.getConverter(clazz, converterContext);
        if (objectConverter != null && objectConverter.supportToString(object, converterContext)) {
            return objectConverter.toString(object, converterContext);
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static Object fromString(String string, Class<?> clazz) {
        return ObjectConverterManager.fromString(string, clazz, ConverterContext.DEFAULT_CONTEXT);
    }

    public static Object fromString(String string, Class<?> clazz, ConverterContext converterContext) {
        ObjectConverter objectConverter = ObjectConverterManager.getConverter(clazz, converterContext);
        if (objectConverter != null && objectConverter.supportFromString(string, converterContext)) {
            return objectConverter.fromString(string, converterContext);
        }
        return null;
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static ConverterContext[] getConverterContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (ConverterContext[])new ConverterContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultConverter() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Class<?> clazz3;
            Class<?> clazz4;
            Class<?> clazz5;
            Class<?> clazz6;
            Class<?> clazz7;
            Class<?> clazz8;
            Class<?> clazz9;
            Class<?> clazz10;
            Class<?> clazz11 = class$java$lang$String;
            if (clazz11 == null) {
                clazz11 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz11, new DefaultObjectConverter());
            Class<?> clazz12 = array$C;
            if (clazz12 == null) {
                clazz12 = array$C = new char[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz12, new PasswordConverter(), PasswordConverter.CONTEXT);
            DoubleConverter doubleConverter = new DoubleConverter();
            doubleConverter.setFractionDigits(2, 2);
            Class<?> clazz13 = class$java$lang$Number;
            if (clazz13 == null) {
                clazz13 = class$java$lang$Number = new Number[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz13, doubleConverter, NumberConverter.CONTEXT_FRACTION_NUMBER);
            IntegerConverter integerConverter = new IntegerConverter();
            Class<?> clazz14 = class$java$lang$Integer;
            if (clazz14 == null) {
                clazz14 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz14, integerConverter);
            ObjectConverterManager.registerConverter(Integer.TYPE, integerConverter);
            NaturalNumberConverter naturalNumberConverter = new NaturalNumberConverter();
            Class<?> clazz15 = class$java$lang$Integer;
            if (clazz15 == null) {
                clazz15 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz15, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, naturalNumberConverter, NaturalNumberConverter.CONTEXT);
            LongConverter longConverter = new LongConverter();
            Class<?> clazz16 = class$java$lang$Long;
            if (clazz16 == null) {
                clazz16 = class$java$lang$Long = new Long[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz16, longConverter);
            ObjectConverterManager.registerConverter(Long.TYPE, longConverter);
            DoubleConverter doubleConverter2 = new DoubleConverter();
            Class<?> clazz17 = class$java$lang$Double;
            if (clazz17 == null) {
                clazz17 = class$java$lang$Double = new Double[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz17, doubleConverter2);
            ObjectConverterManager.registerConverter(Double.TYPE, doubleConverter2);
            FloatConverter floatConverter = new FloatConverter();
            Class<?> clazz18 = class$java$lang$Float;
            if (clazz18 == null) {
                clazz18 = class$java$lang$Float = new Float[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz18, floatConverter);
            ObjectConverterManager.registerConverter(Float.TYPE, floatConverter);
            ShortConverter shortConverter = new ShortConverter();
            Class<?> clazz19 = class$java$lang$Short;
            if (clazz19 == null) {
                clazz19 = class$java$lang$Short = new Short[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz19, shortConverter);
            ObjectConverterManager.registerConverter(Short.TYPE, shortConverter);
            ByteConverter byteConverter = new ByteConverter();
            Class<?> clazz20 = class$java$lang$Byte;
            if (clazz20 == null) {
                clazz20 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz20, byteConverter);
            ObjectConverterManager.registerConverter(Byte.TYPE, byteConverter);
            Class<?> clazz21 = class$java$awt$Rectangle;
            if (clazz21 == null) {
                clazz21 = class$java$awt$Rectangle = new Rectangle[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz21, new RectangleConverter());
            Class<?> clazz22 = class$java$awt$Point;
            if (clazz22 == null) {
                clazz22 = class$java$awt$Point = new Point[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz22, new PointConverter());
            Class<?> clazz23 = class$java$awt$Insets;
            if (clazz23 == null) {
                clazz23 = class$java$awt$Insets = new Insets[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz23, new InsetsConverter());
            Class<?> clazz24 = class$java$awt$Dimension;
            if (clazz24 == null) {
                clazz24 = class$java$awt$Dimension = new Dimension[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz24, new DimensionConverter());
            BooleanConverter booleanConverter = new BooleanConverter();
            Class<?> clazz25 = class$java$lang$Boolean;
            if (clazz25 == null) {
                clazz25 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz25, booleanConverter);
            ObjectConverterManager.registerConverter(Boolean.TYPE, booleanConverter);
            Class<?> clazz26 = class$java$io$File;
            if (clazz26 == null) {
                clazz26 = class$java$io$File = new File[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz26, new FileConverter());
            Class<?> clazz27 = class$java$lang$String;
            if (clazz27 == null) {
                clazz27 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz27, new FontNameConverter(), FontNameConverter.CONTEXT);
            DateConverter dateConverter = new DateConverter();
            Class<?> clazz28 = class$java$util$Date;
            if (clazz28 == null) {
                clazz28 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz28, dateConverter);
            Class<?> clazz29 = class$java$util$Date;
            if (clazz29 == null) {
                clazz29 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz29, dateConverter, DateConverter.DATETIME_CONTEXT);
            Class<?> clazz30 = class$java$util$Date;
            if (clazz30 == null) {
                clazz30 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz30, dateConverter, DateConverter.TIME_CONTEXT);
            CalendarConverter calendarConverter = new CalendarConverter();
            Class<?> clazz31 = class$java$util$Calendar;
            if (clazz31 == null) {
                clazz31 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz31, calendarConverter);
            Class<?> clazz32 = class$java$util$Calendar;
            if (clazz32 == null) {
                clazz32 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz32, calendarConverter, DateConverter.DATETIME_CONTEXT);
            Class<?> clazz33 = class$java$util$Calendar;
            if (clazz33 == null) {
                clazz33 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz33, calendarConverter, DateConverter.TIME_CONTEXT);
            Class<?> clazz34 = class$java$util$Calendar;
            if (clazz34 == null) {
                clazz34 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz34, new MonthConverter(), MonthConverter.CONTEXT_MONTH);
            Class<?> clazz35 = class$java$awt$Color;
            if (clazz35 == null) {
                clazz35 = class$java$awt$Color = new Color[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz35, new RgbColorConverter());
            Class<?> clazz36 = class$java$awt$Color;
            if (clazz36 == null) {
                clazz36 = class$java$awt$Color = new Color[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz36, new HexColorConverter(), ColorConverter.CONTEXT_HEX);
            Class<?> clazz37 = class$java$awt$Color;
            if (clazz37 == null) {
                clazz37 = class$java$awt$Color = new Color[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz37, new RgbColorConverter(true), ColorConverter.CONTEXT_RGBA);
            Class<?> clazz38 = class$java$awt$Color;
            if (clazz38 == null) {
                clazz38 = class$java$awt$Color = new Color[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz38, new HexColorConverter(true), ColorConverter.CONTEXT_HEX_WITH_ALPHA);
            Class<?> clazz39 = array$Ljava$lang$String;
            if (clazz39 == null) {
                clazz39 = array$Ljava$lang$String = new String[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz39, new StringArrayConverter());
            QuarterNameConverter quarterNameConverter = new QuarterNameConverter();
            ObjectConverterManager.registerConverter(Integer.TYPE, quarterNameConverter, QuarterNameConverter.CONTEXT);
            Class<?> clazz40 = class$java$lang$Integer;
            if (clazz40 == null) {
                clazz40 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz40, quarterNameConverter, QuarterNameConverter.CONTEXT);
            Class<?> clazz41 = class$java$awt$Font;
            if (clazz41 == null) {
                clazz41 = class$java$awt$Font = new Font[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz41, new FontConverter());
            Class<?> clazz42 = class$java$lang$String;
            if (clazz42 == null) {
                clazz42 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz42, new MultilineStringConverter(), MultilineStringConverter.CONTEXT);
            CurrencyConverter currencyConverter = new CurrencyConverter();
            Class<?> clazz43 = class$java$lang$Float;
            if (clazz43 == null) {
                clazz43 = class$java$lang$Float = new Float[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz43, currencyConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            Class<?> clazz44 = class$java$lang$Double;
            if (clazz44 == null) {
                clazz44 = class$java$lang$Double = new Double[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz44, currencyConverter, CurrencyConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, currencyConverter, CurrencyConverter.CONTEXT);
            PercentConverter percentConverter = new PercentConverter();
            Class<?> clazz45 = class$java$lang$Float;
            if (clazz45 == null) {
                clazz45 = class$java$lang$Float = new Float[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz45, percentConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Float.TYPE, percentConverter, PercentConverter.CONTEXT);
            Class<?> clazz46 = class$java$lang$Double;
            if (clazz46 == null) {
                clazz46 = class$java$lang$Double = new Double[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz46, percentConverter, PercentConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Double.TYPE, percentConverter, PercentConverter.CONTEXT);
            MonthNameConverter monthNameConverter = new MonthNameConverter();
            Class<?> clazz47 = class$java$lang$Integer;
            if (clazz47 == null) {
                clazz47 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz47, monthNameConverter, MonthNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, monthNameConverter, MonthNameConverter.CONTEXT);
            YearNameConverter yearNameConverter = new YearNameConverter();
            Class<?> clazz48 = class$java$lang$Integer;
            if (clazz48 == null) {
                clazz48 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz48, yearNameConverter, YearNameConverter.CONTEXT);
            ObjectConverterManager.registerConverter(Integer.TYPE, yearNameConverter, YearNameConverter.CONTEXT);
            Class<?> clazz49 = array$I;
            if (clazz49 == null) {
                clazz49 = array$I = new int[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz49, new DefaultArrayConverter("; ", Integer.TYPE));
            Class<?> clazz50 = array$Ljava$lang$Object;
            if (clazz50 == null) {
                clazz50 = array$Ljava$lang$Object = new Object[0][].getClass().getComponentType();
            }
            if ((clazz10 = class$java$lang$Object) == null) {
                clazz10 = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz50, new DefaultArrayConverter("; ", clazz10));
            Class<?> clazz51 = array$Ljava$lang$String;
            if (clazz51 == null) {
                clazz51 = array$Ljava$lang$String = new String[0][].getClass().getComponentType();
            }
            if ((clazz9 = class$java$lang$String) == null) {
                clazz9 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz51, new DefaultArrayConverter("; ", clazz9));
            Class<?> clazz52 = array$Ljava$util$Date;
            if (clazz52 == null) {
                clazz52 = array$Ljava$util$Date = new Date[0][].getClass().getComponentType();
            }
            if ((clazz8 = class$java$util$Date) == null) {
                clazz8 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz52, new DefaultArrayConverter("; ", clazz8));
            Class<?> clazz53 = array$Ljava$util$Calendar;
            if (clazz53 == null) {
                clazz53 = array$Ljava$util$Calendar = new Calendar[0][].getClass().getComponentType();
            }
            if ((clazz7 = class$java$util$Calendar) == null) {
                clazz7 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz53, new DefaultArrayConverter("; ", clazz7));
            Class<?> clazz54 = array$Ljava$lang$Number;
            if (clazz54 == null) {
                clazz54 = array$Ljava$lang$Number = new Number[0][].getClass().getComponentType();
            }
            if ((clazz6 = class$java$lang$Number) == null) {
                clazz6 = class$java$lang$Number = new Number[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz54, new DefaultArrayConverter("; ", clazz6));
            Class<?> clazz55 = array$Ljava$lang$Integer;
            if (clazz55 == null) {
                clazz55 = array$Ljava$lang$Integer = new Integer[0][].getClass().getComponentType();
            }
            if ((clazz5 = class$java$lang$Integer) == null) {
                clazz5 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz55, new DefaultArrayConverter("; ", clazz5));
            Class<?> clazz56 = array$Ljava$lang$Float;
            if (clazz56 == null) {
                clazz56 = array$Ljava$lang$Float = new Float[0][].getClass().getComponentType();
            }
            if ((clazz4 = class$java$lang$Float) == null) {
                clazz4 = class$java$lang$Float = new Float[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz56, new DefaultArrayConverter("; ", clazz4));
            Class<?> clazz57 = array$Ljava$lang$Double;
            if (clazz57 == null) {
                clazz57 = array$Ljava$lang$Double = new Double[0][].getClass().getComponentType();
            }
            if ((clazz3 = class$java$lang$Double) == null) {
                clazz3 = class$java$lang$Double = new Double[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz57, new DefaultArrayConverter("; ", clazz3));
            Class<?> clazz58 = array$Ljava$lang$Long;
            if (clazz58 == null) {
                clazz58 = array$Ljava$lang$Long = new Long[0][].getClass().getComponentType();
            }
            if ((clazz2 = class$java$lang$Long) == null) {
                clazz2 = class$java$lang$Long = new Long[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz58, new DefaultArrayConverter("; ", clazz2));
            Class<?> clazz59 = array$Ljava$lang$Short;
            if (clazz59 == null) {
                clazz59 = array$Ljava$lang$Short = new Short[0][].getClass().getComponentType();
            }
            if ((clazz = class$java$lang$Short) == null) {
                clazz = class$java$lang$Short = new Short[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz59, new DefaultArrayConverter("; ", clazz));
            Class<?> clazz60 = array$I;
            if (clazz60 == null) {
                clazz60 = array$I = new int[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz60, new DefaultArrayConverter("; ", Integer.TYPE));
            Class<?> clazz61 = array$F;
            if (clazz61 == null) {
                clazz61 = array$F = new float[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz61, new DefaultArrayConverter("; ", Float.TYPE));
            Class<?> clazz62 = array$D;
            if (clazz62 == null) {
                clazz62 = array$D = new double[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz62, new DefaultArrayConverter("; ", Double.TYPE));
            Class<?> clazz63 = array$J;
            if (clazz63 == null) {
                clazz63 = array$J = new long[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz63, new DefaultArrayConverter("; ", Long.TYPE));
            Class<?> clazz64 = array$S;
            if (clazz64 == null) {
                clazz64 = array$S = new short[0][].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz64, new DefaultArrayConverter("; ", Short.TYPE));
            Class<?> clazz65 = class$java$math$BigDecimal;
            if (clazz65 == null) {
                clazz65 = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
            }
            ObjectConverterManager.registerConverter(clazz65, new BigDecimalConverter());
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        ObjectConverterManager.resetInit();
        _cache.clear();
    }
}

