/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.AlphanumComparator;
import com.jidesoft.comparator.BooleanComparator;
import com.jidesoft.comparator.CalendarComparator;
import com.jidesoft.comparator.CharSequenceComparator;
import com.jidesoft.comparator.ComparatorContext;
import com.jidesoft.comparator.DateComparator;
import com.jidesoft.comparator.DefaultComparator;
import com.jidesoft.comparator.FastComparableComparator;
import com.jidesoft.comparator.NumberComparator;
import com.jidesoft.converter.CacheMap;
import com.jidesoft.converter.RegistrationListener;
import java.text.Collator;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectComparatorManager {
    private static final CacheMap<Comparator<?>, ComparatorContext> _cache = new CacheMap(new ComparatorContext(""));
    private static final Comparator<Object> _defaultComparator = new DefaultComparator();
    private static boolean _inited = false;
    private static boolean _initing = false;
    private static boolean _autoInit = true;
    private static final /* synthetic */ Class class$java$lang$Number;
    private static final /* synthetic */ Class class$java$lang$CharSequence;
    private static final /* synthetic */ Class class$java$lang$Object;
    private static final /* synthetic */ Class class$java$util$Calendar;
    private static final /* synthetic */ Class class$java$lang$Boolean;
    private static final /* synthetic */ Class class$java$lang$Comparable;
    private static final /* synthetic */ Class class$java$lang$String;
    private static final /* synthetic */ Class class$java$util$Date;

    public static void registerComparator(Class<?> clazz, Comparator comparator) {
        ObjectComparatorManager.registerComparator(clazz, comparator, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void registerComparator(Class<?> clazz, Comparator comparator, ComparatorContext comparatorContext) {
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter clazz cannot be null");
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if (ObjectComparatorManager.isAutoInit() && !_initing) {
            ObjectComparatorManager.initDefaultComparator();
        }
        _cache.register(clazz, comparator, comparatorContext);
    }

    public static void unregisterComparator(Class<?> clazz) {
        _cache.unregister(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static void unregisterComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        _cache.unregister(clazz, comparatorContext);
    }

    public static void unregisterAllComparators() {
        _cache.clear();
    }

    public static Comparator getComparator(Class<?> clazz) {
        return ObjectComparatorManager.getComparator(clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static Comparator getComparator(Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator<?> comparator;
        if (ObjectComparatorManager.isAutoInit()) {
            ObjectComparatorManager.initDefaultComparator();
        }
        if (comparatorContext == null) {
            comparatorContext = ComparatorContext.DEFAULT_CONTEXT;
        }
        if ((comparator = _cache.getRegisteredObject(clazz, comparatorContext)) != null) {
            return comparator;
        }
        return _defaultComparator;
    }

    public static int compare(Object object, Object object2) {
        return ObjectComparatorManager.compare(object, object2, ComparatorContext.DEFAULT_CONTEXT);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int compare(Object object, Object object2, ComparatorContext comparatorContext) {
        Class clazz;
        Class clazz2;
        Class<?> clazz3;
        if (object == null && object2 == null) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        Class clazz4 = object.getClass();
        if (clazz4 == (clazz3 = object2.getClass())) {
            clazz2 = clazz4;
            return ObjectComparatorManager.compare(object, object2, clazz2, comparatorContext);
        }
        if (clazz4.isAssignableFrom(clazz3)) {
            clazz2 = clazz4;
            return ObjectComparatorManager.compare(object, object2, clazz2, comparatorContext);
        }
        if (clazz3.isAssignableFrom(clazz4)) {
            clazz2 = clazz3;
            return ObjectComparatorManager.compare(object, object2, clazz2, comparatorContext);
        }
        Class<?> clazz5 = class$java$lang$Comparable;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Comparable = new Comparable[0].getClass().getComponentType();
        }
        if (clazz4.isAssignableFrom(clazz5)) {
            Class<?> clazz6 = class$java$lang$Comparable;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Comparable = new Comparable[0].getClass().getComponentType();
            }
            if (clazz3.isAssignableFrom(clazz6)) {
                Class clazz7 = class$java$lang$Comparable;
                if (clazz7 == null) {
                    clazz7 = class$java$lang$Comparable = new Comparable[0].getClass().getComponentType();
                }
                clazz2 = clazz7;
                return ObjectComparatorManager.compare(object, object2, clazz2, comparatorContext);
            }
        }
        if ((clazz = class$java$lang$Object) == null) {
            clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
        }
        clazz2 = clazz;
        return ObjectComparatorManager.compare(object, object2, clazz2, comparatorContext);
    }

    public static int compare(Object object, Object object2, Class<?> clazz) {
        return ObjectComparatorManager.compare(object, object2, clazz, ComparatorContext.DEFAULT_CONTEXT);
    }

    public static int compare(Object object, Object object2, Class<?> clazz, ComparatorContext comparatorContext) {
        Comparator comparator = ObjectComparatorManager.getComparator(clazz, comparatorContext);
        if (comparator != null) {
            try {
                return comparator.compare(object, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        return object.toString().compareTo(object2.toString());
    }

    public static boolean isAutoInit() {
        return _autoInit;
    }

    public static void setAutoInit(boolean bl) {
        _autoInit = bl;
    }

    public static void addRegistrationListener(RegistrationListener registrationListener) {
        _cache.addRegistrationListener(registrationListener);
    }

    public static void removeRegistrationListener(RegistrationListener registrationListener) {
        _cache.removeRegistrationListener(registrationListener);
    }

    public static RegistrationListener[] getRegistrationListeners() {
        return _cache.getRegistrationListeners();
    }

    public static ComparatorContext[] getComparatorContexts(Class<?> clazz) {
        return _cache.getKeys(clazz, (ComparatorContext[])new ComparatorContext[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initDefaultComparator() {
        if (_inited) {
            return;
        }
        _initing = true;
        try {
            Class<?> clazz = class$java$lang$Object;
            if (clazz == null) {
                clazz = class$java$lang$Object = new Object[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz, new DefaultComparator());
            Class<?> clazz2 = class$java$lang$Boolean;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz2, new BooleanComparator());
            Class<?> clazz3 = class$java$util$Calendar;
            if (clazz3 == null) {
                clazz3 = class$java$util$Calendar = new Calendar[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz3, new CalendarComparator());
            Class<?> clazz4 = class$java$util$Date;
            if (clazz4 == null) {
                clazz4 = class$java$util$Date = new Date[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz4, new DateComparator());
            NumberComparator numberComparator = new NumberComparator();
            Class<?> clazz5 = class$java$lang$Number;
            if (clazz5 == null) {
                clazz5 = class$java$lang$Number = new Number[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz5, numberComparator);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator);
            NumberComparator numberComparator2 = new NumberComparator();
            numberComparator2.setAbsolute(true);
            Class<?> clazz6 = class$java$lang$Number;
            if (clazz6 == null) {
                clazz6 = class$java$lang$Number = new Number[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz6, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Double.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Float.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Long.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Integer.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Short.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            ObjectComparatorManager.registerComparator(Byte.TYPE, numberComparator2, NumberComparator.CONTEXT_ABSOLUTE);
            Class<?> clazz7 = class$java$lang$Comparable;
            if (clazz7 == null) {
                clazz7 = class$java$lang$Comparable = new Comparable[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz7, new FastComparableComparator());
            Class<?> clazz8 = class$java$lang$String;
            if (clazz8 == null) {
                clazz8 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz8, Collator.getInstance());
            Collator collator = Collator.getInstance();
            collator.setStrength(0);
            Class<?> clazz9 = class$java$lang$String;
            if (clazz9 == null) {
                clazz9 = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz9, collator, new ComparatorContext("Ignorecase"));
            Class<?> clazz10 = class$java$lang$CharSequence;
            if (clazz10 == null) {
                clazz10 = class$java$lang$CharSequence = new CharSequence[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz10, new CharSequenceComparator(), CharSequenceComparator.CONTEXT);
            Class<?> clazz11 = class$java$lang$CharSequence;
            if (clazz11 == null) {
                clazz11 = class$java$lang$CharSequence = new CharSequence[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz11, new CharSequenceComparator(false), CharSequenceComparator.CONTEXT_IGNORE_CASE);
            Class<?> clazz12 = class$java$lang$CharSequence;
            if (clazz12 == null) {
                clazz12 = class$java$lang$CharSequence = new CharSequence[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz12, new AlphanumComparator(), AlphanumComparator.CONTEXT);
            Class<?> clazz13 = class$java$lang$CharSequence;
            if (clazz13 == null) {
                clazz13 = class$java$lang$CharSequence = new CharSequence[0].getClass().getComponentType();
            }
            ObjectComparatorManager.registerComparator(clazz13, new AlphanumComparator(false), AlphanumComparator.CONTEXT_IGNORE_CASE);
        }
        finally {
            _initing = false;
            _inited = true;
        }
    }

    public static void resetInit() {
        _inited = false;
    }

    public static void clear() {
        ObjectComparatorManager.resetInit();
        _cache.clear();
    }
}

