/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.cipher;

import com.maverick.crypto.engines.CipherEngine;
import com.maverick.ssh.cipher.SshCipher;
import java.io.IOException;

public class CbcBlockCipher
extends SshCipher {
    private CipherEngine M;
    private int Q;
    private byte[] K = null;
    private byte[] P = null;
    private byte[] N = null;
    private byte[] L = null;
    private int O;

    public CbcBlockCipher(int n, CipherEngine cipherEngine, String string) {
        super(string);
        this.L = new byte[n / 8];
        this.M = cipherEngine;
        this.O = cipherEngine.getBlockSize();
    }

    public void init(int n, byte[] byArray, byte[] byArray2) {
        this.Q = n;
        System.arraycopy(byArray2, 0, this.L, 0, this.L.length);
        this.M.init(n == 0, this.L);
        this.K = new byte[this.O];
        System.arraycopy(byArray, 0, this.K, 0, this.K.length);
        this.P = new byte[this.O];
        System.arraycopy(this.K, 0, this.P, 0, this.P.length);
        this.N = new byte[this.O];
    }

    public int getBlockSize() {
        return this.O;
    }

    public void transform(byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws IOException {
        if (this.P == null) {
            throw new IOException("Cipher not initialized!");
        }
        if (n3 % this.O != 0) {
            throw new IOException("Input data length MUST be a multiple of the cipher block size!");
        }
        block4: for (int i = 0; i < n3; i += this.O) {
            switch (this.Q) {
                case 0: {
                    for (int j = 0; j < this.O; ++j) {
                        this.N[j] = (byte)(byArray[n + i + j] ^ this.P[j]);
                    }
                    this.M.processBlock(this.N, 0, this.P, 0);
                    System.arraycopy(this.P, 0, byArray2, n2 + i, this.O);
                    continue block4;
                }
                case 1: {
                    byte[] byArray3 = new byte[this.O];
                    System.arraycopy(byArray, n + i, byArray3, 0, this.O);
                    this.M.processBlock(byArray, n2 + i, this.N, 0);
                    for (int j = 0; j < this.O; ++j) {
                        byArray2[n2 + j + i] = (byte)(this.N[j] ^ this.P[j]);
                    }
                    System.arraycopy(byArray3, 0, this.P, 0, this.O);
                    byArray3 = null;
                    continue block4;
                }
                default: {
                    throw new IOException("Invalid cipher mode!");
                }
            }
        }
    }
}

