/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh;

import com.maverick.ssh.ChannelAdapter;
import com.maverick.ssh.ChannelOpenException;
import com.maverick.ssh.PseudoTerminalModes;
import com.maverick.ssh.SshChannel;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Properties;

public class ShellEnvironment {
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_AIX = 4;
    public static final int OS_DARWIN = 5;
    public static final int OS_FREEBSD = 6;
    public static final int OS_OPENBSD = 7;
    public static final int OS_NETBSD = 8;
    public static final int OS_UNKNOWN = 99;
    Properties D = new Properties();
    int B = 99;
    String A;
    SshClient C;

    ShellEnvironment(SshClient sshClient) throws SshException, ChannelOpenException {
        SshSession sshSession = null;
        this.C = sshClient;
        try {
            block28: {
                try {
                    PseudoTerminalModes pseudoTerminalModes = new PseudoTerminalModes(this.C);
                    pseudoTerminalModes.setTerminalMode(53, false);
                    sshSession = this.A();
                    boolean bl = false;
                    if (sshSession.executeCommand("set")) {
                        bl = this.A(sshSession.getInputStream());
                    }
                    sshSession.close();
                    if (!bl && (sshSession = this.A()).executeCommand("cmd.exe /C set")) {
                        bl = this.A(sshSession.getInputStream());
                    }
                    sshSession.close();
                    if (!bl) {
                        throw new SshException("Unable to determine the remote shell environment", 15);
                    }
                    if (((Hashtable)this.D).containsKey("OS") && this.D.getProperty("OS").startsWith("Windows")) {
                        this.B = 1;
                        this.A = "Windows";
                        sshSession = this.A();
                        if (sshSession.executeCommand("cmd.exe /C ver")) {
                            String string;
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sshSession.getInputStream()));
                            while ((string = bufferedReader.readLine()) != null) {
                                if (string.indexOf("Windows") <= -1) continue;
                                this.A = string;
                                break;
                            }
                        }
                        sshSession.close();
                        break block28;
                    }
                    sshSession = this.A();
                    if (sshSession.executeCommand("uname")) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sshSession.getInputStream()));
                        this.A = bufferedReader.readLine();
                        if (this.A.startsWith("Sun")) {
                            this.B = 3;
                            this.A = "Solaris";
                        } else if (this.A.startsWith("AIX")) {
                            this.B = 4;
                            this.A = "AIX";
                        } else if (this.A.startsWith("Darwin")) {
                            this.B = 5;
                            this.A = "Darwin";
                        } else if (this.A.startsWith("FreeBSD")) {
                            this.B = 6;
                            this.A = "FreeBSD";
                        } else if (this.A.startsWith("OpenBSD")) {
                            this.B = 7;
                            this.A = "OpenBSD";
                        } else if (this.A.startsWith("NetBSD")) {
                            this.B = 8;
                            this.A = "NetBSD";
                        } else if (this.A.startsWith("Linux")) {
                            this.B = 2;
                            this.A = "Linux";
                        } else {
                            this.B = 99;
                            this.A = this.A;
                        }
                    } else {
                        this.B = 99;
                        this.A = "Unknown";
                    }
                    sshSession.close();
                    if (this.B == 99 || !((Hashtable)this.D).containsKey("OSTYPE")) break block28;
                    this.A = this.A + " [" + this.D.getProperty("OSTYPE") + "]";
                }
                catch (IOException iOException) {
                    throw new SshException("Error whilst reading remote shell environment", (Throwable)iOException);
                }
            }
            Object var8_9 = null;
            if (sshSession != null && !sshSession.isClosed()) {
                sshSession.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (sshSession != null && !sshSession.isClosed()) {
                sshSession.close();
            }
            throw throwable;
        }
    }

    private SshSession A() throws SshException, ChannelOpenException {
        this.C = this.C.duplicate();
        SshSession sshSession = this.C.openSessionChannel();
        PseudoTerminalModes pseudoTerminalModes = new PseudoTerminalModes(this.C);
        pseudoTerminalModes.setTerminalMode(53, false);
        sshSession.requestPseudoTerminal("vt100", 80, 24, 0, 0, pseudoTerminalModes);
        sshSession.addChannelEventListener(new ChannelAdapter(){

            public void channelClosed(SshChannel sshChannel) {
                ShellEnvironment.this.C.disconnect();
            }
        });
        return sshSession;
    }

    private boolean A(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n <= -1) continue;
            ((Hashtable)this.D).put(string.substring(0, n), string.substring(n + 1));
            bl = true;
        }
        inputStream.close();
        bufferedReader.close();
        return bl;
    }

    public int getOSType() {
        return this.B;
    }

    public String getOperatingSystem() {
        return this.A;
    }

    public String getEnvironmentVariable(String string) {
        return this.D.getProperty(string);
    }

    public boolean hasEnvironmentVariable(String string) {
        return ((Hashtable)this.D).containsKey(string);
    }

    public String getEOL() {
        switch (this.B) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return "\r";
            }
        }
        return "\r\n";
    }
}

