/*
 * Decompiled with CFR 0.152.
 */
package joeshmoe.mpeg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import joeshmoe.mpeg.ID3Tagger;
import joeshmoe.mpeg.MPEGInfo;
import joeshmoe.mpeg.MPEGProbeException;
import joeshmoe.mpeg.ProbedMPEGInfo;

public class MPEGProber {
    private static final int[] bitRateV1L1 = new int[]{-1, 32, 64, 96, 128, 160, 192, 224, 256, 266, 320, 352, 384, 416, 448, -1};
    private static final int[] bitRateV1L2 = new int[]{-1, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, -1};
    private static final int[] bitRateV1L3 = new int[]{-1, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, -1};
    private static final int[] bitRateV2L1 = new int[]{-1, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, -1};
    private static final int[] bitRateV2L2 = new int[]{-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1};
    private static final int[] bitRateV2L3 = new int[]{-1, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, -1};
    private static final int[][][] bitRates = new int[][][]{{new int[0], bitRateV2L1, bitRateV2L2, bitRateV2L3}, {new int[0], bitRateV1L1, bitRateV1L2, bitRateV1L3}};
    private static final int[][] sampleRates = new int[][]{{22050, 24000, 16000}, {44100, 48000, 32000}};
    private static final int[] bs = new int[]{-1, 384, 1152, 1152};

    public static MPEGInfo probeFile(File file) throws FileNotFoundException, IOException, MPEGProbeException {
        ProbedMPEGInfo probedMPEGInfo;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            int n;
            int n2 = 0;
            byte[] byArray = new byte[4];
            if (fileInputStream.read(byArray) < 4) {
                throw new MPEGProbeException("Not a valid MPEG audio file: too short");
            }
            ProbedMPEGInfo probedMPEGInfo2 = new ProbedMPEGInfo();
            String string = new String(byArray, 0, 3).toLowerCase();
            n2 += 4;
            if (string.equals("id3")) {
                byte[] byArray2 = new byte[6];
                if (fileInputStream.read(byArray2) < 6) {
                    throw new MPEGProbeException("Found invalid ID3v2 header.  File ends unexpectedly.");
                }
                n2 += 6;
                n = byArray2[2] * 0x200000 + byArray2[3] * 16384 + byArray2[4] * 128 + byArray2[5];
                fileInputStream.skip(n);
                n2 += n;
                n2 += 4;
                if (fileInputStream.read(byArray) < 4) {
                    throw new MPEGProbeException("Not a valid MPEG audio file: too short");
                }
            }
            int n3 = MPEGProber.extractInt(byArray, 0, 4);
            while (!MPEGProber.isMPEGHeader(n3)) {
                n = fileInputStream.read();
                ++n2;
                if (n == -1) {
                    throw new MPEGProbeException("Not a valid MPEG audio file: cannot find first frame");
                }
                n3 <<= 8;
                n3 |= n;
            }
            n = n3 >> 19 & 1;
            probedMPEGInfo2.setLayer(4 - (n3 >> 17) & 3);
            if (probedMPEGInfo2.getLayer() == 4) {
                throw new MPEGProbeException("Invalid layer specified in MPEG file");
            }
            probedMPEGInfo2.setCRCProtected((n3 >> 16 & 1) != 1);
            int n4 = n3 >> 12 & 0xF;
            probedMPEGInfo2.setSamplingRate(sampleRates[n][n3 >> 10 & 3]);
            probedMPEGInfo2.setChannelMode((n3 >> 6 & 3) + 1);
            int n5 = n3 >> 4 & 3;
            if (probedMPEGInfo2.getChannelMode() == 2) {
                if (probedMPEGInfo2.getLayer() == 3) {
                    probedMPEGInfo2.setIntensityBands(-1);
                    if ((n5 & 1) == 1) {
                        probedMPEGInfo2.setIntensityStereo(true);
                    }
                    if ((n5 & 2) == 2) {
                        probedMPEGInfo2.setMSStereo(true);
                    }
                } else {
                    probedMPEGInfo2.setIntensityBands(n5 + 1);
                }
            } else {
                probedMPEGInfo2.setIntensityBands(-1);
            }
            probedMPEGInfo2.setCopyright((n3 >> 3 & 1) == 1);
            probedMPEGInfo2.setOriginal((n3 >> 2 & 1) == 1);
            int n6 = 0;
            if (n == 1) {
                probedMPEGInfo2.setVersion(1);
                n6 = probedMPEGInfo2.getChannelMode() != 4 ? 32 : 17;
            } else if (n == 2) {
                probedMPEGInfo2.setVersion(2);
                n6 = probedMPEGInfo2.getChannelMode() != 4 ? 17 : 9;
            }
            probedMPEGInfo2.setID3(ID3Tagger.readTag(file));
            if (fileInputStream.skip(n6) != (long)n6) {
                throw new MPEGProbeException("Could not seek in MPEG file");
            }
            fileInputStream.read(byArray);
            String string2 = new String(byArray);
            if (string2.equals("Xing") || string2.equals("Lame")) {
                probedMPEGInfo2.setVBR(true);
                fileInputStream.read(byArray);
                int n7 = MPEGProber.extractInt(byArray, 0, 4);
                int n8 = 0;
                if ((n7 & 1) == 1) {
                    fileInputStream.read(byArray);
                    n8 = MPEGProber.extractInt(byArray, 0, 4);
                }
                if ((n7 & 2) == 2) {
                    fileInputStream.read(byArray);
                    probedMPEGInfo2.setFileSize(MPEGProber.extractInt(byArray, 0, 4));
                }
                probedMPEGInfo2.setLength((long)n8 * 1000L * (long)bs[probedMPEGInfo2.getLayer()] / (long)probedMPEGInfo2.getSamplingRate());
                probedMPEGInfo2.setBitrate((int)(probedMPEGInfo2.getFileSize() * 8L / probedMPEGInfo2.getLength()));
            } else {
                probedMPEGInfo2.setFileSize(file.length() - (long)n2 - 4L - (long)(probedMPEGInfo2.getID3() != null ? 128 : 0));
                probedMPEGInfo2.setBitrate(bitRates[probedMPEGInfo2.getVersion()][probedMPEGInfo2.getLayer()][n4]);
                if (probedMPEGInfo2.getBitrate() == -1) {
                    throw new MPEGProbeException("Illegal bitrate specified");
                }
                probedMPEGInfo2.setLength(probedMPEGInfo2.getFileSize() / (long)(probedMPEGInfo2.getBitrate() / 8));
            }
            probedMPEGInfo = probedMPEGInfo2;
            Object var3_16 = null;
        }
        catch (Throwable throwable) {
            Object var3_17 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        return probedMPEGInfo;
    }

    private static int extractInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (true) {
            n3 += byArray[n + n4] & 0xFF;
            if (++n4 == n2) break;
            n3 <<= 8;
        }
        return n3;
    }

    private static boolean isMPEGHeader(int n) {
        if ((n & 0xFFE00000) != -2097152) {
            return false;
        }
        if ((n >> 17 & 3) == 0) {
            return false;
        }
        if ((n >> 12 & 0xF) == 15) {
            return false;
        }
        if ((n >> 10 & 3) == 3) {
            return false;
        }
        return (n >> 19 & 1) != 1 || (n >> 17 & 3) != 3 || (n >> 19 & 1) != 1;
    }
}

