/*
 * Decompiled with CFR 0.152.
 */
package joeshmoe.mpeg;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import joeshmoe.mpeg.ID3Tag;

public class ID3Tagger {
    public static ID3Tag readTag(File file) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        if (randomAccessFile.length() < 128L) {
            randomAccessFile.close();
            return null;
        }
        randomAccessFile.seek(randomAccessFile.length() - 128L);
        byte[] byArray = new byte[128];
        randomAccessFile.read(byArray);
        ID3Tag iD3Tag = new ID3Tag();
        if ((char)byArray[0] == 'T' && (char)byArray[1] == 'A' && (char)byArray[2] == 'G') {
            iD3Tag.setSong(new String(byArray, 3, 30, "ISO8859_1").trim());
            iD3Tag.setArtist(new String(byArray, 33, 30, "ISO8859_1").trim());
            iD3Tag.setAlbum(new String(byArray, 63, 30, "ISO8859_1").trim());
            iD3Tag.setYear(new String(byArray, 93, 4, "ISO8859_1").trim());
            if (byArray[125] == 0) {
                iD3Tag.setTrack(byArray[126]);
                iD3Tag.setComment(new String(byArray, 97, 28, "ISO8859_1").trim());
            } else {
                iD3Tag.setTrack(0);
                iD3Tag.setComment(new String(byArray, 97, 30, "ISO8859_1").trim());
            }
        } else {
            randomAccessFile.close();
            return null;
        }
        iD3Tag.setGenreID(byArray[127]);
        randomAccessFile.close();
        return iD3Tag;
    }

    public static boolean writeTag(File file, ID3Tag iD3Tag) throws IOException, FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName());
        }
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        if (ID3Tagger.readTag(file) == null) {
            randomAccessFile.seek(randomAccessFile.length());
        } else {
            randomAccessFile.seek(randomAccessFile.length() - 128L);
        }
        randomAccessFile.writeBytes("TAG");
        StringBuffer stringBuffer = iD3Tag.getSong() != null ? new StringBuffer(iD3Tag.getSong()) : new StringBuffer();
        stringBuffer.setLength(30);
        randomAccessFile.writeBytes(stringBuffer.toString());
        StringBuffer stringBuffer2 = iD3Tag.getArtist() != null ? new StringBuffer(iD3Tag.getArtist()) : new StringBuffer();
        stringBuffer2.setLength(30);
        randomAccessFile.writeBytes(stringBuffer2.toString());
        StringBuffer stringBuffer3 = iD3Tag.getAlbum() != null ? new StringBuffer(iD3Tag.getAlbum()) : new StringBuffer();
        stringBuffer3.setLength(30);
        randomAccessFile.writeBytes(stringBuffer3.toString());
        StringBuffer stringBuffer4 = iD3Tag.getYear() != null ? new StringBuffer(iD3Tag.getYear()) : new StringBuffer();
        stringBuffer4.setLength(4);
        randomAccessFile.writeBytes(stringBuffer4.toString());
        StringBuffer stringBuffer5 = iD3Tag.getComment() != null ? new StringBuffer(iD3Tag.getComment()) : new StringBuffer();
        if (iD3Tag.getTrack() > 0) {
            stringBuffer5.setLength(28);
        } else {
            stringBuffer5.setLength(30);
        }
        randomAccessFile.writeBytes(stringBuffer5.toString());
        if (iD3Tag.getTrack() > 0) {
            randomAccessFile.writeByte(0);
            randomAccessFile.writeByte(iD3Tag.getTrack());
        }
        randomAccessFile.writeByte(iD3Tag.getGenreID());
        randomAccessFile.close();
        return true;
    }
}

