/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class PanelWizardDemo
extends JPanel {
    public static final int USE_FILENAME = 0;
    public static final int USE_TRACKNAME = 1;
    public static final int USE_TRACKNAME_ARTIST = 2;
    public static final int USE_ARTIST_TRACKNAME = 3;
    JLabel dirOne;
    JLabel dirTwo;
    JLabel spacer;
    JLabel[] fileLabels;
    String[] fileLabelStrings = new String[]{"First", "Second", "Third", "Fourth", "Fifth", "Sixth"};
    String[] dirLabelStrings;
    boolean mp3Size = false;
    String mp3SizePrefix = "[";
    String mp3SizeSuffix = "]";
    boolean dirSize = false;
    String dirSizePrefix = "[";
    String dirSizeSuffix = "]";
    String dirPrefix = "";
    boolean capitalizeDirs = false;
    boolean indent = false;
    boolean useFilename = false;
    boolean useTrackname = false;
    boolean useTracknameArtist = true;
    boolean useArtistTrackname = false;
    boolean removeTrackNumbers = true;
    int displayType = 3;
    String id3Separator = "-";
    boolean addNumbersByFolder = false;
    boolean addNumbersByCD = false;

    public PanelWizardDemo() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("Preview"));
        this.setBackground(Color.white);
        this.fileLabels = new JLabel[6];
        int n = 0;
        while (n < 6) {
            this.fileLabels[n] = new JLabel(this.fileLabelStrings[n] + " Filename");
            ++n;
        }
        this.dirOne = new JLabel("First Dir");
        this.add(this.dirOne);
        this.add(this.fileLabels[0]);
        this.add(this.fileLabels[1]);
        this.add(this.fileLabels[2]);
        this.spacer = new JLabel(" ");
        this.add(this.spacer);
        this.dirTwo = new JLabel("Second Dir");
        this.add(this.dirTwo);
        this.add(this.fileLabels[3]);
        this.add(this.fileLabels[4]);
        this.add(this.fileLabels[5]);
        this.updateDisplay();
    }

    public void updateDisplay() {
        int n;
        int n2 = 0;
        while (n2 < 6) {
            if (this.displayType == 0) {
                this.fileLabels[n2].setText(this.fileLabelStrings[n2] + "_Filename");
            } else if (this.displayType == 1) {
                this.fileLabels[n2].setText(this.fileLabelStrings[n2] + "_Trackname");
            } else if (this.displayType == 2) {
                if (n2 < 3) {
                    this.fileLabels[n2].setText(this.fileLabelStrings[n2] + "_Trackname" + this.id3Separator + "First_Artist");
                } else {
                    this.fileLabels[n2].setText(this.fileLabelStrings[n2] + "_Trackname" + this.id3Separator + "Second_Artist");
                }
            } else if (this.displayType == 3) {
                if (n2 < 3) {
                    this.fileLabels[n2].setText("First_Artist" + this.id3Separator + this.fileLabelStrings[n2] + "_Trackname");
                } else {
                    this.fileLabels[n2].setText("Second_Artist" + this.id3Separator + this.fileLabelStrings[n2] + "_Trackname");
                }
            }
            ++n2;
        }
        this.dirOne.setText("First Dir");
        this.dirTwo.setText("Second Dir");
        if (!this.dirPrefix.equals("")) {
            this.dirOne.setText(this.dirPrefix + this.dirOne.getText());
            this.dirTwo.setText(this.dirPrefix + this.dirTwo.getText());
        }
        if (this.mp3Size) {
            n = 0;
            while (n < 6) {
                this.fileLabels[n].setText(this.fileLabels[n].getText() + " " + this.mp3SizePrefix + (n + 2) + "." + (9 - n) + "M" + this.mp3SizeSuffix);
                ++n;
            }
        }
        if (this.dirSize) {
            this.dirOne.setText(this.dirOne.getText() + " " + this.dirSizePrefix + "3.8M" + this.dirSizeSuffix);
            this.dirTwo.setText(this.dirTwo.getText() + " " + this.dirSizePrefix + "3.8M" + this.dirSizeSuffix);
        }
        if (this.capitalizeDirs) {
            this.dirOne.setText(this.dirOne.getText().toUpperCase());
            this.dirTwo.setText(this.dirTwo.getText().toUpperCase());
        }
        if (this.addNumbersByFolder) {
            n = 0;
            while (n < 6) {
                if (n < 3) {
                    this.fileLabels[n].setText(n + 1 + " " + this.fileLabels[n].getText());
                } else {
                    this.fileLabels[n].setText(n - 2 + " " + this.fileLabels[n].getText());
                }
                ++n;
            }
        }
        if (this.indent) {
            n = 0;
            while (n < 6) {
                this.fileLabels[n].setText("  " + this.fileLabels[n].getText());
                ++n;
            }
        }
    }

    public void setUseFilename() {
        this.displayType = 0;
        this.updateDisplay();
    }

    public void setUseTrackname() {
        this.displayType = 1;
        this.updateDisplay();
    }

    public void setUseTracknameArtist() {
        this.displayType = 2;
        this.updateDisplay();
    }

    public void setUseArtistTrackname() {
        this.displayType = 3;
        this.updateDisplay();
    }

    public void setMp3Size(boolean bl) {
        this.mp3Size = bl;
        this.updateDisplay();
    }

    public void setMp3SizePrefix(String string) {
        this.mp3SizePrefix = string;
        if (this.mp3Size) {
            this.updateDisplay();
        }
    }

    public void setMp3SizeSuffix(String string) {
        this.mp3SizeSuffix = string;
        if (this.mp3Size) {
            this.updateDisplay();
        }
    }

    public void setDirSize(boolean bl) {
        this.dirSize = bl;
        this.updateDisplay();
    }

    public void setDirSizePrefix(String string) {
        this.dirSizePrefix = string;
        if (this.dirSize) {
            this.updateDisplay();
        }
    }

    public void setDirSizeSuffix(String string) {
        this.dirSizeSuffix = string;
        if (this.dirSize) {
            this.updateDisplay();
        }
    }

    public void setCapitalizeDirs(boolean bl) {
        this.capitalizeDirs = bl;
        this.updateDisplay();
    }

    public void setIndent(boolean bl) {
        this.indent = bl;
        this.updateDisplay();
    }

    public void setDirPrefix(String string) {
        this.dirPrefix = string;
        if (!this.dirPrefix.equals("")) {
            this.updateDisplay();
        }
    }

    public void setAddNumbersByFolder(boolean bl) {
        this.addNumbersByFolder = bl;
        this.updateDisplay();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        PanelWizardDemo panelWizardDemo = new PanelWizardDemo();
        JFrame jFrame = new JFrame("TESTING");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)panelWizardDemo, "Center");
        jFrame.pack();
        jFrame.show();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        panelWizardDemo.setMp3Size(true);
        panelWizardDemo.setMp3SizePrefix("[");
        panelWizardDemo.setMp3SizeSuffix("]");
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        panelWizardDemo.setDirSize(true);
        panelWizardDemo.setDirSizePrefix("(");
        panelWizardDemo.setDirSizeSuffix(")");
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        panelWizardDemo.setCapitalizeDirs(true);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        panelWizardDemo.setIndent(true);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        panelWizardDemo.setAddNumbersByFolder(true);
    }
}

