/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PanelOutput
extends JPanel
implements ActionListener {
    Component mParent;
    JButton ibrowse;
    JButton obrowse;
    JLabel sourceLabel;
    JTextField source;
    JTextField dest;
    JTextField outfile;
    JCheckBox textout;
    JCheckBox cdiout;
    JCheckBox cdisite;
    JCheckBox cdrout;
    JCheckBox htmlout;

    public PanelOutput(Component component) {
        this.mParent = component;
        GridLayout gridLayout = new GridLayout(5, 1);
        gridLayout.setVgap(5);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(null, ResourceStrings.get("OUTPUT_DIR"), 1, 2));
        this.dest = new JTextField(15);
        jPanel.add(this.dest);
        this.obrowse = new JButton(ResourceStrings.get("BROWSE"));
        this.obrowse.setToolTipText(ResourceStrings.get("TOOLTIP_BROWSE"));
        this.obrowse.addActionListener(this);
        jPanel.add(this.obrowse);
        this.dest.setText(ConfigProperties.get("OUTPUTDIR"));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new TitledBorder(null, ResourceStrings.get("OUTPUT_FILENAME"), 1, 2));
        this.outfile = new JTextField(10);
        this.outfile.setText(ConfigProperties.get("OUTFILE"));
        this.outfile.setToolTipText(ResourceStrings.get("TOOLTIP_OUTFILE"));
        jPanel2.add(this.outfile);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        GridLayout gridLayout2 = new GridLayout(5, 1);
        gridLayout.setVgap(5);
        jPanel3.setLayout(gridLayout2);
        jPanel3.setBorder(new TitledBorder(null, ResourceStrings.get("OUTPUT_FORMATS"), 1, 2));
        this.textout = new JCheckBox(ResourceStrings.get("OUTPUT_TEXTFORMAT"), true);
        this.textout.setToolTipText(ResourceStrings.get("TOOLTIP_OUTPUT_TEXTFORMAT"));
        this.cdiout = new JCheckBox(ResourceStrings.get("OUTPUT_CDIFORMAT"), true);
        this.cdiout.setToolTipText(ResourceStrings.get("TOOLTIP_OUTPUT_CDIFORMAT"));
        this.cdiout.addActionListener(this);
        this.cdisite = new JCheckBox(ResourceStrings.get("LAUNCH_CDINSERT"), true);
        this.cdisite.setToolTipText(ResourceStrings.get("TOOLTIP_LAUNCH_CDINSERT"));
        this.cdrout = new JCheckBox(ResourceStrings.get("OUTPUT_CDRFORMAT"), true);
        this.cdrout.setToolTipText(ResourceStrings.get("TOOLTIP_OUTPUT_CDRFORMAT"));
        this.htmlout = new JCheckBox(ResourceStrings.get("OUTPUT_HTMLFORMAT"), true);
        this.htmlout.setToolTipText(ResourceStrings.get("TOOLTIP_OUTPUT_HTMLFORMAT"));
        jPanel3.add(this.textout);
        jPanel3.add(this.cdrout);
        jPanel3.add(this.htmlout);
        jPanel3.add(this.cdiout);
        jPanel3.add(this.cdisite);
        this.textout.setSelected(ConfigProperties.getBoolean("OUTPUTTXT"));
        this.cdiout.setSelected(ConfigProperties.getBoolean("OUTPUTCDI"));
        this.cdisite.setSelected(ConfigProperties.getBoolean("LAUNCH_CDI_SITE"));
        this.cdrout.setSelected(ConfigProperties.getBoolean("OUTPUTCDR"));
        this.htmlout.setSelected(ConfigProperties.getBoolean("OUTPUTHTML"));
        this.cdisite.setEnabled(this.cdiout.isSelected());
        this.add(jPanel3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ibrowse) {
            this.chooseDir(this.source);
        } else if (actionEvent.getSource() == this.obrowse) {
            this.chooseDir(this.dest);
        } else if (actionEvent.getSource() == this.cdiout) {
            this.cdisite.setEnabled(this.cdiout.isSelected());
        }
    }

    public String getOutputFilename() {
        return this.outfile.getText();
    }

    public String getDestDir() {
        return this.dest.getText();
    }

    public void savePage() {
        ConfigProperties.set("OUTPUTDIR", this.dest.getText());
        ConfigProperties.set("OUTFILE", this.outfile.getText());
        ConfigProperties.setBoolean("OUTPUTTXT", this.textout.isSelected());
        ConfigProperties.setBoolean("OUTPUTCDI", this.cdiout.isSelected());
        ConfigProperties.setBoolean("LAUNCH_CDI_SITE", this.cdisite.isSelected());
        ConfigProperties.setBoolean("OUTPUTCDR", this.cdrout.isSelected());
        ConfigProperties.setBoolean("OUTPUTHTML", this.htmlout.isSelected());
    }

    private void chooseDir(JTextField jTextField) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(ResourceStrings.get("CHOOSE_DIRECTORY"));
        jFileChooser.setCurrentDirectory(new File(jTextField.getText()));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string = file.toString();
            jTextField.setText(string);
        }
    }
}

