/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class PanelConfigMP3
extends JPanel
implements ActionListener {
    MP3Object[] mp3objects;
    int[] rows;
    MP3CDGUI mParent;
    PanelWizardDemo preview;
    JPanel leftpanel;
    JPanel rightpanel;
    JPanel otherpanel;
    JCheckBox removeTrackNumbers;
    JRadioButton trackname;
    JRadioButton trackartist;
    JRadioButton artisttrack;
    JRadioButton files;
    JRadioButton empty;
    ButtonGroup formatgroup;
    boolean isGlobal;

    public PanelConfigMP3(PanelWizardDemo panelWizardDemo) {
        this(null, panelWizardDemo, true);
    }

    public PanelConfigMP3(MP3CDGUI mP3CDGUI) {
        this(mP3CDGUI, null, false);
    }

    public PanelConfigMP3(MP3CDGUI mP3CDGUI, PanelWizardDemo panelWizardDemo, boolean bl) {
        this.mParent = mP3CDGUI;
        this.preview = panelWizardDemo;
        this.isGlobal = bl;
        this.setLayout(new BorderLayout(20, 20));
        this.leftpanel = new JPanel();
        this.leftpanel.setLayout(new BoxLayout(this.leftpanel, 1));
        this.removeTrackNumbers = new JCheckBox(ResourceStrings.get("REMOVE_TRACK_NUMS"));
        this.removeTrackNumbers.addActionListener(this);
        this.removeTrackNumbers.setToolTipText(ResourceStrings.get("TOOLTIP_REMOVE_TRACK_NUMERS"));
        this.leftpanel.add(this.removeTrackNumbers);
        this.rightpanel = new JPanel();
        this.rightpanel.setBorder(new TitledBorder(null, ResourceStrings.get("DISPLAY_OPTIONS"), 1, 2));
        this.rightpanel.setLayout(new BoxLayout(this.rightpanel, 1));
        this.files = new JRadioButton(ResourceStrings.get("USE_FILENAME"));
        this.files.setToolTipText(ResourceStrings.get("TOOLTIP_USE_FILENAME"));
        this.files.addActionListener(this);
        this.rightpanel.add(this.files);
        this.files.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(new TitledBorder(ResourceStrings.get("USE_ID3_TAG")));
        this.trackname = new JRadioButton(ResourceStrings.get("TRACKNAME"));
        this.trackname.setToolTipText(ResourceStrings.get("TOOLTIP_ID3_TRACKNAME"));
        this.trackname.addActionListener(this);
        jPanel.add(this.trackname);
        this.trackartist = new JRadioButton(ResourceStrings.get("TRACK-ARTIST"));
        this.trackartist.setToolTipText(ResourceStrings.get("TOOLTIP_ID3_TRACK-ARTIST"));
        this.trackartist.addActionListener(this);
        jPanel.add(this.trackartist);
        this.artisttrack = new JRadioButton(ResourceStrings.get("ARTIST-TRACK"));
        this.artisttrack.setToolTipText(ResourceStrings.get("TOOLTIP_ID3_ARTIST-TRACK"));
        this.artisttrack.addActionListener(this);
        jPanel.add(this.artisttrack);
        this.empty = new JRadioButton("");
        this.formatgroup = new ButtonGroup();
        this.formatgroup.add(this.files);
        this.formatgroup.add(this.trackname);
        this.formatgroup.add(this.trackartist);
        this.formatgroup.add(this.artisttrack);
        this.formatgroup.add(this.empty);
        this.rightpanel.add(jPanel);
        this.otherpanel = new JPanel();
        this.add((Component)this.leftpanel, "North");
        this.add((Component)this.rightpanel, "Center");
        if (this.isGlobal) {
            this.removeTrackNumbers.setSelected(ConfigProperties.getBoolean("REMOVE_LEADING_TRACK"));
            this.trackname.setSelected(ConfigProperties.getBoolean("ID3_TRACKNAME"));
            this.trackartist.setSelected(ConfigProperties.getBoolean("ID3_TRACKARTIST"));
            this.artisttrack.setSelected(ConfigProperties.getBoolean("ID3_ARTISTTRACK"));
            this.files.setSelected(ConfigProperties.getBoolean("USE_FILENAME"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.files) {
            if (this.files.isSelected()) {
                if (!this.isGlobal) {
                    this.setUseID3(!this.files.isSelected());
                    this.setRemoveLeadingTrackNum(this.removeTrackNumbers.isSelected());
                } else {
                    this.preview.setUseFilename();
                }
            }
        } else if (actionEvent.getSource() == this.removeTrackNumbers) {
            if (!this.isGlobal) {
                this.setRemoveLeadingTrackNum(this.removeTrackNumbers.isSelected());
            }
        } else if (actionEvent.getSource() == this.trackartist) {
            if (!this.isGlobal) {
                this.setUseID3(true);
                this.setID3Format(1);
            } else {
                this.preview.setUseTracknameArtist();
            }
        } else if (actionEvent.getSource() == this.artisttrack) {
            if (!this.isGlobal) {
                this.setUseID3(true);
                this.setID3Format(0);
            } else {
                this.preview.setUseArtistTrackname();
            }
        } else if (actionEvent.getSource() == this.trackname) {
            if (!this.isGlobal) {
                this.setUseID3(true);
                this.setID3Format(2);
            } else {
                this.preview.setUseTrackname();
            }
        }
    }

    private void setUseID3(boolean bl) {
        if (this.mp3objects == null) {
            return;
        }
        int n = 0;
        while (n < this.rows.length) {
            this.mp3objects[n].setUseID3(bl);
            ++n;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    private void setID3Format(int n) {
        if (this.mp3objects == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.rows.length) {
            this.mp3objects[n2].setID3Format(n);
            ++n2;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    private void setRemoveLeadingTrackNum(boolean bl) {
        if (this.mp3objects == null) {
            return;
        }
        int n = 0;
        while (n < this.rows.length) {
            this.mp3objects[n].setRemoveLeadingTrackNum(bl);
            ++n;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        this.mp3objects = mP3ObjectArray;
        this.rows = nArray;
    }

    private void removeCharsFromDisplayString(int n) {
        int n2 = 0;
        while (n2 < this.rows.length) {
            String string = this.mp3objects[n2].getDisplayString();
            this.mp3objects[n2].setDisplayString(string.substring(n));
            ++n2;
        }
        this.mParent.setMP3Objects(this.mp3objects, this.rows);
    }

    public boolean useFilename() {
        return this.files.isSelected();
    }

    public boolean removeTrackNums() {
        return this.removeTrackNumbers.isSelected();
    }

    public int getID3DisplayFormat() {
        if (this.artisttrack.isSelected()) {
            return 0;
        }
        if (this.trackartist.isSelected()) {
            return 1;
        }
        return 2;
    }

    public void saveValues() {
        ConfigProperties.setBoolean("REMOVE_LEADING_TRACK", this.removeTrackNumbers.isSelected());
        ConfigProperties.setBoolean("USE_FILENAME", this.files.isSelected());
        ConfigProperties.setBoolean("USE_ID3", !this.files.isSelected());
        ConfigProperties.setBoolean("ID3_TRACKNAME", this.trackname.isSelected());
        ConfigProperties.setBoolean("ID3_TRACKARTIST", this.trackartist.isSelected());
        ConfigProperties.setBoolean("ID3_ARTISTTRACK", this.artisttrack.isSelected());
    }

    public void clearAll() {
        this.removeTrackNumbers.setSelected(false);
        this.empty.setSelected(true);
    }
}

