/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class OutputHTML
extends Output {
    public static final String NEWLINE = "\n";
    public static final String OTD = "    <TD>";
    public static final String CENTEREDTD = "    <TD align=\"center\">";
    public static final String CTD = "</TD>\n";
    public static final String OTR = "<TR>\n";
    public static final String OCTR = "<TR>\n";
    public static final String CTR = "</TR>";
    public static final String BR = "<BR>";
    public static final String OTABLE = "<CENTER><TABLE border=1>";
    public static final String CTABLE = "</TABLE></CENTER>";
    public static final String HEADER = "<h1>MP3 List</h1><BR><h3>(Created by <A HREF=http://maccc.filenabber.com>MACCC</A>)</h3>";
    public static final String HELP = "<h5>Please email the author if you have ideas for better looking HTML output </h5>\n";
    public static final String FOOTER = "<font face=\"Arial\" size=\"-2\">MACCC \u00a92000-2003 Brian Pipa. All rights reserved.</font>";
    public static final String OCENTER = "<CENTER>";
    public static final String CCENTER = "</CENTER>";
    public static final String OBOLD = "<B>";
    public static final String CBOLD = "</B>";
    public static final String OLINK = "<A HREF=\"";
    public static final String CLINK = "\">";
    public static final String NBSP = "&nbsp;";
    public static final String OSTYLE = "\n<link type=\"text/css\" rel=\"stylesheet\" href=\"";
    public static final String CSTYLE = "\">\n";

    private static String doTableHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TR>\n");
        stringBuffer.append("    <TD>Track Name</TD>\n");
        stringBuffer.append("    <TD>Artist</TD>\n");
        stringBuffer.append("    <TD align=\"center\">Time</TD>\n");
        stringBuffer.append("    <TD align=\"center\">Size (in MB)</TD>\n");
        stringBuffer.append("    <TD align=\"center\">Bitrate (kbps)</TD>\n");
        stringBuffer.append(CTR);
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    private static String doTableEntry(MP3Object mP3Object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("<TR>\n");
        } else {
            stringBuffer.append("<TR>\n");
        }
        stringBuffer.append(OTD);
        if (ConfigProperties.getBoolean("INDENT")) {
            int n = 0;
            while (n < mP3Object.getDepth()) {
                stringBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                ++n;
            }
        }
        if (mP3Object.isDir()) {
            stringBuffer.append(OBOLD);
            stringBuffer.append(mP3Object.getDisplayString());
        } else {
            stringBuffer.append(mP3Object.getID3Trackname());
        }
        if (mP3Object.isDir()) {
            stringBuffer.append(CBOLD);
        }
        stringBuffer.append(CTD);
        String string = mP3Object.getID3Artist();
        if (string == null) {
            string = NBSP;
        }
        stringBuffer.append(OTD + string + CTD);
        stringBuffer.append(CENTEREDTD);
        if (!mP3Object.getSize().equals("0")) {
            stringBuffer.append(mP3Object.getPlaytime());
        }
        stringBuffer.append(CTD);
        stringBuffer.append(CENTEREDTD);
        if (!mP3Object.getSize().equals("0")) {
            stringBuffer.append(mP3Object.getSize());
        }
        stringBuffer.append(CTD);
        stringBuffer.append(CENTEREDTD);
        if (mP3Object.isFile()) {
            stringBuffer.append(mP3Object.getBitrate());
        } else {
            stringBuffer.append(NBSP);
        }
        stringBuffer.append(CTD);
        stringBuffer.append(CTR);
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    private static String doHTMLHead() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><HEAD><TITLE>MP3 List (Created by MACCC)</TITLE>");
        stringBuffer.append("</HEAD>");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("<BODY>");
        stringBuffer.append(NEWLINE);
        return stringBuffer.toString();
    }

    public static void writeHTML(String string, Vector vector) {
        int n = 0;
        int n2 = 0;
        long l = 0L;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(OutputHTML.doHTMLHead());
        stringBuffer.append("<CENTER><h1>MP3 List</h1><BR><h3>(Created by <A HREF=http://maccc.filenabber.com>MACCC</A>)</h3><h5>Please email the author if you have ideas for better looking HTML output </h5>\n</CENTER><BR>\n");
        stringBuffer.append("<CENTER><TABLE border=1><BR>");
        stringBuffer.append(OutputHTML.doTableHeader());
        boolean bl = true;
        int n3 = 0;
        while (n3 < vector.size()) {
            MP3Object mP3Object = (MP3Object)vector.elementAt(n3);
            stringBuffer.append(OutputHTML.doTableEntry(mP3Object, bl));
            if (mP3Object.isDir()) {
                ++n;
            } else {
                ++n2;
                l += mP3Object.getPlaytimeMillis();
            }
            bl = !bl;
            ++n3;
        }
        stringBuffer.append("</TABLE></CENTER><BR>\n");
        stringBuffer.append("\r\n<CENTER><I>Songs: " + n2 + ", Total Playtime: " + MP3Object.getDisplayTime(l) + "</I>" + CCENTER);
        stringBuffer.append("<BR>\n");
        stringBuffer.append("<CENTER><font face=\"Arial\" size=\"-2\">MACCC \u00a92000-2003 Brian Pipa. All rights reserved.</font></CENTER>");
        stringBuffer.append("\n</BODY></HTML>");
        try {
            Output.createAFile(string + ".html", stringBuffer.toString());
            System.out.println("Successfully created HTML file.");
            System.out.println(string + ".html");
        }
        catch (Exception exception) {
            System.out.println("ERROR - could not create HTML output file.");
            exception.printStackTrace();
        }
    }
}

