/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MP3Table {
    String dir;
    JTable tableView;
    TableModel dataModel;
    JPanel panel;
    Dimension origin = new Dimension(0, 0);
    final int INITIAL_ROWHEIGHT = 20;
    int filecount = 0;
    int dircount = 0;
    Vector mp3files;
    final ImageIcon less48icon;
    final ImageIcon the48icon;
    final ImageIcon the56icon;
    final ImageIcon the64icon;
    final ImageIcon the96icon;
    final ImageIcon the112icon;
    final ImageIcon the128icon;
    final ImageIcon the160icon;
    final ImageIcon the192icon;
    final ImageIcon the256icon;
    final ImageIcon foldericon;

    public MP3Table() {
        String string = ".png";
        String string2 = "fluor/";
        this.less48icon = this.createImageIcon(string2 + "less48" + string);
        this.the48icon = this.createImageIcon(string2 + "48" + string);
        this.the56icon = this.createImageIcon(string2 + "56" + string);
        this.the64icon = this.createImageIcon(string2 + "64" + string);
        this.the96icon = this.createImageIcon(string2 + "96" + string);
        this.the112icon = this.createImageIcon(string2 + "112" + string);
        this.the128icon = this.createImageIcon(string2 + "128" + string);
        this.the160icon = this.createImageIcon(string2 + "160" + string);
        this.the192icon = this.createImageIcon(string2 + "192" + string);
        this.the256icon = this.createImageIcon(string2 + "256" + string);
        this.foldericon = this.createImageIcon("closedfolder_16.png");
    }

    public static void main(String[] stringArray) {
        MP3Table mP3Table = new MP3Table();
        JTable jTable = mP3Table.createTable(stringArray[0]);
        JFrame jFrame = new JFrame("TESTING");
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jScrollPane, "Center");
        jFrame.pack();
        jFrame.show();
    }

    public JTable getTable() {
        return this.tableView;
    }

    public JTable createTable(String string) {
        final String[] stringArray = new String[]{ResourceStrings.get("DISPLAY_NAME"), ResourceStrings.get("BITRATE"), ResourceStrings.get("FILENAME"), ResourceStrings.get("ID3_ARTIST"), ResourceStrings.get("ID3_TRACKNAME"), ResourceStrings.get("SIZE"), ResourceStrings.get("TIME")};
        MP3CD mP3CD = new MP3CD(string);
        Date date = new Date();
        System.out.println("Starting scan of " + string + " at " + date);
        mP3CD.setGui(false);
        this.mp3files = mP3CD.beginFindAllMP3Files(string);
        this.dircount = mP3CD.getDirCount();
        this.filecount = mP3CD.getFileCount();
        date = new Date();
        System.out.println("Finished scan at " + date + "\n");
        this.dataModel = new AbstractTableModel(){

            public int getColumnCount() {
                return stringArray.length;
            }

            public int getRowCount() {
                return MP3Table.this.mp3files.size();
            }

            public String getColumnName(int n) {
                return stringArray[n];
            }

            public Class getColumnClass(int n) {
                if (n == 1) {
                    return MP3Table.this.foldericon.getClass();
                }
                return "test".getClass();
            }

            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            public void setValueAt(Object object, int n, int n2) {
                MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
                mP3Object.setDisplayString((String)object);
                MP3Table.this.setMP3Object(mP3Object, n);
                this.fireTableCellUpdated(n, n2);
            }

            public Object getValueAt(int n, int n2) {
                MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
                if (n2 == 0) {
                    return mP3Object.getDisplayString();
                }
                if (n2 == 1) {
                    int n3 = mP3Object.getType();
                    if (n3 == 0) {
                        int n4 = mP3Object.getBitrate();
                        return this.getIcon(n4);
                    }
                    return MP3Table.this.foldericon;
                }
                if (n2 == 2) {
                    return mP3Object.getFilename();
                }
                if (n2 == 3) {
                    int n5 = mP3Object.getType();
                    if (n5 == 1) {
                        return "";
                    }
                    String string = mP3Object.getID3Artist();
                    if (string == null || string.equals("???") || string.equals("")) {
                        string = mP3Object.getUseID3() ? "<HTML><font color=red>???</font></HTML>" : "???";
                    }
                    return string;
                }
                if (n2 == 4) {
                    int n6 = mP3Object.getType();
                    if (n6 == 1) {
                        return " ";
                    }
                    String string = mP3Object.getID3Trackname();
                    if (string == null || string.equals("???") || string.equals("")) {
                        string = mP3Object.getUseID3() ? "<HTML><font color=red>???</font></HTML>" : "???";
                    }
                    return string;
                }
                if (n2 == 5) {
                    return mP3Object.getSize();
                }
                if (n2 == 6) {
                    return mP3Object.getPlaytime();
                }
                return "TEMP";
            }

            private ImageIcon getIcon(int n) {
                if (n < 48) {
                    return MP3Table.this.less48icon;
                }
                if (n < 56) {
                    return MP3Table.this.the48icon;
                }
                if (n < 64) {
                    return MP3Table.this.the56icon;
                }
                if (n < 96) {
                    return MP3Table.this.the64icon;
                }
                if (n < 112) {
                    return MP3Table.this.the96icon;
                }
                if (n < 128) {
                    return MP3Table.this.the112icon;
                }
                if (n < 160) {
                    return MP3Table.this.the128icon;
                }
                if (n < 192) {
                    return MP3Table.this.the160icon;
                }
                if (n < 255) {
                    return MP3Table.this.the192icon;
                }
                return MP3Table.this.the256icon;
            }
        };
        this.tableView = new JTable(this.dataModel);
        this.tableView.setDragEnabled(true);
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new DisplayStringRenderer());
        tableColumn.setMinWidth(150);
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setPreferredWidth(18);
        tableColumnModel.getColumn(5).setPreferredWidth(40);
        tableColumnModel.getColumn(6).setPreferredWidth(40);
        int n = 20;
        this.tableView.setRowHeight(20);
        return this.tableView;
    }

    public String getString(String string) {
        return string;
    }

    public ImageIcon createImageIcon(String string) {
        String string2 = "/images/" + string;
        return new ImageIcon(this.getClass().getResource(string2));
    }

    public Vector getMP3Vector() {
        return this.mp3files;
    }

    public int getMP3VectorSize() {
        return this.mp3files.size();
    }

    public int[] getSelectedRows() {
        return this.tableView.getSelectedRows();
    }

    public int getDirCount() {
        return this.dircount;
    }

    public int getFileCount() {
        return this.filecount;
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.mp3files.setElementAt(mP3ObjectArray[n], nArray[n]);
            this.tableView.tableChanged(new TableModelEvent(this.dataModel, nArray[n]));
            ++n;
        }
    }

    public MP3Object getMP3Object(int n) {
        return (MP3Object)this.mp3files.elementAt(n);
    }

    public void setMP3Object(MP3Object mP3Object, int n) {
        this.mp3files.setElementAt(mP3Object, n);
        this.tableView.tableChanged(new TableModelEvent(this.dataModel, n));
    }

    class DisplayStringRenderer
    implements TableCellRenderer {
        Font tempfont = UIManager.getFont("Label.font");
        String fontName = this.tempfont.getName();
        int fontSize = this.tempfont.getSize();
        Font plainFont = new Font(this.fontName, 0, this.fontSize);

        DisplayStringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            MP3Object mP3Object = (MP3Object)MP3Table.this.mp3files.elementAt(n);
            if (mP3Object.getType() == 0) {
                String string = mP3Object.getDisplayString();
                JLabel jLabel = new JLabel(string);
                jLabel.setFont(this.plainFont);
                if (string.indexOf("???") != -1) {
                    jLabel.setForeground(Color.red);
                }
                return jLabel;
            }
            return new JLabel(mP3Object.getDisplayString());
        }
    }
}

