/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import joeshmoe.mpeg.ID3Tag;
import joeshmoe.mpeg.MPEGInfo;
import joeshmoe.mpeg.MPEGProber;

public class MP3Object {
    public static final int TYPE_FILE = 0;
    public static final int TYPE_DIR = 1;
    public static final int ID3_ARTIST_SONG = 0;
    public static final int ID3_SONG_ARTIST = 1;
    public static final int ID3_SONG = 2;
    public static final char UNDERSCORE = '_';
    public static final char SPACE = ' ';
    public static final char DASH = '-';
    public static final char AND = '&';
    public static final String O_PAREN = "(";
    public static final String C_PAREN = ")";
    public static final String O_BRACK = "[";
    public static final String C_BRACK = "]";
    public static final String UNKNOWN = "???";
    public static final String SIZE_ABBR = "MB";
    public static final String BITRATE_ABBR = "kbps";
    static boolean DEBUG = false;
    String fs = File.separator;
    int type;
    String displaystring;
    String filename;
    String id3_artist;
    String id3_trackname;
    String id3_tracknum;
    String size;
    String playtime;
    long playtimemillis;
    String thepath;
    int bitrate = 0;
    int depth = 0;
    String folder_track_num = "00";
    String cd_track_num = "00";
    boolean mp3_use_ID3;
    boolean mp3_file_remove_leading_track_num;
    int ID3format;
    boolean capitalize_all_words = true;
    String suffix = "";

    public MP3Object(String string) throws Exception {
        DEBUG = ConfigProperties.debug();
        this.mp3_use_ID3 = ConfigProperties.getBoolean("USE_ID3");
        this.mp3_file_remove_leading_track_num = ConfigProperties.getBoolean("REMOVE_LEADING_TRACK");
        if (ConfigProperties.getBoolean("ID3_TRACKNAME")) {
            this.ID3format = 2;
        } else if (ConfigProperties.getBoolean("ID3_TRACKARTIST")) {
            this.ID3format = 1;
        } else if (ConfigProperties.getBoolean("ID3_ARTISTTRACK")) {
            this.ID3format = 0;
        }
        this.thepath = string;
        try {
            File file = new File(string);
            if (file.isDirectory()) {
                this.type = 1;
                this.filename = string.substring(string.lastIndexOf(this.fs) + 1);
                this.size = this.getSizeOfMP3sInDir(file);
            } else {
                this.type = 0;
                this.size = this.getDisplaySize(file);
                MPEGInfo mPEGInfo = MPEGProber.probeFile(file);
                this.playtimemillis = mPEGInfo.getLength();
                this.playtime = MP3Object.getDisplayTime(this.playtimemillis);
                this.bitrate = mPEGInfo.getBitrate();
                this.filename = string.substring(string.lastIndexOf(this.fs) + 1);
                this.getID3Info(mPEGInfo);
            }
        }
        catch (Exception exception) {
            System.out.println("  Error reading MP3/dir: " + this.thepath);
            throw exception;
        }
        this.doDisplayString();
    }

    public int getType() {
        return this.type;
    }

    public String getSize() {
        return this.size;
    }

    public String getPlaytime() {
        return this.playtime;
    }

    public long getPlaytimeMillis() {
        return this.playtimemillis;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getTrackname() {
        return this.id3_trackname;
    }

    public String getPath() {
        return this.thepath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getDisplayString() {
        return this.displaystring;
    }

    public String getID3Artist() {
        return this.id3_artist;
    }

    public String getID3Trackname() {
        return this.id3_trackname;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public boolean getUseID3() {
        return this.mp3_use_ID3;
    }

    public boolean getRemoveLeadingTrackNum() {
        return this.mp3_file_remove_leading_track_num;
    }

    public boolean isDir() {
        return this.type == 1;
    }

    public boolean isFile() {
        return !this.isDir();
    }

    public void setRemoveLeadingTrackNum(boolean bl) {
        this.mp3_file_remove_leading_track_num = bl;
        this.doDisplayString();
    }

    public void setUseID3(boolean bl) {
        this.mp3_use_ID3 = bl;
        this.doDisplayString();
    }

    public void setID3Format(int n) {
        this.ID3format = n;
        this.doDisplayString();
    }

    public void setDisplayString(String string) {
        this.displaystring = string;
    }

    public void setFolderTrackNum(String string) {
        this.folder_track_num = string;
        this.doDisplayString();
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setCDTrackNum(String string) {
        this.cd_track_num = string;
        this.doDisplayString();
    }

    public static String getDisplayTime(long l) {
        String string;
        long l2 = l / 1000L;
        int n = (int)(l2 / 60L);
        int n2 = (int)l2 - n * 60;
        int n3 = n / 60;
        n -= n3 * 60;
        String string2 = Integer.toString(n2);
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        String string3 = "";
        if (n3 > 0) {
            string3 = n3 + ":";
        }
        if ((string = Integer.toString(n)).length() == 1) {
            string = "0" + string;
        }
        string3 = string3 + string + ":" + string2;
        return string3;
    }

    private String getDisplaySize(File file) {
        double d = file.length();
        double d2 = d / 1024.0 / 1024.0;
        return this.roundMe(d2, 2);
    }

    private void getID3Info(MPEGInfo mPEGInfo) {
        String string = null;
        String string2 = null;
        int n = -1;
        String string3 = null;
        ID3Tag iD3Tag = mPEGInfo.getID3();
        if (iD3Tag != null) {
            string = iD3Tag.getSong();
            if (string == "") {
                string = null;
            }
            if ((string2 = iD3Tag.getArtist()) == "") {
                string2 = null;
            }
            if ((n = iD3Tag.getTrack()) > 0) {
                string3 = Integer.toString(n);
            }
        }
        this.id3_artist = string2;
        this.id3_trackname = string;
        this.id3_tracknum = string3;
    }

    public String toString() {
        System.out.println("in toString()");
        String string = " | ";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FILENAME=" + this.filename + string);
        if (this.type == 0) {
            stringBuffer.append("MP3" + string);
        } else {
            stringBuffer.append("DIR" + string);
        }
        stringBuffer.append("SIZE=" + this.size + string);
        stringBuffer.append("PLAYTIME=" + this.playtime + string);
        if (this.type == 0) {
            stringBuffer.append("TRACKNAME=" + this.id3_trackname + string);
            stringBuffer.append("ARTIST=" + this.id3_artist + string);
            stringBuffer.append("TRACKNUM=" + this.id3_tracknum + string);
        }
        stringBuffer.append("DISPLAYSTRING=" + this.displaystring + string);
        return stringBuffer.toString();
    }

    private String getNumMP3sInDir(File file) {
        File[] fileArray = file.listFiles();
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            String string = fileArray[n2].getName();
            if (string.toLowerCase().endsWith(".mp3")) {
                try {
                    MPEGInfo mPEGInfo = MPEGProber.probeFile(fileArray[n2]);
                    this.playtimemillis += mPEGInfo.getLength();
                    ++n;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        this.playtime = MP3Object.getDisplayTime(this.playtimemillis);
        this.size = Integer.toString(n);
        return Integer.toString(n);
    }

    private String getSizeOfMP3sInDir(File file) {
        File[] fileArray = file.listFiles();
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getName();
            if (string.toLowerCase().endsWith(".mp3")) {
                try {
                    MPEGInfo mPEGInfo = MPEGProber.probeFile(fileArray[n]);
                    this.playtimemillis += mPEGInfo.getLength();
                    d = fileArray[n].length();
                    d2 += d / 1024.0 / 1024.0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n;
        }
        this.playtime = MP3Object.getDisplayTime(this.playtimemillis);
        return this.roundMe(d2, 2);
    }

    private String roundMe(double d, int n) {
        if (n <= 0) {
            return "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            int n2 = (int)d;
            string = string + n2;
            d -= (double)n2;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private String removeLeadingTrackNums(String string) {
        String string2 = MP3Object.trimit(string);
        if (string2.length() > 2) {
            if (string2.charAt(2) == '-' || string2.charAt(2) == ' ' || string2.charAt(2) == '_') {
                if (Character.isDigit(string2.charAt(0)) && Character.isDigit(string2.charAt(1))) {
                    string2 = string2.substring(3);
                }
            } else if (string2.length() > 4) {
                if (string2.substring(2, 5).equals(" - ")) {
                    if (Character.isDigit(string2.charAt(0)) && Character.isDigit(string2.charAt(1))) {
                        string2 = string2.substring(5);
                    }
                } else if (string2.charAt(0) == '(' && string2.charAt(3) == ')') {
                    if (Character.isDigit(string2.charAt(1)) && Character.isDigit(string2.charAt(2))) {
                        string2 = string2.substring(4);
                    }
                } else if (string2.charAt(0) == '(' && string2.charAt(2) == ')' && Character.isDigit(string2.charAt(1))) {
                    string2 = string2.substring(3);
                }
            }
        }
        return MP3Object.trimit(string2);
    }

    private void doDisplayString() {
        String string = this.filename;
        this.suffix = "";
        if (this.type == 0) {
            if (!this.mp3_use_ID3) {
                string = string.substring(0, string.length() - 4);
            } else {
                if (this.id3_trackname == null || this.id3_trackname.equals("")) {
                    this.id3_trackname = UNKNOWN;
                }
                if (this.id3_artist == null || this.id3_artist.equals("")) {
                    this.id3_artist = UNKNOWN;
                }
                if (this.ID3format == 2) {
                    string = this.id3_trackname;
                } else if (this.ID3format == 1) {
                    string = this.id3_trackname + "-" + this.id3_artist;
                } else if (this.ID3format == 0) {
                    string = this.id3_artist + "-" + this.id3_trackname;
                }
            }
            if (this.capitalize_all_words) {
                String string2 = string;
                string = MP3Object.capitalizeAllWords(string2);
            }
            if (this.mp3_file_remove_leading_track_num) {
                string = this.removeLeadingTrackNums(string);
            }
            if (ConfigProperties.getBoolean("ADDTRACKNUMS")) {
                string = this.cd_track_num + "-" + string;
            }
            if (ConfigProperties.getBoolean("ADDFOLDTRACKNUMS")) {
                string = this.folder_track_num + "-" + string;
            }
            boolean bl = ConfigProperties.getBoolean("ADD_PLAYTIME");
            boolean bl2 = ConfigProperties.getBoolean("ADD_SIZE");
            if (bl && bl2) {
                this.suffix = " [" + this.size + SIZE_ABBR + C_BRACK + O_BRACK + this.playtime + C_BRACK;
            } else if (bl) {
                this.suffix = " [" + this.playtime + C_BRACK;
            } else if (bl2) {
                this.suffix = " [" + this.size + SIZE_ABBR + C_BRACK;
            }
            boolean bl3 = ConfigProperties.getBoolean("ADD_BITRATE");
            if (bl3) {
                this.suffix = this.suffix + " " + O_BRACK + this.bitrate + BITRATE_ABBR + C_BRACK;
            }
            string = string + this.suffix;
        } else {
            if (ConfigProperties.getBoolean("CAP_DIR_NAMES")) {
                string = string.toUpperCase();
            }
            boolean bl = ConfigProperties.getBoolean("ADD_TIME_TO_DIRS");
            boolean bl4 = ConfigProperties.getBoolean("ADD_COUNT_TO_DIRS");
            if (!this.size.equals("0")) {
                if (bl && bl4) {
                    this.suffix = " [" + this.size + C_BRACK + O_BRACK + this.playtime + C_BRACK;
                } else if (bl) {
                    this.suffix = " [" + this.playtime + C_BRACK;
                } else if (bl4) {
                    this.suffix = " [" + this.size + C_BRACK;
                }
            }
            string = string + this.suffix;
            if (ConfigProperties.getBoolean("ADD_FOLDER_NUMBERS")) {
                string = O_BRACK + this.folder_track_num + C_BRACK + string;
            }
            if (ConfigProperties.getBoolean("ADD_PREFIX_TO_DIRS")) {
                String string3 = ConfigProperties.get("DIR_PREFIX");
                string = string3 + string;
            }
        }
        if (ConfigProperties.getBoolean("CONVERT_UNDERSCORE_TO_SPACE")) {
            string = string.replace('_', ' ');
        }
        this.displaystring = string;
    }

    public static String capitalizeAllWords(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.trim().toLowerCase());
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        int n = 1;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            char c2 = stringBuffer.charAt(n - 1);
            if (c2 == ' ' || c2 == '-' || c2 == '_' || c2 == '&') {
                stringBuffer.setCharAt(n, Character.toUpperCase(c));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String trimit(String string) {
        String string2 = string.trim();
        if (string2.startsWith("-") || string2.startsWith("_")) {
            string2 = string2.substring(1);
            string2 = MP3Object.trimit(string2);
        } else if (string2.endsWith("-") || string2.endsWith("_")) {
            string2 = string2.substring(0, string2.length() - 2);
            string2 = MP3Object.trimit(string2);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            MP3Object mP3Object = new MP3Object(stringArray[0]);
            System.out.println(mP3Object.getType());
            System.out.println(mP3Object.getSize());
            System.out.println(mP3Object.getFilename());
            System.out.println(mP3Object.getTrackname());
            System.out.println(mP3Object.getPlaytime());
            System.out.println(mP3Object.getPath());
            System.out.println("TOSTRING:");
            System.out.println(mP3Object.toString());
        }
        catch (Exception exception) {}
    }
}

