/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class MP3CDGUI
extends JPanel
implements ActionListener {
    public static final String fs = File.separator;
    public static final String openAction = "open";
    public static final String newAction = "new";
    public static final String saveAction = "save";
    public static final String exitAction = "exit";
    JTabbedPane globaloptionspanel;
    PanelMP3Local mp3localpanel;
    PanelDirLocal dirlocalpanel;
    PanelWarning warningPanel;
    PanelMP3Global globalMp3Panel;
    PanelDirGlobal globalDirPanel;
    MP3Table mp3Table;
    JButton goButton;
    JButton writeCoversButton;
    JButton rescanButton;
    JButton scanNewButton;
    PanelOptions optionsPanel;
    PanelOutput outputPanel;
    JMenuItem aboutMi;
    JMenuItem optionsMi;
    JMenuItem mp3Mi;
    JMenuItem dirMi;
    JMenuItem exitMi;
    JMenuItem scanMi;
    JMenuItem rescanMi;
    JMenuItem helpMi;
    JMenuItem writeMi;
    JPanel aboutPanel;
    JPanel infoPanel;
    JFrame aboutFrame;
    JButton closeAbout;
    JDialog optionsFrame;
    JDialog outputFrame;
    Popups popups = new Popups(this);
    String scandir;
    JButton saveButton;
    JButton cancelButton;
    JButton outputSaveButton;
    JButton outputCancelButton;
    JToolBar toolbar;
    JButton scanButton;
    JButton rescanCDButton;
    JButton writeButton;
    JButton optionsButton;
    JButton aboutButton;
    JButton helpButton;
    JButton exitButton;
    ImageIcon scanIcon;
    ImageIcon rescanIcon;
    ImageIcon writeIcon;
    ImageIcon configIcon;
    ImageIcon aboutIcon;
    ImageIcon helpIcon;
    ImageIcon exitIcon;
    ImageIcon folderIcon;
    ImageIcon mp3Icon;
    ImageIcon smallConfigIcon;
    ImageIcon smallFolderIcon;
    ImageIcon smallMp3Icon;
    ImageIcon smallWriteIcon;
    ImageIcon smallAboutIcon;
    ImageIcon smallHelpIcon;
    ImageIcon smallExitIcon;
    private JMenuBar menubar;
    private JComponent status;

    MP3CDGUI(String string) {
        super(true);
        this.scandir = string;
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        String string2 = ".png";
        this.loadIcons();
        this.toolbar = new JToolBar();
        this.scanButton = new JButton(this.scanIcon);
        this.toolbar.add(this.scanButton);
        this.scanButton.setToolTipText(ResourceStrings.get("TOOLTIP_SCAN_NEW"));
        this.scanButton.addActionListener(this);
        this.rescanCDButton = new JButton(this.rescanIcon);
        this.toolbar.add(this.rescanCDButton);
        this.rescanCDButton.setToolTipText(ResourceStrings.get("TOOLTIP_RESCAN"));
        this.rescanCDButton.addActionListener(this);
        this.writeButton = new JButton(this.writeIcon);
        this.toolbar.add(this.writeButton);
        this.writeButton.setToolTipText(ResourceStrings.get("TOOLTIP_WRITE_COVERS"));
        this.writeButton.addActionListener(this);
        this.optionsButton = new JButton(this.configIcon);
        this.toolbar.add(this.optionsButton);
        this.optionsButton.setToolTipText(ResourceStrings.get("TOOLTIP_OPTIONS"));
        this.optionsButton.addActionListener(this);
        this.aboutButton = new JButton(this.aboutIcon);
        this.toolbar.add(this.aboutButton);
        this.aboutButton.setToolTipText(ResourceStrings.get("TOOLTIP_ABOUT"));
        this.aboutButton.addActionListener(this);
        this.helpButton = new JButton(this.helpIcon);
        this.toolbar.add(this.helpButton);
        this.helpButton.setToolTipText(ResourceStrings.get("TOOLTIP_HELP"));
        this.helpButton.addActionListener(this);
        this.exitButton = new JButton(this.exitIcon);
        this.exitButton.setToolTipText(ResourceStrings.get("TOOLTIP_EXIT"));
        this.exitButton.addActionListener(this);
        this.toolbar.add(this.exitButton);
        this.infoPanel = new JPanel();
        CardLayout cardLayout = new CardLayout();
        this.infoPanel.setLayout(cardLayout);
        this.mp3localpanel = new PanelMP3Local(this);
        this.infoPanel.add("MP3", this.mp3localpanel);
        this.dirlocalpanel = new PanelDirLocal(this);
        this.infoPanel.add("DIR", this.dirlocalpanel);
        this.warningPanel = new PanelWarning(this);
        this.infoPanel.add("WARNING", this.warningPanel);
        this.mp3Table = new MP3Table();
        this.mp3Table.createTable(this.scandir);
        SelectionListener selectionListener = new SelectionListener(this.mp3Table.getTable());
        this.mp3Table.getTable().getSelectionModel().addListSelectionListener(selectionListener);
        JScrollPane jScrollPane = new JScrollPane();
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.add(this.mp3Table.getTable());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.menubar = this.createMenubar();
        jPanel.add("North", this.menubar);
        jPanel.add("Center", this.toolbar);
        this.add("North", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add("North", this.infoPanel);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, jPanel2);
        jSplitPane.setResizeWeight(1.0);
        this.add("Center", jSplitPane);
        this.aboutPanel = new PanelAbout();
        this.saveButton = new JButton(ResourceStrings.get("SAVE"));
        this.saveButton.addActionListener(this);
        this.cancelButton = new JButton(ResourceStrings.get("CANCEL"));
        this.cancelButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.saveButton);
        jPanel3.add(this.cancelButton);
        this.globaloptionspanel = new JTabbedPane();
        this.optionsPanel = new PanelOptions(this);
        this.globalMp3Panel = new PanelMP3Global(this);
        this.globalDirPanel = new PanelDirGlobal(this);
        this.globaloptionspanel.addTab("MP3", this.smallMp3Icon, this.globalMp3Panel);
        this.globaloptionspanel.addTab(ResourceStrings.get("MP3_DIRS"), this.smallFolderIcon, this.globalDirPanel);
        this.globaloptionspanel.addTab(ResourceStrings.get("OPTIONS"), this.smallConfigIcon, this.optionsPanel);
        this.optionsFrame = new JDialog((Frame)this.getParent(), true);
        this.optionsFrame.setTitle(ResourceStrings.get("GLOBAL_OPTIONS"));
        this.optionsFrame.getContentPane().setLayout(new BorderLayout());
        this.optionsFrame.getContentPane().add("Center", this.globaloptionspanel);
        this.optionsFrame.getContentPane().add("South", jPanel3);
        this.optionsFrame.pack();
        int n = 480;
        int n2 = 640;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.optionsFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
        this.outputPanel = new PanelOutput(this);
        this.outputSaveButton = new JButton(ResourceStrings.get("SAVE"));
        this.outputSaveButton.addActionListener(this);
        this.outputCancelButton = new JButton(ResourceStrings.get("CANCEL"));
        this.outputCancelButton.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.outputSaveButton);
        jPanel4.add(this.outputCancelButton);
        this.outputFrame = new JDialog((Frame)this.getParent(), true);
        this.outputFrame.setTitle(ResourceStrings.get("OUTPUT"));
        this.outputFrame.getContentPane().setLayout(new BorderLayout());
        this.outputFrame.getContentPane().add("Center", this.outputPanel);
        this.outputFrame.getContentPane().add("South", jPanel4);
        this.outputFrame.pack();
        int n3 = 480;
        int n4 = 480;
        this.outputFrame.setLocation(dimension.width / 2 - n3 / 2, dimension.height / 2 - n4 / 2);
        this.aboutFrame = new JFrame();
        this.aboutFrame.setTitle(ResourceStrings.get("ABOUT_FRAME"));
        this.aboutFrame.getContentPane().setLayout(new BorderLayout());
        this.aboutFrame.getContentPane().add("Center", this.aboutPanel);
        this.closeAbout = new JButton(ResourceStrings.get("CLOSE"));
        this.closeAbout.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        jPanel5.add(this.closeAbout);
        this.aboutFrame.getContentPane().add("South", jPanel5);
        this.aboutFrame.pack();
        this.aboutFrame.setLocation(dimension.width / 2 - n / 2, dimension.height / 2 - n2 / 2);
    }

    public static void setupLook() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.err.println("Error loading L&F: " + exception);
        }
    }

    private void writeCovers() {
        boolean bl = ConfigProperties.getBoolean("OUTPUTCDR");
        boolean bl2 = ConfigProperties.getBoolean("OUTPUTTXT");
        boolean bl3 = ConfigProperties.getBoolean("OUTPUTCDI");
        boolean bl4 = ConfigProperties.getBoolean("OUTPUTHTML");
        if (!(bl || bl2 || bl3 || bl4)) {
            this.popups.showInfoMessage(ResourceStrings.get("ERROR_NO_OUTPUT"));
            return;
        }
        String string = ConfigProperties.get("OUTPUTDIR");
        if (string == null || string.equals("")) {
            this.popups.showError(ResourceStrings.get("ERROR_NO_OUTPUT_DIR"));
            return;
        }
        this.outputFrame.hide();
        ConfigProperties.save();
        Object object = new File(string);
        if (!((File)object).exists()) {
            this.popups.showError(ResourceStrings.get("ERROR_OUTPUT_DIR_NOT_EXIST"));
            return;
        }
        object = ConfigProperties.get("OUTFILE");
        String string2 = string + fs + (String)object;
        if (bl) {
            OutputNewCDRLabel outputNewCDRLabel = new OutputNewCDRLabel();
            outputNewCDRLabel.setDirCount(this.mp3Table.getDirCount());
            outputNewCDRLabel.setFileCount(this.mp3Table.getFileCount());
            outputNewCDRLabel.writePlaylist(string2, this.mp3Table.getMP3Vector());
        }
        if (bl2) {
            OutputText.writeTextFile(string2, this.mp3Table.getMP3Vector());
        }
        if (bl3) {
            OutputCDI.writeCDIFile(string2, this.mp3Table.getMP3Vector());
            try {
                if (ConfigProperties.getBoolean("LAUNCH_CDI_SITE")) {
                    BrowserLauncher.openURL("http://cdinsert.filenabber.com");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl4) {
            OutputHTML.writeHTML(string2, this.mp3Table.getMP3Vector());
        }
        this.popups.showInfoMessage(ResourceStrings.get("SUCCESS"));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (actionEvent.getSource() == this.writeButton || actionEvent.getSource() == this.writeMi) {
            if (this.mp3Table.getMP3VectorSize() != 0) {
                this.outputFrame.show();
            } else {
                this.popups.showError(ResourceStrings.get("ERROR_NOTHING_TO_PRINT"));
            }
        }
        if (actionEvent.getSource() == this.aboutButton || actionEvent.getSource() == this.aboutMi) {
            this.aboutFrame.show();
        }
        if ((actionEvent.getSource() == this.exitButton || actionEvent.getSource() == this.exitMi) && (bl = this.popups.showQuestion("EXIT_ARE_YOU_SURE"))) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.optionsButton) {
            this.globaloptionspanel.setSelectedIndex(0);
            this.optionsFrame.show();
        } else if (actionEvent.getSource() == this.mp3Mi) {
            this.globaloptionspanel.setSelectedIndex(0);
            this.optionsFrame.show();
        } else if (actionEvent.getSource() == this.dirMi) {
            this.globaloptionspanel.setSelectedIndex(1);
            this.optionsFrame.show();
        } else if (actionEvent.getSource() == this.optionsMi) {
            this.globaloptionspanel.setSelectedIndex(2);
            this.optionsFrame.show();
        } else if (actionEvent.getSource() == this.saveButton) {
            this.optionsPanel.savePage();
            this.globalMp3Panel.savePage();
            this.globalDirPanel.savePage();
            ConfigProperties.save();
            this.optionsFrame.hide();
            bl = false;
            if (this.mp3Table.getMP3VectorSize() != 0) {
                bl = this.popups.showQuestion(ResourceStrings.get("RESCAN_QUESTION"), ResourceStrings.get("RESCAN"));
            }
            if (bl) {
                this.mp3Table.createTable(this.scandir);
                this.invalidate();
                this.validate();
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.cancelButton) {
            this.optionsFrame.hide();
        } else if (actionEvent.getSource() == this.scanButton || actionEvent.getSource() == this.scanMi) {
            String string;
            bl = true;
            if (this.mp3Table.getMP3VectorSize() != 0) {
                bl = this.popups.showQuestion(ResourceStrings.get("CURRENT_COVER_DISCARDED"));
            }
            if (bl && (string = MP3CDGUI.showDirChooser(this.scandir)) != null) {
                this.scandir = string;
                ConfigProperties.set("MP3DIR", this.scandir);
                ConfigProperties.save();
                this.mp3Table.createTable(this.scandir);
                this.invalidate();
                this.validate();
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.rescanCDButton || actionEvent.getSource() == this.rescanMi) {
            bl = this.popups.showQuestion(ResourceStrings.get("CURRENT_COVER_DISCARDED"));
            if (bl) {
                this.mp3Table.createTable(this.scandir);
                this.invalidate();
                this.validate();
                this.repaint();
            }
        } else if (actionEvent.getSource() == this.helpButton || actionEvent.getSource() == this.helpMi) {
            new HelpDialog();
        } else if (actionEvent.getSource() == this.closeAbout) {
            this.aboutFrame.hide();
        } else if (actionEvent.getSource() == this.outputSaveButton) {
            this.outputPanel.savePage();
            this.writeCovers();
        } else if (actionEvent.getSource() == this.outputCancelButton) {
            this.outputFrame.hide();
        }
    }

    public void setMP3Objects(MP3Object[] mP3ObjectArray, int[] nArray) {
        this.mp3Table.setMP3Objects(mP3ObjectArray, nArray);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public static String showDirChooser(String string) {
        int n;
        if (string == null) {
            string = "";
        }
        String string2 = "";
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle(ResourceStrings.get("CHOOSE_DIR"));
        if (string != "") {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        if ((n = jFileChooser.showOpenDialog(null)) == 0) {
            File file = jFileChooser.getSelectedFile();
            string2 = file.getPath();
            ConfigProperties.set("MP3DIR", string2);
            ConfigProperties.save();
            return string2;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        System.out.println(System.getProperty("user.dir"));
        CurrentVersion currentVersion = new CurrentVersion();
        MP3CDGUI.setupLook();
        if (ConfigProperties.getBoolean("SHOW_SPLASH")) {
            new Splash("images/splash.jpg", 3, true);
        }
        System.out.println("---------------------------------------------------");
        System.out.println(ResourceStrings.get("MACCC_NAME") + " " + currentVersion.getVersionString());
        System.out.println(ResourceStrings.get("COPYRIGHT"));
        System.out.println(ResourceStrings.get("RIGHTS_RESERVED"));
        System.out.println(ResourceStrings.get("EMAIL_AUTHOR") + " maccc@filenabber.com");
        System.out.println(ResourceStrings.get("CURRENT_VERSION"));
        System.out.println("---------------------------------------------------");
        try {
            String string;
            String string2 = System.getProperty("java.version");
            if (string2.compareTo("1.4") < 0) {
                System.out.println(ResourceStrings.get("JAVA_VERSION"));
            }
            if (!ConfigProperties.debug() && ConfigProperties.getBoolean("UPDATE_CHECK")) {
                string = currentVersion.getNewVersion();
                if (string != null) {
                    currentVersion.showNewVersion(string);
                }
            }
            string = ConfigProperties.get("MP3DIR");
            JFrame jFrame = new JFrame();
            jFrame.setTitle(ResourceStrings.get("MACCC_NAME") + " " + currentVersion.getVersionString());
            jFrame.setBackground(Color.lightGray);
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add("Center", new MP3CDGUI(string));
            jFrame.addWindowListener(new AppCloser());
            jFrame.pack();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            jFrame.setSize(dimension.width, dimension.height);
            jFrame.setLocation(0, 0);
            jFrame.show();
        }
        catch (Throwable throwable) {
            System.out.println("uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
    }

    protected Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    private void loadIcons() {
        String string = ".png";
        String string2 = "icons/";
        String string3 = string2 + "cd_22" + string;
        URL uRL = this.getClass().getResource(string3);
        this.scanIcon = new ImageIcon(uRL);
        string3 = string2 + "cd-rescan_22" + string;
        uRL = this.getClass().getResource(string3);
        this.rescanIcon = new ImageIcon(uRL);
        string3 = string2 + "save_22" + string;
        uRL = this.getClass().getResource(string3);
        this.writeIcon = new ImageIcon(uRL);
        string3 = string2 + "save_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallWriteIcon = new ImageIcon(uRL);
        string3 = string2 + "options_24" + string;
        uRL = this.getClass().getResource(string3);
        this.configIcon = new ImageIcon(uRL);
        string3 = string2 + "options_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallConfigIcon = new ImageIcon(uRL);
        string3 = string2 + "about_22" + string;
        uRL = this.getClass().getResource(string3);
        this.aboutIcon = new ImageIcon(uRL);
        string3 = string2 + "about_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallAboutIcon = new ImageIcon(uRL);
        string3 = string2 + "help_24" + string;
        uRL = this.getClass().getResource(string3);
        this.helpIcon = new ImageIcon(uRL);
        string3 = string2 + "help_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallHelpIcon = new ImageIcon(uRL);
        string3 = string2 + "exit_24" + string;
        uRL = this.getClass().getResource(string3);
        this.exitIcon = new ImageIcon(uRL);
        string3 = string2 + "exit_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallExitIcon = new ImageIcon(uRL);
        string3 = string2 + "folder_24" + string;
        uRL = this.getClass().getResource(string3);
        this.folderIcon = new ImageIcon(uRL);
        string3 = string2 + "folder_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallFolderIcon = new ImageIcon(uRL);
        string3 = string2 + "note_16" + string;
        uRL = this.getClass().getResource(string3);
        this.smallMp3Icon = new ImageIcon(uRL);
        string3 = string2 + "note_24" + string;
        uRL = this.getClass().getResource(string3);
        this.mp3Icon = new ImageIcon(uRL);
    }

    protected JMenuBar createMenubar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(ResourceStrings.get("FILE"));
        this.writeMi = new JMenuItem(ResourceStrings.get("TOOLTIP_WRITE_COVERS"), this.smallWriteIcon);
        this.writeMi.addActionListener(this);
        jMenu.add(this.writeMi);
        this.exitMi = new JMenuItem(ResourceStrings.get("EXIT"), this.smallExitIcon);
        this.exitMi.addActionListener(this);
        jMenu.add(this.exitMi);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(ResourceStrings.get("SCAN"));
        this.scanMi = new JMenuItem(ResourceStrings.get("TOOLTIP_SCAN_NEW"), this.scanIcon);
        this.scanMi.addActionListener(this);
        jMenu2.add(this.scanMi);
        this.rescanMi = new JMenuItem(ResourceStrings.get("TOOLTIP_RESCAN"), this.rescanIcon);
        this.rescanMi.addActionListener(this);
        jMenu2.add(this.rescanMi);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(ResourceStrings.get("OPTIONS"));
        this.mp3Mi = new JMenuItem(ResourceStrings.get("MP3"), this.smallMp3Icon);
        this.mp3Mi.addActionListener(this);
        jMenu3.add(this.mp3Mi);
        this.dirMi = new JMenuItem(ResourceStrings.get("MP3_DIRS"), this.smallFolderIcon);
        this.dirMi.addActionListener(this);
        jMenu3.add(this.dirMi);
        this.optionsMi = new JMenuItem(ResourceStrings.get("OPTIONS"), this.smallConfigIcon);
        this.optionsMi.addActionListener(this);
        jMenu3.add(this.optionsMi);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(ResourceStrings.get("HELP"));
        this.helpMi = new JMenuItem(ResourceStrings.get("HELP_PAGE"), this.smallHelpIcon);
        this.helpMi.addActionListener(this);
        jMenu4.add(this.helpMi);
        this.aboutMi = new JMenuItem(ResourceStrings.get("TOOLTIP_ABOUT"), this.smallAboutIcon);
        this.aboutMi.addActionListener(this);
        jMenu4.add(this.aboutMi);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.table.getSelectionModel()) {
                Object object;
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MP3CDGUI.this.mp3localpanel.clearSettings();
                int[] nArray = this.table.getSelectedRows();
                MP3Object[] mP3ObjectArray = new MP3Object[nArray.length];
                int n = -1;
                int n2 = 0;
                while (n2 < nArray.length) {
                    mP3ObjectArray[n2] = object = MP3CDGUI.this.mp3Table.getMP3Object(nArray[n2]);
                    int n3 = ((MP3Object)object).getType();
                    if (n == -1) {
                        n = n3;
                    } else if (n != n3) {
                        ((CardLayout)MP3CDGUI.this.infoPanel.getLayout()).show(MP3CDGUI.this.infoPanel, "WARNING");
                        return;
                    }
                    ++n2;
                }
                if (n == 0) {
                    MP3CDGUI.this.mp3localpanel.setMP3Objects(mP3ObjectArray, nArray);
                    ((CardLayout)MP3CDGUI.this.infoPanel.getLayout()).show(MP3CDGUI.this.infoPanel, "MP3");
                } else {
                    Object object2;
                    int n4;
                    object = new Vector();
                    Vector<Integer> vector = new Vector<Integer>();
                    int n5 = 0;
                    while (n5 < nArray.length) {
                        n4 = 1;
                        int n6 = nArray[n5] + n4;
                        object2 = MP3CDGUI.this.mp3Table.getMP3Object(n6);
                        while (((MP3Object)object2).isFile()) {
                            ((Vector)object).addElement(object2);
                            vector.addElement(new Integer(n6));
                            n6 = nArray[n5] + ++n4;
                            if (n6 == MP3CDGUI.this.mp3Table.getMP3VectorSize()) break;
                            object2 = MP3CDGUI.this.mp3Table.getMP3Object(nArray[n5] + n4);
                        }
                        ++n5;
                    }
                    n4 = ((Vector)object).size();
                    MP3Object[] mP3ObjectArray2 = new MP3Object[n4];
                    object2 = new int[n4];
                    int n7 = 0;
                    while (n7 < n4) {
                        mP3ObjectArray2[n7] = (MP3Object)((Vector)object).elementAt(n7);
                        object2[n7] = (Integer)vector.elementAt(n7);
                        ++n7;
                    }
                    MP3CDGUI.this.dirlocalpanel.setMP3Objects(mP3ObjectArray2, (int[])object2);
                    ((CardLayout)MP3CDGUI.this.infoPanel.getLayout()).show(MP3CDGUI.this.infoPanel, "DIR");
                }
            }
        }
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
        }
    }

    protected static final class AppCloser
    extends WindowAdapter {
        protected AppCloser() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            System.exit(0);
        }
    }
}

