/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CurrentVersion
implements ActionListener {
    public static final String VERSIONURL = "http://www.filenabber.com/maccc/version";
    public static final String MAJOR = "Major-Version";
    public static final String MINOR = "Minor-version";
    public static final String JARNAME = "maccc.jar";
    static int minorVersion;
    static int majorVersion;
    public static final String FS;
    static String macccHomeDir;

    public CurrentVersion() {
        this.readManifest();
    }

    private void readManifest() {
        try {
            Properties properties = System.getProperties();
            String string = properties.getProperty("java.class.path");
            String string2 = properties.getProperty("user.dir");
            String string3 = string.indexOf(FS) != -1 ? string : string2 + FS + string;
            File file = new File(string3);
            macccHomeDir = file.getParent();
            if (ConfigProperties.debug()) {
                System.out.println("macccHomeDir  = " + macccHomeDir);
                System.out.println("Path to jar = " + string3);
            }
            JarFile jarFile = new JarFile(string3);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            majorVersion = Integer.parseInt(attributes.getValue(MAJOR));
            minorVersion = Integer.parseInt(attributes.getValue(MINOR));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String getVersionString() {
        return majorVersion + "." + minorVersion;
    }

    public static String getMacccHomeDir() {
        return macccHomeDir;
    }

    public static String getNewVersion() {
        String string;
        block6: {
            System.out.print(ResourceStrings.get("CHECKING") + ".....");
            string = null;
            boolean bl = false;
            try {
                int n;
                Properties properties = new Properties();
                URL uRL = new URL(VERSIONURL);
                properties.load(uRL.openStream());
                String string2 = properties.getProperty("maccc.major.version");
                String string3 = properties.getProperty("maccc.minor.version");
                int n2 = Integer.parseInt(string2);
                if (n2 > majorVersion) {
                    bl = true;
                } else if (n2 == majorVersion && (n = Integer.parseInt(string3)) > minorVersion) {
                    bl = true;
                }
                if (bl) {
                    string = string2 + "." + string3;
                    break block6;
                }
                System.out.println(ResourceStrings.get("NO_NEW_VERSION"));
            }
            catch (Exception exception) {
                System.out.println(ResourceStrings.get("NO_CHECK_VERSION"));
            }
        }
        return string;
    }

    public void showNewVersion(String string) {
        System.out.println("New version found: v" + string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 1));
        JLabel jLabel = new JLabel(ResourceStrings.get("NEW_VERSION") + " " + string + "!", 0);
        Font font = jLabel.getFont();
        String string2 = font.getName();
        int n = font.getSize();
        Font font2 = new Font(string2, 1, n);
        jLabel.setFont(font2);
        JLabel jLabel2 = new JLabel(" ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        ActiveURL activeURL = new ActiveURL(ResourceStrings.get("VISIT_SITE_FOR_DETAILS"), "http://maccc.filenabber.com");
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(activeURL);
        JOptionPane.showMessageDialog(null, jPanel, ResourceStrings.get("MACCC_NEW_VERSION"), -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static void main(String[] stringArray) {
        CurrentVersion currentVersion = new CurrentVersion();
        String string = currentVersion.getNewVersion();
        System.out.println("newversion = " + string);
        System.out.println("majorversion = " + majorVersion);
        System.out.println("minorversion = " + minorVersion);
    }

    static {
        FS = File.separator;
    }
}

