/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Properties;

public class ConvertMessageBundle {
    public static final String fs = File.separator;
    boolean DEBUG = true;
    Properties originalProperties;
    Properties newProperties;

    public void doConversion(String string, String string2) {
        this.readProps(string2);
        this.writeProps(string);
        this.save(string2, string);
    }

    private void writeProps(String string) {
        this.newProperties = new Properties();
        this.originalProperties.propertyNames();
        Enumeration<?> enumeration = this.originalProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.originalProperties.get(string2);
            this.newProperties.setProperty(string2, "_" + string + "_" + string3);
        }
    }

    public void save(String string, String string2) {
        try {
            File file = new File(string);
            String string3 = file.getName();
            String string4 = file.getParent();
            int n = string3.indexOf(".properties");
            String string5 = string3.substring(0, n);
            String string6 = string4 + fs + string5 + "_" + string2 + ".properties";
            File file2 = new File(string6);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.newProperties.store(fileOutputStream, "");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readProps(String string) {
        this.originalProperties = new Properties();
        String string2 = File.separator;
        String string3 = string;
        File file = new File(string3);
        if (file.exists()) {
            if (this.DEBUG) {
                System.out.println("Found Config File");
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(string3);
                this.originalProperties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (Exception exception) {
                System.out.println("File error - unable to load " + string3);
                exception.printStackTrace();
            }
        } else if (this.DEBUG) {
            System.out.println("Didn't find File");
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            ConvertMessageBundle.usage();
        }
        ConvertMessageBundle convertMessageBundle = new ConvertMessageBundle();
        convertMessageBundle.doConversion(stringArray[0], stringArray[1]);
    }

    public static void usage() {
        System.out.println("\nInvalid parameter list");
        System.out.println("Usage:");
        System.out.println("       java ConvertMessageBundle [abbreviation] [filename]");
        System.out.println("           EX: java ConvertMessageBundle es c:\\1tmp\\messages.properties");
    }
}

