/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class ActiveURL
extends JPanel
implements MouseListener {
    String destURL = "http://www.pipa.ws";
    Font linkFont;
    Color inactiveColor = Color.blue;
    Color activeColor = Color.green;
    Color clickedColor = Color.red;
    Color backgroundColor;
    boolean mouseButtonHeld = false;
    boolean mouseEntered = false;
    JButton button;

    public void setButtonFont(Font font) {
        this.button.setFont(font);
    }

    public void setInactiveColor(Color color) {
        this.inactiveColor = color;
        this.button.setForeground(this.inactiveColor);
    }

    public void setActiveColor(Color color) {
        this.activeColor = color;
    }

    public void setClickedColor(Color color) {
        this.clickedColor = color;
    }

    public ActiveURL(String string) {
        this(string, string);
    }

    public ActiveURL(String string, String string2) {
        this.destURL = string2;
        this.backgroundColor = UIManager.getColor("control");
        this.button = new JButton(string);
        this.button.addMouseListener(this);
        this.button.setFocusPainted(false);
        this.button.setBorderPainted(false);
        this.button.setText(string);
        this.button.setForeground(this.inactiveColor);
        this.button.setBackground(this.backgroundColor);
        this.button.setToolTipText(string2);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.button, gridBagConstraints);
        this.add(this.button);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseButtonHeld = true;
        this.button.setBackground(this.backgroundColor);
        this.button.setForeground(this.clickedColor);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseEntered) {
            this.button.setForeground(this.activeColor);
        } else {
            this.button.setForeground(this.inactiveColor);
        }
        this.mouseButtonHeld = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            this.button.setForeground(this.clickedColor);
            BrowserLauncher.openURL(this.destURL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEntered = true;
        if (!this.mouseButtonHeld) {
            this.button.setForeground(this.activeColor);
        } else {
            this.button.setForeground(this.clickedColor);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEntered = false;
        this.button.setForeground(this.inactiveColor);
    }
}

