/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Transport;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.API.Transport.TransportException;

public class ModemTransport
extends SLPTransportInterface
implements ActionListener {
    public static final int DEFAULT_SPEED = 57600;
    public static final String DEFAULT_INIT_STRING = "ATZ";
    protected transient CommPortIdentifier port = null;
    protected transient SerialPort ser = null;
    protected transient DataInputStream dis = null;
    protected transient DataOutputStream dos = null;
    protected transient boolean connected = false;
    protected transient boolean modemConnected = false;
    protected String portName = null;
    protected String initString = "ATZ";
    protected static int serialSpeed = 57600;
    protected transient JComboBox comSelectBox = null;
    protected transient JComboBox speedSelectBox = null;
    protected transient JTextField initStringField = null;

    public ModemTransport() throws TransportException {
        try {
            Class.forName("javax.comm.SerialPort");
            ModemTransport.getPortNames().elementAt(0);
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    public void close() throws TransportException {
        try {
            this.disconnect();
            this.dis.skip(this.dis.available());
            this.dis.close();
            this.dos.close();
            this.ser.close();
            this.connected = false;
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    public void disconnect() {
        this.modemConnected = false;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws TransportException {
        try {
            while (this.dis.available() > 0) {
                this.dis.read();
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    public String getTransportName() {
        return this.resBundle.getString("transport.modemapi.name");
    }

    /*
     * Unable to fully structure code
     */
    private static Vector getPortNames() {
        v = new Vector<String>();
        i = false;
        enumeration = null;
        try {
            enumeration = CommPortIdentifier.getPortIdentifiers();
            if (true) ** GOTO lbl11
        }
        catch (NoClassDefFoundError ex) {
            return null;
        }
        do {
            v.addElement(((CommPortIdentifier)enumeration.nextElement()).getName());
lbl11:
            // 2 sources

        } while (enumeration.hasMoreElements());
        return v;
    }

    public void open() throws TransportException {
        if (this.connected) {
            return;
        }
        try {
            this.ser = (SerialPort)this.port.open("SLP_Transport", 100);
            this.ser.setSerialPortParams(serialSpeed, 8, 1, 0);
            this.ser.setFlowControlMode(3);
            this.dis = new DataInputStream(this.ser.getInputStream());
            this.dos = new DataOutputStream(this.ser.getOutputStream());
            this.dos.writeBytes(this.initString + "\n");
            this.connected = true;
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    public byte readByte() {
        this.waitForModemConnection();
        try {
            byte data = this.dis.readByte();
            return data;
        }
        catch (IOException ex) {
            return 0;
        }
    }

    private void waitForModemConnection() {
        int stage = 0;
        char data = '\u0000';
        if (this.modemConnected) {
            return;
        }
        block11: do {
            try {
                data = (char)this.dis.readByte();
            }
            catch (Exception exception) {
                // empty catch block
            }
            switch (stage) {
                case 0: {
                    if (data != 'C') continue block11;
                    ++stage;
                    break;
                }
                case 1: {
                    if (data == 'O') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                case 2: {
                    if (data == 'N') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                case 3: {
                    if (data == 'N') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                case 4: {
                    if (data == 'E') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                case 5: {
                    if (data == 'C') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                case 6: {
                    if (data == 'T') {
                        ++stage;
                        break;
                    }
                    stage = 0;
                    break;
                }
                default: {
                    stage = 0;
                }
            }
        } while (stage != 7);
        this.modemConnected = true;
    }

    public void writeBytes(byte[] data) {
        try {
            this.dos.write(data, 0, data.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected JPanel constructConfigPanel() {
        JPanel ret = new JPanel();
        JLabel comPortLabel = new JLabel(this.resBundle.getString("transport.commapi.portlabel"));
        JLabel comSpeedLabel = new JLabel(this.resBundle.getString("transport.commapi.speedlabel"));
        JLabel initStringLabel = new JLabel(this.resBundle.getString("transport.commapimodem.initstringlabel"));
        this.initStringField = new JTextField(DEFAULT_INIT_STRING);
        Vector<String> v = new Vector<String>();
        v.addElement("9600");
        v.addElement("19200");
        v.addElement("57600");
        v.addElement("115200");
        this.comSelectBox = new JComboBox(ModemTransport.getPortNames());
        this.speedSelectBox = new JComboBox(v);
        ret.setLayout(new GridLayout(7, 1));
        ret.add(comPortLabel);
        ret.add(this.comSelectBox);
        ret.add(comSpeedLabel);
        ret.add(this.speedSelectBox);
        ret.add(initStringLabel);
        ret.add(this.initStringField);
        if (ModemTransport.getPortNames().size() > 0) {
            this.portName = (String)ModemTransport.getPortNames().elementAt(0);
        }
        serialSpeed = 9600;
        this.initString = DEFAULT_INIT_STRING;
        return ret;
    }

    public void initialize() throws TransportException {
        this.connected = false;
        if (this.initStringField != null && this.initStringField.getText() != null && !this.initStringField.getText().equals("")) {
            this.initString = this.initStringField.getText();
        }
        try {
            this.port = CommPortIdentifier.getPortIdentifier((String)this.portName);
            this.ser = (SerialPort)this.port.open("SLP_Transport", 100);
            this.ser.setSerialPortParams(serialSpeed, 8, 1, 0);
            this.ser.setFlowControlMode(3);
            this.dis = new DataInputStream(this.ser.getInputStream());
            this.dos = new DataOutputStream(this.ser.getOutputStream());
            this.connected = true;
            this.dos.writeBytes(this.initString + "\n\r");
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    public void initialize(Properties properties, int id) throws TransportException {
        int i = 0;
        String portName = properties.getProperty("jsyncman.server.port." + id);
        Vector v = ModemTransport.getPortNames();
        boolean found = false;
        i = 0;
        while (i < v.size()) {
            if (portName == null) break;
            if (((String)v.elementAt(i)).equals(portName)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            StringBuffer sb = new StringBuffer(this.resBundle.getString("transport.commapi.server.portname_error"));
            sb.append("jsyncman.server.port.");
            sb.append(id);
            sb.append("\n\n");
            sb.append(this.resBundle.getString("transport.commapi.server.validports"));
            sb.append("\n");
            i = 0;
            while (i < v.size()) {
                sb.append((String)v.elementAt(i));
                sb.append("\n");
                ++i;
            }
            throw new TransportException(new Exception(sb.toString()));
        }
        try {
            serialSpeed = Integer.parseInt(properties.getProperty("jsyncman.server.speed." + id));
        }
        catch (NumberFormatException e) {
            throw new TransportException(new Exception(this.resBundle.getString("transport.commapi.server.portspeed_error") + "jsyncman.server.speed." + id));
        }
        this.initString = properties.getProperty("jsyncman.server.initString." + id);
        if (this.initString == null) {
            this.initString = DEFAULT_INIT_STRING;
        }
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JComboBox)) {
            return;
        }
        JComboBox cb = (JComboBox)e.getSource();
        if (cb == this.comSelectBox) {
            this.portName = (String)this.comSelectBox.getSelectedItem();
            return;
        }
        if (cb == this.speedSelectBox) {
            try {
                serialSpeed = Integer.parseInt((String)this.speedSelectBox.getSelectedItem());
            }
            catch (NumberFormatException ex) {
                System.out.println("*** A ModemTransport parse error has occurred. Forcing 57600bps...");
                serialSpeed = 57600;
            }
        }
    }

    public String getTransportExceptionText(TransportException ex) {
        if (ex == null) {
            return null;
        }
        if (ex.getReasonCode() == 2) {
            return this.resBundle.getString("transport.commapi.insufficientinfo");
        }
        if (ex.getReasonCode() == 1) {
            if (ex.getException() instanceof IOException) {
                return this.resBundle.getString("transport.commapi.ioexceptiontext");
            }
            if (ex.getException() instanceof NoClassDefFoundError) {
                return this.resBundle.getString("transport.commapi.noapiexceptiontext");
            }
            if (ex.getException() instanceof UnsupportedCommOperationException) {
                return this.resBundle.getString("transport.commapi.badcommoperation");
            }
            if (ex.getException() instanceof NoSuchPortException) {
                return this.resBundle.getString("transport.commapi.nosuchport");
            }
            if (ex.getException() instanceof PortInUseException) {
                return this.resBundle.getString("transport.commapi.portinuse");
            }
            return this.resBundle.getString("transport.commapi.unknownexception");
        }
        return this.resBundle.getString("transport.commapi.undefinederror");
    }

    public String getResourceBundleName() {
        return "org.jSyncManager.Transport.Resources.Text.CommAPITransportResources";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("====================================\n");
        sb.append("CommAPI Transport Instance Settings:\n");
        sb.append("------------------------------------\n");
        sb.append("  Port Name:    ");
        sb.append(this.portName);
        sb.append("\n");
        sb.append("  Serial Speed: ");
        sb.append(serialSpeed);
        sb.append("\n");
        sb.append("  Init String:  ");
        sb.append(this.initString);
        sb.append("\n");
        sb.append("====================================\n\n");
        return sb.toString();
    }
}

