/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Transport;

import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jSyncManager.API.Transport.TransportException;
import org.jSyncManager.API.Transport.USBTransportInterface;
import usb.core.Bus;
import usb.core.Configuration;
import usb.core.Device;
import usb.core.Endpoint;
import usb.core.Host;
import usb.core.HostFactory;
import usb.core.Hub;
import usb.core.Interface;
import usb.core.USBListener;

public class JUSBTransport
extends USBTransportInterface
implements USBListener {
    private boolean USBdebug = true;
    private transient Host host = null;
    private transient Bus[] busses;
    private transient Hub[] hubs;
    private transient Device dev = null;
    private transient Configuration conf = null;
    private transient DataInputStream dis = null;
    private transient DataOutputStream dos = null;
    private transient boolean initialized = false;

    public JUSBTransport() throws TransportException {
        try {
            Class.forName("usb.core.Hub");
        }
        catch (ClassNotFoundException e) {
            throw new TransportException(e);
        }
    }

    public String getResourceBundleName() {
        return "org.jSyncManager.Transport.Resources.Text.JUSBTransportResources";
    }

    public String getTransportExceptionText(TransportException ex) {
        return null;
    }

    public String getTransportName() {
        return this.resBundle.getString("transport.usb.name");
    }

    public void initialize() throws TransportException {
        if (this.initialized) {
            return;
        }
        try {
            this.host = HostFactory.getHost();
            if (this.host == null) {
                throw new RuntimeException("transport.usb.usbunavailable");
            }
            this.host.addUSBListener((USBListener)this);
            this.initialized = true;
        }
        catch (Throwable e) {
            throw new TransportException(e);
        }
    }

    public boolean checkPDAType(Device dev1) {
        boolean test = false;
        if (dev1.getDeviceDescriptor().getVendorId() == 2096 || dev1.getDeviceDescriptor().getVendorId() == 2093 || dev1.getDeviceDescriptor().getVendorId() == 1356) {
            test = true;
        }
        return test;
    }

    public void initialize(Properties properties, int id) throws TransportException {
        this.initialize();
    }

    public void open() throws TransportException {
    }

    public void finalize() throws TransportException {
        if (this.isConnected()) {
            this.close();
        }
    }

    public void close() throws TransportException {
        if (this.isConnected()) {
            this.flush();
            try {
                this.dis.close();
                this.dos.close();
                this.dis = null;
                this.dos = null;
                this.connected = false;
            }
            catch (IOException exc) {
                throw new TransportException(exc);
            }
        }
    }

    public void flush() throws TransportException {
        if (!this.isConnected()) {
            return;
        }
        try {
            while (this.dis.available() > 0) {
                this.dis.read();
            }
            this.dos.flush();
        }
        catch (IOException exc) {
            throw new TransportException(exc);
        }
    }

    public byte readByte() {
        if (!this.isConnected()) {
            JUSBTransport jUSBTransport = this;
            synchronized (jUSBTransport) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            return this.dis.readByte();
        }
        catch (IOException exc) {
            System.err.println("USB > readByte > " + exc);
            return 0;
        }
    }

    public void writeBytes(byte[] data) {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.dos.write(data);
            this.dos.flush();
        }
        catch (IOException exc) {
            System.err.println("[USBTransport] - Failed to write data bytes!");
        }
    }

    private Hub getBusOf(Device dev) throws IOException {
        Bus bus = dev.getBus();
        int i = 0;
        while (i < this.busses.length) {
            if (bus == this.busses[i]) {
                return this.hubs[i];
            }
            ++i;
        }
        return null;
    }

    public void busAdded(Bus bus) throws IOException {
        Bus[] busArray = this.busses;
        synchronized (busArray) {
            Bus[] newBusses = new Bus[this.busses.length + 1];
            Hub[] newHubs = new Hub[newBusses.length];
            System.arraycopy(this.busses, 0, newBusses, 0, this.busses.length);
            System.arraycopy(this.hubs, 0, newHubs, 0, this.busses.length);
            newBusses[this.busses.length] = bus;
            try {
                newHubs[this.busses.length] = new Hub(bus.getRootHub());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.busses = newBusses;
            this.hubs = newHubs;
        }
    }

    public void busRemoved(Bus bus) throws IOException {
        Bus[] busArray = this.busses;
        synchronized (busArray) {
            Bus[] newBusses = new Bus[this.busses.length - 1];
            Hub[] newHubs = new Hub[newBusses.length];
            int nodeIndex = -1;
            Hub node = null;
            int index = 0;
            int i = 0;
            while (i < this.busses.length) {
                if (this.busses[i] == bus) {
                    nodeIndex = i;
                    node = this.hubs[i];
                } else {
                    newBusses[index] = this.busses[i];
                    newHubs[index] = this.hubs[i];
                    ++index;
                }
                ++i;
            }
            this.busses = newBusses;
            this.hubs = newHubs;
        }
    }

    public void deviceAdded(Device dev) {
        block9: {
            try {
                if (this.isConnected() || !this.checkPDAType(dev)) break block9;
                Configuration conf = dev.getConfiguration();
                int numInterfaces = conf.getNumInterfaces();
                Interface intf = conf.getInterface(0, 0);
                int i = 0;
                while (i < intf.getNumEndpoints()) {
                    Endpoint end_tmp = conf.getInterface(0, 0).getEndpoint(i);
                    if (end_tmp.getType().equalsIgnoreCase("bulk") && end_tmp.getMaxPacketSize() == 64) {
                        if (end_tmp.isInput()) {
                            BufferedInputStream bis = new BufferedInputStream(end_tmp.getInputStream(), 64);
                            this.dis = new DataInputStream(bis);
                        } else {
                            BufferedOutputStream bos = new BufferedOutputStream(end_tmp.getOutputStream(), 64);
                            this.dos = new DataOutputStream(bos);
                        }
                    }
                    ++i;
                }
                JUSBTransport jUSBTransport = this;
                synchronized (jUSBTransport) {
                    this.notifyAll();
                }
                this.connected = true;
            }
            catch (Throwable exc) {
                System.err.println(exc);
            }
        }
    }

    public void deviceRemoved(Device dev) throws IOException {
    }

    protected JPanel constructConfigPanel() {
        JPanel ret = new JPanel();
        JLabel usbLabel = new JLabel(this.resBundle.getString("transport.usb.usblabel"));
        ret.setLayout(new GridLayout(2, 1));
        ret.add(usbLabel);
        return ret;
    }
}

