/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Transport;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jSyncManager.API.Transport.SerialTransportInterface;
import org.jSyncManager.API.Transport.TransportException;

public class CommAPITransport
extends SerialTransportInterface
implements ActionListener {
    protected transient CommPortIdentifier port = null;
    protected transient SerialPort ser = null;
    protected transient DataInputStream dis = null;
    protected transient DataOutputStream dos = null;
    protected transient JComboBox comSelectBox = null;
    protected transient JComboBox speedSelectBox = null;
    public static final int INITIAL_SERIAL_SPEED = 9600;
    protected String portName = null;
    protected int serialSpeed = 9600;

    public CommAPITransport() throws TransportException {
        try {
            Class.forName("javax.comm.SerialPort");
            CommAPITransport.getPortNames().elementAt(0);
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws TransportException {
        TransportException ex;
        block6: {
            ex = null;
            if (this.dis == null) return;
            if (this.dos == null || this.ser == null) {
                return;
            }
            try {
                try {
                    this.dis.skip(this.dis.available());
                    this.dis.close();
                    this.dos.close();
                }
                catch (Exception e) {
                    ex = new TransportException(e);
                    Object var4_3 = null;
                    this.ser.close();
                    this.connected = false;
                    break block6;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.ser.close();
                this.connected = false;
                throw throwable;
            }
            this.ser.close();
            this.connected = false;
        }
        if (ex != null) {
            throw ex;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void flush() throws TransportException {
        try {
            while (this.dis.available() > 0) {
                this.dis.read();
            }
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    public String getTransportName() {
        return this.resBundle.getString("transport.commapi.name");
    }

    private static Vector getPortNames() throws NoClassDefFoundError {
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = null;
        enumeration = CommPortIdentifier.getPortIdentifiers();
        while (enumeration.hasMoreElements()) {
            v.addElement(((CommPortIdentifier)enumeration.nextElement()).getName());
        }
        return v;
    }

    public void open() throws TransportException {
        if (this.connected) {
            return;
        }
        this.initialize();
    }

    public byte readByte() {
        try {
            return this.dis.readByte();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    public void setSpeed(int speed) throws TransportException {
        TransportException ex = null;
        try {
            this.flush();
        }
        catch (TransportException e) {
            ex = new TransportException(e);
        }
        try {
            this.ser.setSerialPortParams(speed, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            throw new TransportException(e);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public void writeBytes(byte[] data) {
        try {
            this.dos.write(data, 0, data.length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected JPanel constructConfigPanel() {
        JPanel ret = new JPanel();
        JLabel comPortLabel = new JLabel(this.resBundle.getString("transport.commapi.portlabel"));
        JLabel comSpeedLabel = new JLabel(this.resBundle.getString("transport.commapi.speedlabel"));
        Vector<String> v = new Vector<String>();
        v.addElement("9600");
        v.addElement("19200");
        v.addElement("57600");
        v.addElement("115200");
        this.comSelectBox = new JComboBox(CommAPITransport.getPortNames());
        this.speedSelectBox = new JComboBox(v);
        this.comSelectBox.addActionListener(this);
        this.speedSelectBox.addActionListener(this);
        ret.setLayout(new GridLayout(5, 1));
        ret.add(comPortLabel);
        ret.add(this.comSelectBox);
        ret.add(comSpeedLabel);
        ret.add(this.speedSelectBox);
        if (CommAPITransport.getPortNames().size() > 0) {
            this.portName = (String)CommAPITransport.getPortNames().elementAt(0);
        }
        this.serialSpeed = 9600;
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof JComboBox)) {
            return;
        }
        JComboBox cb = (JComboBox)e.getSource();
        if (cb == this.comSelectBox) {
            this.portName = (String)this.comSelectBox.getSelectedItem();
            return;
        }
        if (cb == this.speedSelectBox) {
            try {
                this.serialSpeed = Integer.parseInt((String)this.speedSelectBox.getSelectedItem());
            }
            catch (NumberFormatException ex) {
                System.out.println("*** A CommAPITransport parse error has occurred. Forcing 9600bps...");
                this.serialSpeed = 9600;
            }
        }
    }

    public synchronized void initialize() throws TransportException {
        if (this.portName == null) {
            throw new TransportException(2);
        }
        try {
            if (this.connected) {
                this.close();
            }
            this.connected = false;
            this.port = CommPortIdentifier.getPortIdentifier((String)this.portName);
            this.ser = (SerialPort)this.port.open("SLP_Transport", 100);
            this.ser.setSerialPortParams(9600, 8, 1, 0);
            this.ser.setFlowControlMode(3);
            this.dis = new DataInputStream(this.ser.getInputStream());
            this.dos = new DataOutputStream(this.ser.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            throw new TransportException(e);
        }
    }

    public int getPreferredSyncSpeed() {
        return this.serialSpeed;
    }

    public void initialize(Properties properties, int id) throws TransportException {
        boolean i = false;
        String portName = properties.getProperty("jsyncman.server.port." + id);
        try {
            this.serialSpeed = Integer.parseInt(properties.getProperty("jsyncman.server.speed." + id));
        }
        catch (NumberFormatException e) {
            throw new TransportException(new Exception(this.resBundle.getString("transport.commapi.server.portspeed_error") + "jsyncman.server.speed." + id));
        }
        this.initialize();
    }

    public String getTransportExceptionText(TransportException ex) {
        if (ex == null) {
            return null;
        }
        if (ex.getReasonCode() == 2) {
            return this.resBundle.getString("transport.commapi.insufficientinfo");
        }
        if (ex.getReasonCode() == 1) {
            if (ex.getException() instanceof IOException) {
                return this.resBundle.getString("transport.commapi.ioexceptiontext");
            }
            if (ex.getException() instanceof NoClassDefFoundError) {
                return this.resBundle.getString("transport.commapi.noapiexceptiontext");
            }
            if (ex.getException() instanceof UnsupportedCommOperationException) {
                return this.resBundle.getString("transport.commapi.badcommoperation");
            }
            if (ex.getException() instanceof NoSuchPortException) {
                return this.resBundle.getString("transport.commapi.nosuchport");
            }
            if (ex.getException() instanceof PortInUseException) {
                return this.resBundle.getString("transport.commapi.portinuse");
            }
            return this.resBundle.getString("transport.commapi.unknownexception");
        }
        return this.resBundle.getString("transport.commapi.undefinederror");
    }

    public String getResourceBundleName() {
        return "org.jSyncManager.Transport.Resources.Text.CommAPITransportResources";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("====================================\n");
        sb.append("CommAPI Transport Instance Settings:\n");
        sb.append("------------------------------------\n");
        sb.append("  Port Name:    ");
        sb.append(this.portName);
        sb.append("\n");
        sb.append("  Serial Speed: ");
        sb.append(this.serialSpeed);
        sb.append("\n");
        sb.append("====================================\n\n");
        return sb.toString();
    }
}

