/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Server;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ListResourceBundle;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseSet;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.API.Threads.SynchronizerListener;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.Conduit.DefaultConduit;
import org.jSyncManager.Server.RemoteManagementListener;

public class Server
extends UnicastRemoteObject
implements SynchronizerListener,
RemoteManagementListener {
    private Vector conduits = new Vector();
    private Thread[] threads;
    private Synchronizer[] synchronizers;
    private SLPTransportInterface[] transports;
    private boolean timeSync = false;
    private Properties props = new Properties();
    private boolean enableNetSync = false;
    private int netSyncListenerPort = 22373;
    private int NumNetSyncListeners = 8;
    public static final int NETSYNC_DEFAULT_PORT = 22373;
    public static final int NETSYNC_DEFAULT_NUMLISTENERS = 8;
    private LogPrintStream[] logStreams;
    private FileOutputStream fos = null;

    public Server() throws RemoteException {
        System.out.println("\njSyncManager Multiport Server " + Synchronizer.getVersion() + ".");
        System.out.println("Copyright (c) 1999, 2000 " + Synchronizer.author);
        System.out.println("============================================================\n");
        int numListeners = 0;
        FileInputStream fis = null;
        String userHome = System.getProperty("jsyncman.server.home");
        String seperator = System.getProperty("file.separator");
        if (userHome == null) {
            userHome = System.getProperty("user.home");
        }
        try {
            fis = new FileInputStream(userHome + seperator + "jsyncmanserver.properties");
        }
        catch (Exception e) {
            System.out.println("*** Properties file \"jsyncmanserver.properties\" not found in " + userHome);
            System.out.println("Please set the jsyncman.server.home property to point to the directory containing your server properties file,");
            System.out.println("or place a copy of your jsyncmanserver.properties file into " + userHome);
            System.exit(1);
        }
        try {
            this.props.load(fis);
        }
        catch (IOException e) {
            System.out.println("*** Unable to load the properties file!");
            System.out.println("The properties file has been found, but cannot be opened or parsed.");
            System.out.println("Please check that the file is not locked and in use by another process, and that it is correctly formatted.");
            System.exit(2);
        }
        try {
            numListeners = Integer.parseInt(this.props.getProperty("jsyncman.server.numListeners").trim());
            if (numListeners < 1) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.out.println("*** Property jsyncman.server.numListeners must be a positive integer value!");
            System.out.println("Please edit your jsyncmanserver.properties file to correct this fault.");
            System.exit(3);
        }
        String logFile = this.props.getProperty("jsyncman.server.logFile").trim();
        if (logFile != null && !logFile.toUpperCase().equals("CONSOLE")) {
            try {
                this.fos = new FileOutputStream(userHome + seperator + logFile);
            }
            catch (Exception e) {
                System.out.println("*** Unable to open the log file");
                System.out.println("The log file may be locked or in use.  The server will continue with logging disabled.");
                this.fos = null;
            }
        }
        this.transports = new SLPTransportInterface[numListeners];
        this.synchronizers = new Synchronizer[numListeners];
        this.threads = new Thread[numListeners];
        this.logStreams = new LogPrintStream[numListeners];
        int i = 0;
        while (i < numListeners) {
            this.configTransport(i);
            this.configSynchronizer(i);
            if (this.fos != null) {
                this.logStreams[i] = new LogPrintStream(this.fos, i);
            } else if (logFile != null && logFile.toUpperCase().equals("CONSOLE")) {
                this.logStreams[i] = new LogPrintStream(System.out, i);
            }
            if (this.logStreams[i] != null) {
                this.synchronizers[i].setLogStream(this.logStreams[i]);
            }
            this.threads[i] = new Thread(this.synchronizers[i]);
            ++i;
        }
        String timeSyncOpt = this.props.getProperty("jsyncman.server.timeSyncOption").trim();
        if (timeSyncOpt != null && timeSyncOpt.toLowerCase().equals("true")) {
            this.timeSync = true;
        }
        this.loadConduits(userHome + seperator);
    }

    private void configSynchronizer(int num) {
        try {
            int speed = Integer.parseInt(this.props.getProperty("jsyncman.server.speed." + num));
            this.synchronizers[num] = new Synchronizer(this.transports[num], this);
        }
        catch (Exception e) {
            System.out.println("*** Property \"jsyncman.server.speed." + num + "\" contains an invalid value.");
            System.out.println("Please make sure that the property is a positive integer and retry.");
            System.exit(7);
        }
    }

    private void configTransport(int num) {
        String type = this.props.getProperty("jsyncman.server.type." + num).trim().toLowerCase();
        try {
            this.transports[num] = (SLPTransportInterface)Class.forName("org.jSyncManager.Transport." + type).newInstance();
            this.transports[num].initialize(this.props, num);
        }
        catch (Exception e) {
            System.err.println("*** Caught exception initializing transport " + num + ".");
            System.err.println("The server encountered an exception while attempting to create a Transport.");
            System.err.println(this.transports[num].toString());
            System.out.println("   Exception: " + e.toString());
            System.exit(6);
        }
    }

    public synchronized void endOfSync(Synchronizer s) {
    }

    protected void finalize() throws Throwable {
    }

    public synchronized Vector getConduits(Synchronizer s) {
        return this.conduits;
    }

    public DefaultConduit getDefaultConduit(Synchronizer s) {
        return null;
    }

    public synchronized ListResourceBundle getLanguageBundle() {
        return null;
    }

    public synchronized DLPUserInfo getNewUserInfo(Synchronizer s) {
        return null;
    }

    public int getSyncType(Synchronizer s) {
        return 0;
    }

    private boolean hasPort(String type, String port) {
        return true;
    }

    private void loadConduits(String path) {
        try {
            FileInputStream fis2 = new FileInputStream(path + "jsyncmanserver.jconduits");
            InflaterInputStream inflaterinputstream = new InflaterInputStream(fis2);
            ObjectInputStream objectinputstream = new ObjectInputStream(inflaterinputstream);
            this.conduits = (Vector)objectinputstream.readObject();
            objectinputstream.close();
            inflaterinputstream.close();
            fis2.close();
        }
        catch (Exception ex) {
            this.conduits = new Vector();
        }
    }

    public static void main(String[] args) {
        String ourHostName;
        try {
            ourHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            ourHostName = null;
        }
        String rmiState = System.getProperty("jsyncman.server.noadmin");
        if (rmiState != null && rmiState.toLowerCase().equals("true")) {
            ourHostName = null;
        }
        if (ourHostName != null && System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            Server server = new Server();
            if (ourHostName != null) {
                String rmiName = new String("//" + ourHostName + "/JSyncManServer");
                Naming.rebind(rmiName, server);
            }
            server.startServer();
        }
        catch (RemoteException e) {
            System.out.println("Exception encountered starting server: \n" + e.toString());
            System.exit(99);
        }
        catch (MalformedURLException e1) {
            System.out.println("Exception encountered starting server: \n" + e1.toString());
            System.exit(99);
        }
    }

    public synchronized void midSync(Synchronizer s) {
    }

    private void printLineToLog(int syncNum, String x) {
        this.logStreams[syncNum].printlnToSuper("[" + syncNum + "] " + x);
    }

    public synchronized void processUser(DLPUserInfo userInfo, Synchronizer s) {
    }

    public synchronized void startOfSync(Synchronizer s) {
    }

    public void startServer() {
        System.out.print("Starting server...");
        int i = 0;
        while (i < this.threads.length) {
            this.threads[i].setDaemon(true);
            this.threads[i].start();
            ++i;
        }
        System.out.println("Done!");
    }

    public Boolean stopServer(String password) throws RemoteException {
        if (!password.toLowerCase().equals(this.props.getProperty("jsyncman.server.admin.password"))) {
            return new Boolean(false);
        }
        System.out.print("*** Received stop server request from remote administration client. \nShutting down...");
        int i = 0;
        while (i < this.threads.length) {
            try {
                this.synchronizers[i].stopSync();
                this.threads[i].interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        System.out.println("Done!");
        ExitThread et = new ExitThread();
        et.start();
        return new Boolean(true);
    }

    public synchronized boolean useTimeSync(Synchronizer s) {
        return this.timeSync;
    }

    public synchronized boolean validateUser(int userID, Synchronizer s) {
        return true;
    }

    public DLPDatabaseSet getRestoreDatabaseSet() {
        return null;
    }

    class ExitThread
    extends Thread {
        ExitThread() {
        }

        public void run() {
            try {
                System.out.print("*** Waiting 3 seconds...");
                ExitThread exitThread = this;
                synchronized (exitThread) {
                    this.wait(3000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Done!");
            System.exit(0);
        }
    }

    class LogPrintStream
    extends PrintWriter {
        int synchronizerNum;

        public LogPrintStream(OutputStream out, int syncNum) {
            super(out);
            this.synchronizerNum = syncNum;
        }

        public void println(String x) {
            Server.this.printLineToLog(this.synchronizerNum, x);
        }

        public void printlnToSuper(String x) {
            super.println(x);
        }
    }
}

