/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Conduit.TextDump;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.xml.parsers.ParserConfigurationException;
import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Conduit.ConduitHandlerException;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.Util.DLPBlock;
import org.jSyncManager.API.Protocol.Util.DLPRecord;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Protocol.Util.StdApps.AddressAppBlock;
import org.jSyncManager.API.Protocol.Util.StdApps.AddressDBXML;
import org.jSyncManager.API.Protocol.Util.StdApps.AddressRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.DateBookDBXML;
import org.jSyncManager.API.Protocol.Util.StdApps.DateBookRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.ExpenseRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.MailRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.MemoDBXML;
import org.jSyncManager.API.Protocol.Util.StdApps.MemoRecord;
import org.jSyncManager.API.Protocol.Util.StdApps.ToDoListDBXML;
import org.jSyncManager.API.Protocol.Util.StdApps.ToDoListRecord;
import org.jSyncManager.API.Threads.Synchronizer;
import org.xml.sax.SAXException;

public class TextDump
extends AbstractConduit {
    protected transient JCheckBox toHRF_CB = null;
    protected transient JCheckBox toCSV_CB = null;
    protected transient JCheckBox toXML_CB = null;
    protected transient JCheckBox toHex_CB = null;
    protected transient JCheckBox clean_CB = null;
    protected transient JCheckBox showDeleted_CB = null;
    protected transient JCheckBox showArchived_CB = null;
    protected transient JCheckBox dirtyOnly_CB = null;
    protected transient JCheckBox includeSecret_CB = null;
    protected transient JCheckBox resetDirty_CB = null;
    protected transient JList databaseList = null;
    protected transient JPanel dumpTypePanel = null;
    protected transient JPanel listPanel = null;
    protected transient JPanel optionsPanel = null;
    protected transient TitledBorder dumpPanelBorder = null;
    protected transient TitledBorder listPanelBorder = null;
    protected transient TitledBorder optionsPanelBorder = null;
    protected transient FileWriter hrffos = null;
    protected transient PrintWriter hrfdos = null;
    protected transient FileWriter csvfos = null;
    protected transient PrintWriter csvdos = null;
    protected transient FileWriter xmlfos = null;
    protected transient OutputStreamWriter xmldos = null;
    protected transient FileWriter hexfos = null;
    protected transient PrintWriter hexdos = null;
    public static final String DUMP_DIRNAME = "TextDump";
    protected static String[] databases = new String[]{"AddressDB", "DatebookDB", "ExpenseDB", "MailDB", "MemoDB", "ToDoDB"};
    private transient boolean xmlheader = true;
    private transient boolean xmltrailer = false;
    private transient AddressDBXML addressxml = null;
    private transient DateBookDBXML datebookxml = null;
    private transient ToDoListDBXML todolistxml = null;
    private transient MemoDBXML memoxml = null;

    public TextDump() {
        try {
            this.addressxml = new AddressDBXML();
            this.datebookxml = new DateBookDBXML();
            this.todolistxml = new ToDoListDBXML();
            this.memoxml = new MemoDBXML();
        }
        catch (ParserConfigurationException exc) {
            exc.printStackTrace(System.err);
        }
        catch (SAXException exc) {
            exc.printStackTrace(System.err);
        }
    }

    public void startSync(ConduitHandler conduitHandler, DLPUserInfo user) throws NotConnectedException {
        Object[] databases = this.databaseList.getSelectedValues();
        AddressAppBlock addrAppBlock = null;
        DLPRecord dlpRec = null;
        byte dbHandle = 0;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        new File(Synchronizer.getHomeDirectory() + System.getProperty("file.separator") + DUMP_DIRNAME).mkdirs();
        int x = 0;
        while (x < databases.length) {
            try {
                dlpRec = null;
                conduitHandler.postToLog("\n");
                conduitHandler.setStatus("Dumping " + (String)databases[x]);
                this.openStreams((String)databases[x]);
                byte mode = -128;
                if (this.clean_CB.isSelected()) {
                    mode = (byte)(mode | 0x40);
                }
                if (this.includeSecret_CB.isSelected()) {
                    mode = (byte)(mode | 0x10);
                }
                dbHandle = conduitHandler.openDatabase((String)databases[x], mode);
                conduitHandler.openConduit();
                int count = conduitHandler.getOpenDatabaseInfo(dbHandle);
                conduitHandler.postToLog("Database claims " + count + " records.");
                DLPBlock appBlock = conduitHandler.getApplicationBlock(dbHandle);
                int pos = this.getDBNamePos((String)databases[x]);
                if (pos == 0) {
                    addrAppBlock = new AddressAppBlock(appBlock);
                }
                if (this.toXML_CB.isSelected()) {
                    this.xmlheader = true;
                }
                int i = 0;
                while (i < count) {
                    dlpRec = conduitHandler.readRecordByIndex(dbHandle, (char)i);
                    if (i == count - 1) {
                        this.xmltrailer = true;
                    }
                    switch (pos) {
                        case 0: {
                            AddressRecord addrRec = new AddressRecord(dlpRec);
                            this.writeRecord(addrRec, dlpRec);
                            break;
                        }
                        case 1: {
                            DateBookRecord dbRec = new DateBookRecord(dlpRec);
                            this.writeRecord(dbRec, dlpRec);
                            break;
                        }
                        case 2: {
                            ExpenseRecord expRec = new ExpenseRecord(dlpRec);
                            this.writeRecord(expRec, dlpRec);
                            break;
                        }
                        case 3: {
                            MailRecord mailRec = new MailRecord(dlpRec);
                            this.writeRecord(mailRec, dlpRec);
                            break;
                        }
                        case 4: {
                            MemoRecord memoRec = new MemoRecord(dlpRec);
                            this.writeRecord(memoRec, dlpRec);
                            break;
                        }
                        case 5: {
                            ToDoListRecord todoRec = new ToDoListRecord(dlpRec);
                            this.writeRecord(todoRec, dlpRec);
                            break;
                        }
                    }
                    ++i;
                }
                switch (pos) {
                    case 0: {
                        if (this.addressxml == null) break;
                        this.addressxml.writeDocument(this.xmldos);
                        break;
                    }
                    case 1: {
                        if (this.datebookxml == null) break;
                        this.datebookxml.writeDocument(this.xmldos);
                        break;
                    }
                    case 4: {
                        if (this.memoxml == null) break;
                        this.memoxml.writeDocument(this.xmldos);
                        break;
                    }
                    case 5: {
                        if (this.todolistxml == null) break;
                        this.todolistxml.writeDocument(this.xmldos);
                    }
                }
                this.closeStreams();
                if (this.clean_CB.isSelected()) {
                    conduitHandler.cleanupDatabase(dbHandle);
                }
                if (this.resetDirty_CB.isSelected()) {
                    conduitHandler.resetSyncFlags(dbHandle);
                }
                conduitHandler.closeDatabase(dbHandle);
            }
            catch (ConduitHandlerException e) {
                conduitHandler.postToLog("\n1> Caught exception: " + e.toString());
                if (dlpRec != null) {
                    conduitHandler.postToLog("Failed on record: \n" + dlpRec.toString() + "\n");
                    conduitHandler.postToLog("Record size: " + dlpRec.getData().length + "\n\n");
                    e.printStackTrace();
                }
                try {
                    conduitHandler.closeDatabase(dbHandle);
                }
                catch (Exception e1) {}
            }
            catch (Throwable e) {
                e.printStackTrace(pw);
                conduitHandler.postToLog("\nTextDump 2>Caught exception: " + e.toString());
                conduitHandler.postToLog(sw.toString());
                if (dlpRec != null) {
                    conduitHandler.postToLog("Failed on record: \n" + dlpRec.toString() + "\n");
                    conduitHandler.postToLog("Record size: " + dlpRec.getData().length + "\n\n");
                    e.printStackTrace();
                }
                try {
                    conduitHandler.closeDatabase(dbHandle);
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            ++x;
        }
        try {
            pw.close();
            sw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected String getResourceBundleName() {
        return "org.jSyncManager.Conduit.Resources.Text.TextDumpConduitResources";
    }

    protected JPanel constructConfigPanel() {
        JPanel ret = new JPanel();
        JLabel dirLabel = new JLabel(this.getConduitResourceBundle().getString("textdump.dirlabel"));
        JTextField dirField = new JTextField(Synchronizer.getHomeDirectory());
        this.toHRF_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.tohrf"));
        this.toCSV_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.tocsv"));
        this.toXML_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.toxml"));
        this.toHex_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.tohex"));
        this.clean_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.cleanupdb"));
        this.showDeleted_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.dumpdeleted"));
        this.showArchived_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.dumparchived"));
        this.dirtyOnly_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.dirtyonly"));
        this.includeSecret_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.incsecret"));
        this.resetDirty_CB = new JCheckBox(this.getConduitResourceBundle().getString("textdump.resetdirty"));
        this.dumpTypePanel = new JPanel();
        this.listPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.dumpPanelBorder = BorderFactory.createTitledBorder(this.getConduitResourceBundle().getString("textdump.dumpPanelBorder"));
        this.listPanelBorder = BorderFactory.createTitledBorder(this.getConduitResourceBundle().getString("textdump.listPanelBorder"));
        this.optionsPanelBorder = BorderFactory.createTitledBorder(this.getConduitResourceBundle().getString("textdump.optionsPanelBorder"));
        this.dumpTypePanel.setBorder(this.dumpPanelBorder);
        this.listPanel.setBorder(this.listPanelBorder);
        this.optionsPanel.setBorder(this.optionsPanelBorder);
        this.databaseList = new JList<String>(databases);
        this.dumpTypePanel.setLayout(new GridLayout(0, 1));
        this.optionsPanel.setLayout(new GridLayout(0, 1));
        this.listPanel.setLayout(new BorderLayout());
        ret.setLayout(new BorderLayout());
        dirField.setEditable(false);
        this.toCSV_CB.setEnabled(false);
        this.dumpTypePanel.add(this.toHRF_CB);
        this.dumpTypePanel.add(this.toCSV_CB);
        this.dumpTypePanel.add(this.toXML_CB);
        this.dumpTypePanel.add(this.toHex_CB);
        this.optionsPanel.add(this.showDeleted_CB);
        this.optionsPanel.add(this.showArchived_CB);
        this.optionsPanel.add(this.dirtyOnly_CB);
        this.optionsPanel.add(this.includeSecret_CB);
        this.optionsPanel.add(this.clean_CB);
        this.optionsPanel.add(this.resetDirty_CB);
        this.optionsPanel.add(dirLabel);
        this.optionsPanel.add(dirField);
        this.listPanel.add((Component)this.databaseList, "Center");
        ret.add((Component)this.dumpTypePanel, "Center");
        ret.add((Component)this.listPanel, "East");
        ret.add((Component)this.optionsPanel, "South");
        return ret;
    }

    protected void writeRecord(DLPRecord record, DLPRecord rawRecord) {
        String seperator = "-----------------------------------------------------------------------------\n";
        if (rawRecord.checkAttribute((byte)-128) && !this.showDeleted_CB.isSelected() || rawRecord.checkAttribute((byte)8) && !this.showArchived_CB.isSelected()) {
            return;
        }
        if (this.dirtyOnly_CB.isSelected() && !rawRecord.checkAttribute((byte)64)) {
            return;
        }
        try {
            if (this.toHRF_CB.isSelected()) {
                this.hrfdos.println(seperator);
                this.hrfdos.println(record.toString());
                this.hrfdos.flush();
            }
        }
        catch (Throwable e) {
            this.hrfdos.println(e.toString() + "\n");
            e.printStackTrace(this.hrfdos);
        }
        if (this.toCSV_CB.isSelected()) {
            // empty if block
        }
        try {
            if (this.toXML_CB.isSelected()) {
                if (record.getClass().getName().endsWith("AddressRecord")) {
                    if (this.addressxml == null) {
                        this.addressxml = new AddressDBXML();
                    }
                    this.addressxml.insertRecord((AddressRecord)record);
                }
                if (record.getClass().getName().endsWith("MemoRecord")) {
                    if (this.memoxml == null) {
                        this.memoxml = new MemoDBXML();
                    }
                    this.memoxml.insertRecord((MemoRecord)record);
                }
                if (record.getClass().getName().endsWith("DateBookRecord")) {
                    if (this.datebookxml == null) {
                        this.datebookxml = new DateBookDBXML();
                    }
                    this.datebookxml.insertRecord((DateBookRecord)record);
                }
                if (record.getClass().getName().endsWith("ToDoListRecord")) {
                    if (this.todolistxml == null) {
                        this.todolistxml = new ToDoListDBXML();
                    }
                    this.todolistxml.insertRecord((ToDoListRecord)record);
                }
                this.xmldos.flush();
            }
        }
        catch (Throwable e) {
            try {
                this.xmldos.write(e.toString() + "\n");
            }
            catch (IOException exc) {
                // empty catch block
            }
            e.printStackTrace(new PrintWriter(this.xmldos));
        }
        try {
            if (this.toHex_CB.isSelected()) {
                this.hexdos.println(seperator);
                this.hexdos.println(rawRecord.toString());
                this.hexdos.flush();
            }
        }
        catch (Throwable e) {
            this.hexdos.println(e.toString() + "\n");
            e.printStackTrace(this.hexdos);
        }
    }

    protected void openStreams(String rootName) throws IOException {
        String s1 = System.getProperty("file.separator");
        if (this.toHRF_CB.isSelected()) {
            this.hrffos = new FileWriter(Synchronizer.getHomeDirectory() + s1 + DUMP_DIRNAME + s1 + rootName + ".TXT");
            this.hrfdos = new PrintWriter(this.hrffos);
        }
        if (this.toCSV_CB.isSelected()) {
            this.csvfos = new FileWriter(Synchronizer.getHomeDirectory() + s1 + DUMP_DIRNAME + s1 + rootName + ".CSV");
            this.csvdos = new PrintWriter(this.csvfos);
        }
        if (this.toXML_CB.isSelected()) {
            this.xmlfos = new FileWriter(Synchronizer.getHomeDirectory() + s1 + DUMP_DIRNAME + s1 + rootName + ".XML");
            this.xmldos = new OutputStreamWriter(new FileOutputStream(Synchronizer.getHomeDirectory() + s1 + DUMP_DIRNAME + s1 + rootName + ".XML"));
        }
        if (this.toHex_CB.isSelected()) {
            this.hexfos = new FileWriter(Synchronizer.getHomeDirectory() + s1 + DUMP_DIRNAME + s1 + rootName + ".HEX");
            this.hexdos = new PrintWriter(this.hexfos);
        }
    }

    protected void openStreams(OutputStreamWriter out) throws FileNotFoundException {
        if (this.toHRF_CB.isSelected()) {
            this.hrfdos = new PrintWriter(out);
        }
        if (this.toCSV_CB.isSelected()) {
            this.csvdos = new PrintWriter(out);
        }
        if (this.toXML_CB.isSelected()) {
            this.xmldos = out;
        }
        if (this.toHex_CB.isSelected()) {
            this.hexdos = new PrintWriter(out);
        }
    }

    protected void closeStreams() throws IOException {
        if (this.toHRF_CB.isSelected()) {
            this.hrfdos.close();
            this.hrfdos = null;
        }
        if (this.toCSV_CB.isSelected()) {
            this.csvdos.close();
            this.csvdos = null;
        }
        if (this.toXML_CB.isSelected()) {
            this.xmldos.close();
            this.xmldos = null;
        }
        if (this.toHex_CB.isSelected()) {
            this.hexdos.flush();
            this.hexdos.close();
            this.hexdos = null;
        }
    }

    private int getDBNamePos(String dbName) {
        int i = 0;
        while (i < databases.length) {
            if (databases[i].equals(dbName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

