/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Conduit.Installer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jSyncManager.API.Conduit.AbstractInstaller;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Conduit.ConduitHandlerException;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Protocol.Util.DatabaseFormatException;

public class Installer
extends AbstractInstaller
implements ActionListener {
    private Vector dbList = new Vector();
    private transient JButton addFromDisk = null;
    private transient JButton addFromURL = null;
    private transient JButton removeDB = null;
    private transient JList dblist = null;
    private transient DefaultListModel dlm = null;
    private transient JDialog loadFromURLDlg = null;
    private transient JButton urlOkButton = null;
    private transient JButton urlCancelButton = null;
    private transient JTextField urlEntryField = null;
    private transient DatabaseFileFilter dbFileFilter = null;

    private void addDBFromFile(File file) {
        try {
            DLPDatabase dlpdatabase = DLPDatabase.importFromFile(file);
            this.dbList.addElement(dlpdatabase);
            this.dlm.addElement(dlpdatabase.getDatabaseInfo().getName());
        }
        catch (DatabaseFormatException databaseformatexception) {
            System.out.println(this.getConduitResourceBundle().getString("installer.dbopenerror") + databaseformatexception.toString());
        }
    }

    private void addDBFromURL(URL url) {
        try {
            DLPDatabase dlpdatabase = DLPDatabase.importFromURL(url);
            this.dbList.addElement(dlpdatabase);
            this.dlm.addElement(dlpdatabase.getDatabaseInfo().getName());
        }
        catch (DatabaseFormatException databaseformatexception) {
            System.out.println(this.getConduitResourceBundle().getString("installer.dbopenerror") + databaseformatexception.toString());
        }
    }

    public byte getPriority() {
        return -127;
    }

    public void removeDatabase(String s) {
        int i = 0;
        while (i < this.dbList.size()) {
            if (((DLPDatabase)this.dbList.elementAt(i)).getDatabaseInfo().getName().equals(s)) {
                this.dbList.removeElementAt(i);
            }
            ++i;
        }
    }

    protected String getResourceBundleName() {
        return "org.jSyncManager.Conduit.Resources.Text.InstallerConduitResources";
    }

    protected JPanel constructConfigPanel() {
        JPanel ret = null;
        JLabel topLabel = null;
        JScrollPane scrollPane = null;
        JPanel buttonPanel = null;
        ret = new JPanel();
        topLabel = new JLabel(this.getConduitResourceBundle().getString("installer.toplabel"));
        this.dlm = new DefaultListModel();
        this.dblist = new JList(this.dlm);
        scrollPane = new JScrollPane(this.dblist);
        buttonPanel = new JPanel();
        this.addFromDisk = new JButton(this.getConduitResourceBundle().getString("installer.addfromdisk"));
        this.addFromURL = new JButton(this.getConduitResourceBundle().getString("installer.addfromURL"));
        this.removeDB = new JButton(this.getConduitResourceBundle().getString("installer.removedb"));
        ret.setLayout(new BorderLayout());
        buttonPanel.setLayout(new FlowLayout());
        this.addFromDisk.addActionListener(this);
        this.addFromURL.addActionListener(this);
        this.removeDB.addActionListener(this);
        buttonPanel.add(this.addFromDisk);
        buttonPanel.add(this.addFromURL);
        buttonPanel.add(this.removeDB);
        ret.add((Component)topLabel, "North");
        ret.add((Component)scrollPane, "Center");
        ret.add((Component)buttonPanel, "South");
        return ret;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addFromDisk) {
            JFileChooser chooser = new JFileChooser();
            if (this.dbFileFilter == null) {
                this.dbFileFilter = new DatabaseFileFilter();
            }
            chooser.setFileFilter(this.dbFileFilter);
            int ret_val = chooser.showOpenDialog(this.getConfigurationPanel());
            if (ret_val == 0) {
                File selected = chooser.getSelectedFile();
                this.addDBFromFile(chooser.getSelectedFile());
            }
            return;
        }
        if (source == this.addFromURL) {
            ((Component)this.getLoadFromURLDialog()).setVisible(true);
            return;
        }
        if (source == this.removeDB) {
            int index = this.dblist.getSelectedIndex();
            if (index == -1) {
                return;
            }
            String dbname = (String)this.dlm.getElementAt(index);
            this.dlm.remove(index);
            this.removeDatabase(dbname);
            return;
        }
        if (source == this.urlOkButton) {
            try {
                this.addDBFromURL(new URL(this.urlEntryField.getText()));
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                ((Component)this.getLoadFromURLDialog()).setVisible(false);
                throw throwable;
            }
        }
        if (source == this.urlCancelButton) {
            ((Component)this.getLoadFromURLDialog()).setVisible(false);
            return;
        }
    }

    private JDialog getLoadFromURLDialog() {
        if (this.loadFromURLDlg == null) {
            this.urlOkButton = new JButton(this.getConduitResourceBundle().getString("installer.urldlg.okbtn"));
            this.urlCancelButton = new JButton(this.getConduitResourceBundle().getString("installer.urldlg.cancelbtn"));
            JLabel urlLabel = new JLabel(this.getConduitResourceBundle().getString("installer.urldlg.label"));
            this.urlEntryField = new JTextField();
            this.loadFromURLDlg = new JDialog();
            this.loadFromURLDlg.setLocationRelativeTo(this.getConfigurationPanel());
            this.loadFromURLDlg.setTitle(this.getConduitResourceBundle().getString("installer.urldlg.title"));
            JPanel btnPane = new JPanel();
            btnPane.setLayout(new FlowLayout());
            btnPane.add(this.urlOkButton);
            btnPane.add(this.urlCancelButton);
            this.urlOkButton.addActionListener(this);
            this.urlCancelButton.addActionListener(this);
            this.loadFromURLDlg.getContentPane().setLayout(new BorderLayout());
            this.loadFromURLDlg.getContentPane().add((Component)urlLabel, "North");
            this.loadFromURLDlg.getContentPane().add((Component)this.urlEntryField, "Center");
            this.loadFromURLDlg.getContentPane().add((Component)btnPane, "South");
            this.loadFromURLDlg.pack();
        }
        return this.loadFromURLDlg;
    }

    protected boolean isDatabaseInstallAllowed(DLPDatabase db, ConduitHandler handler, DLPUserInfo user) {
        return true;
    }

    protected void clearDatabaseList() {
        this.dbList.removeAllElements();
    }

    protected void installingDatabase(DLPDatabase db, ConduitHandler handler) {
        handler.setStatus(this.getConduitResourceBundle().getString("installer.writingdb") + db.getDatabaseInfo().getName());
    }

    protected void skippingDatabase(DLPDatabase db, ConduitHandler handler) {
    }

    protected void exceptionInstallingDatabase(DLPDatabase db, ConduitHandler handler, ConduitHandlerException e) {
        handler.postToLog(this.getConduitResourceBundle().getString("installer.instdberror") + e.toString());
    }

    protected DLPDatabase[] getDatabaseList() {
        DLPDatabase[] dbArray = new DLPDatabase[this.dbList.size()];
        int i = 0;
        while (i < this.dbList.size()) {
            dbArray[i] = (DLPDatabase)this.dbList.elementAt(i);
            ++i;
        }
        return dbArray;
    }

    private String getChooserDescription() {
        return this.getConduitResourceBundle().getString("installer.chooser.description");
    }

    class DatabaseFileFilter
    extends FileFilter {
        DatabaseFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().toUpperCase().endsWith("PRC") || file.getName().toUpperCase().endsWith("PDB") || file.isDirectory();
        }

        public String getDescription() {
            return Installer.this.getChooserDescription();
        }
    }
}

