/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Conduit;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import javax.swing.JPanel;
import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitHandler;
import org.jSyncManager.API.Conduit.ConduitHandlerException;
import org.jSyncManager.API.Protocol.NotConnectedException;
import org.jSyncManager.API.Protocol.Util.DLPDatabase;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseInfo;
import org.jSyncManager.API.Protocol.Util.DLPDatabaseSet;
import org.jSyncManager.API.Protocol.Util.DLPUserInfo;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.Client.LegacyClient.RestoreDBVerifyDlg;

public class DefaultConduit
extends AbstractConduit {
    private RestoreDBVerifyDlg RestoreDlg = new RestoreDBVerifyDlg();

    protected String getResourceBundleName() {
        return "org.jSyncManager.Conduit.Resources.Text.DefaultConduitResources";
    }

    private void restoreDatabase(ConduitHandler conduithandler, DLPDatabase dlpdatabase) throws ConduitHandlerException, NotConnectedException {
        conduithandler.setStatus("Restoring Database: " + dlpdatabase.getDatabaseInfo().getName());
        conduithandler.writeDatabase(dlpdatabase);
    }

    protected JPanel constructConfigPanel() {
        return null;
    }

    public void startSync(ConduitHandler conduithandler, DLPUserInfo user) throws NotConnectedException {
        DLPDatabaseSet dlpdatabaseset;
        String s2;
        Vector vector = conduithandler.getDatabaseInfoList();
        boolean flag = false;
        String s = Synchronizer.getHomeDirectory();
        String s1 = System.getProperty("file.separator");
        try {
            s2 = user.getUserName().replace(' ', '_');
        }
        catch (NullPointerException ex) {
            s2 = "jSyncMan";
        }
        conduithandler.startTickles();
        try {
            dlpdatabaseset = new DLPDatabaseSet(s + s1 + s2 + ".data");
        }
        catch (Throwable ex) {
            dlpdatabaseset = new DLPDatabaseSet();
        }
        conduithandler.stopTickles();
        try {
            int i = 0;
            while (i < dlpdatabaseset.databaseCount()) {
                try {
                    if (!conduithandler.hasDatabase(dlpdatabaseset.getDatabase(i).getDatabaseInfo().getName()) || dlpdatabaseset.getDatabase(i).getDatabaseInfo().getModificationNumber() > conduithandler.getDatabaseInfo(dlpdatabaseset.getDatabase(i).getDatabaseInfo().getName()).getModificationNumber()) {
                        if (!flag) {
                            conduithandler.startTickles();
                            this.RestoreDlg.show(dlpdatabaseset.getDatabase(i).getDatabaseInfo().getName());
                            conduithandler.stopTickles();
                            switch (this.RestoreDlg.getResultCode()) {
                                case 1: {
                                    this.restoreDatabase(conduithandler, dlpdatabaseset.getDatabase(i));
                                    break;
                                }
                                case 3: {
                                    flag = true;
                                    this.restoreDatabase(conduithandler, dlpdatabaseset.getDatabase(i));
                                    break;
                                }
                                case 4: {
                                    dlpdatabaseset.removeDatabase(i);
                                }
                            }
                        } else {
                            this.restoreDatabase(conduithandler, dlpdatabaseset.getDatabase(i));
                        }
                    }
                }
                catch (ConduitHandlerException ex) {
                    conduithandler.postToLog("Caught ConduitHandler exception: " + ex.toString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            conduithandler.postToLog("DefaultConduit> Caught exception at end of 1: " + e.toString());
            e.printStackTrace(pw);
            conduithandler.postToLog(sw.toString());
            try {
                pw.close();
                sw.close();
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        int j = 0;
        while (j < vector.size()) {
            if (((DLPDatabaseInfo)vector.elementAt(j)).checkDatabaseFlag('\b')) {
                try {
                    if (!dlpdatabaseset.hasDatabase(((DLPDatabaseInfo)vector.elementAt(j)).getName()) || dlpdatabaseset.getDatabaseInfo(((DLPDatabaseInfo)vector.elementAt(j)).getName()).getModificationNumber() < ((DLPDatabaseInfo)vector.elementAt(j)).getModificationNumber()) {
                        if (dlpdatabaseset.hasDatabase(((DLPDatabaseInfo)vector.elementAt(j)).getName())) {
                            dlpdatabaseset.removeDatabase(((DLPDatabaseInfo)vector.elementAt(j)).getName());
                        }
                        conduithandler.postToLog("Backing up database " + ((DLPDatabaseInfo)vector.elementAt(j)).getName());
                        dlpdatabaseset.addDatabase(conduithandler.readDatabase(((DLPDatabaseInfo)vector.elementAt(j)).getName()));
                    }
                }
                catch (ConduitHandlerException ex) {
                    conduithandler.postToLog("6> Caught ConduitHandler exception: " + ex.toString());
                }
            }
            ++j;
        }
        try {
            dlpdatabaseset.writeToFile(s + s1 + s2 + ".data");
        }
        catch (Exception ex) {
            conduithandler.postToLog("Write failed: " + ex.toString());
            return;
        }
    }
}

