/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client;

import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.jSyncManager.API.Conduit.AbstractConduit;
import org.jSyncManager.API.Conduit.ConduitNotFoundException;
import org.jSyncManager.API.Threads.Synchronizer;
import org.jSyncManager.API.Transport.SLPTransportInterface;
import org.jSyncManager.Conduit.DefaultConduit;
import org.jSyncManager.Transport.ModemTransport;

public final class RegistrationData
implements Serializable {
    private String userName = null;
    private int userID = 0;
    private boolean disablePopups = false;
    private boolean manualHide = false;
    private transient Vector conduits = new Vector();
    private Rectangle windowPosition = null;
    private boolean syncTimeOption = false;
    private DefaultConduit defaultConduit = new DefaultConduit();
    private int[] allowedIDs = new int[64];
    private boolean securityEnabled = false;
    private int numAllowedIDs = 0;
    private boolean configured = false;
    private boolean useFrameFlag = false;
    private SLPTransportInterface transport = null;

    protected void finalize() throws Throwable {
        String s = Synchronizer.getHomeDirectory();
        String s1 = System.getProperty("file.separator");
        FileOutputStream fileoutputstream = new FileOutputStream(s + s1 + "jsyncman.prefs");
        DeflaterOutputStream deflateroutputstream = new DeflaterOutputStream(fileoutputstream);
        ObjectOutputStream objectoutputstream = new ObjectOutputStream(fileoutputstream);
        objectoutputstream.writeObject(this);
        objectoutputstream.flush();
        deflateroutputstream.close();
        fileoutputstream.close();
        super.finalize();
    }

    public int[] getAllowedIDs() {
        return this.allowedIDs;
    }

    public AbstractConduit getConduit(int i) {
        return (AbstractConduit)this.getConduits().elementAt(i);
    }

    public AbstractConduit getConduit(String s) throws ConduitNotFoundException {
        int i = 0;
        while (i < this.getConduits().size()) {
            if (s.equals(((AbstractConduit)this.getConduits().elementAt(i)).getConduitName())) {
                return (AbstractConduit)this.getConduits().elementAt(i);
            }
            ++i;
        }
        throw new ConduitNotFoundException("Conduit \"" + s + "\" not found.");
    }

    public int getConduitCount() {
        return this.getConduits().size();
    }

    public synchronized Vector getConduits() {
        return this.conduits;
    }

    public DefaultConduit getDefaultConduit() {
        return this.defaultConduit;
    }

    public boolean getDisablePopups() {
        return this.disablePopups;
    }

    public boolean getManualHide() {
        return this.manualHide;
    }

    public boolean getModemFlag() {
        return this.transport instanceof ModemTransport;
    }

    public int getNumAllowedIDs() {
        return this.numAllowedIDs;
    }

    public boolean getSecurityEnabled() {
        return this.securityEnabled;
    }

    public boolean getSyncTimeOption() {
        return this.syncTimeOption;
    }

    public Rectangle getWindowPosition() {
        return this.windowPosition;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public static RegistrationData loadRegistrationData() {
        ObjectInputStream objectinputstream;
        InflaterInputStream inflaterinputstream;
        RegistrationData registrationdata = null;
        String s = Synchronizer.getHomeDirectory();
        String s1 = System.getProperty("file.separator");
        try {
            FileInputStream fis1 = new FileInputStream(s + s1 + "jsyncman.prefs");
            inflaterinputstream = new InflaterInputStream(fis1);
            objectinputstream = new ObjectInputStream(inflaterinputstream);
            registrationdata = (RegistrationData)objectinputstream.readObject();
            objectinputstream.close();
            inflaterinputstream.close();
            fis1.close();
        }
        catch (Exception ex) {
            registrationdata = new RegistrationData();
        }
        try {
            FileInputStream fis2 = new FileInputStream(s + s1 + "jsyncman.jconduits");
            inflaterinputstream = new InflaterInputStream(fis2);
            objectinputstream = new ObjectInputStream(inflaterinputstream);
            registrationdata.conduits = (Vector)objectinputstream.readObject();
            objectinputstream.close();
            inflaterinputstream.close();
            fis2.close();
        }
        catch (Exception ex) {
            registrationdata.conduits = new Vector();
        }
        return registrationdata;
    }

    public void registerConduit(AbstractConduit conduit) {
        this.conduits.addElement(conduit);
    }

    public void removeConduit(int i) {
        this.conduits.removeElementAt(i);
    }

    public void removeConduit(AbstractConduit conduit) {
        this.conduits.removeElement(conduit);
    }

    public void saveSettings() throws Exception {
        this.configured = true;
        String s = Synchronizer.getHomeDirectory();
        String s1 = System.getProperty("file.separator");
        FileOutputStream fis1 = new FileOutputStream(s + s1 + "jsyncman.prefs");
        DeflaterOutputStream deflateroutputstream = new DeflaterOutputStream(fis1);
        ObjectOutputStream objectoutputstream = new ObjectOutputStream(deflateroutputstream);
        objectoutputstream.writeObject(this);
        objectoutputstream.flush();
        deflateroutputstream.close();
        fis1.close();
        FileOutputStream fis2 = new FileOutputStream(s + s1 + "jsyncman.jconduits");
        deflateroutputstream = new DeflaterOutputStream(fis2);
        objectoutputstream = new ObjectOutputStream(deflateroutputstream);
        objectoutputstream.writeObject(this.conduits);
        objectoutputstream.flush();
        deflateroutputstream.close();
        fis2.close();
    }

    public void setAllowedIDs(int[] ai) {
        this.allowedIDs = ai;
        this.setNumAllowedIDs(ai.length);
    }

    public void setDisablePopups(boolean flag) {
        this.disablePopups = flag;
    }

    public void setFrameFlag(boolean b) {
        this.useFrameFlag = b;
    }

    public void setManualHide(boolean flag) {
        this.manualHide = flag;
    }

    private void setNumAllowedIDs(int i) {
        this.numAllowedIDs = i;
    }

    public void setSecurityEnabled(boolean flag) {
        this.securityEnabled = flag;
    }

    public void setSyncTimeOption(boolean flag) {
        this.syncTimeOption = flag;
    }

    public void setWindowPosition(Rectangle rectangle) {
        this.windowPosition = rectangle;
    }

    public boolean useFrame() {
        return this.useFrameFlag;
    }

    public SLPTransportInterface getTransport() {
        return this.transport;
    }

    public void setTransport(SLPTransportInterface t) {
        this.transport = t;
    }
}

