/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ResourceBundle;
import org.jSyncManager.Client.LegacyClient.ImageCanvas;

public class SyncPanel
extends Panel {
    private Label ivjConnectingLabel = null;
    private Label ivjDoneLabel = null;
    private Panel ivjDoSyncCanvas = null;
    private Panel ivjEndSyncCanvas = null;
    private Button ivjHideButton = null;
    private TextField ivjInfoChoice = null;
    private Panel ivjInfoPanel = null;
    private Panel ivjMainPanel = null;
    private Panel ivjStartSyncCanvas = null;
    private Label ivjSyncLabel = null;
    private static ResourceBundle resStrings = ResourceBundle.getBundle("org.jSyncManager.Client.LegacyClient.Resources.Text.JSyncManLegacyClientResources");
    private ImageCanvas ivjConnDimCanvas = null;
    private ImageCanvas ivjConnNormalCanvas = null;
    private ImageCanvas ivjDoneDimCanvas = null;
    private ImageCanvas ivjDoneNormalCanvas = null;
    private ImageCanvas ivjSyncDimCanvas = null;
    private ImageCanvas ivjSyncNormalCanvas = null;
    private Image syncStartDim = null;
    private Image syncStartNormal = null;
    private Image syncSyncDim = null;
    private Image syncSyncNormal = null;
    private Image syncDoneDim = null;
    private Image syncDoneNormal = null;
    private MediaTracker mt = new MediaTracker(this);

    public SyncPanel() {
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.getHideButton()) {
            this.connEtoM1(actionevent);
        }
    }

    private void connEtoM1(ActionEvent actionevent) {
        try {
            this.setVisible(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private ImageCanvas getConnDimCanvas() {
        if (this.ivjConnDimCanvas == null) {
            try {
                this.ivjConnDimCanvas = new ImageCanvas();
                this.ivjConnDimCanvas.setName("ConnDimCanvas");
                try {
                    URL resURL = this.getClass().getResource("Resources/Images/start-dim.gif");
                    if (resURL == null) {
                        return this.ivjConnDimCanvas;
                    }
                    this.syncStartDim = Toolkit.getDefaultToolkit().getImage(resURL);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.mt.addImage(this.syncStartDim, 0);
                this.mt.waitForAll();
                this.ivjConnDimCanvas.setImage(this.syncStartDim);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConnDimCanvas;
    }

    private Label getConnectingLabel() {
        if (this.ivjConnectingLabel == null) {
            try {
                this.ivjConnectingLabel = new Label();
                this.ivjConnectingLabel.setName("ConnectingLabel");
                this.ivjConnectingLabel.setAlignment(1);
                this.ivjConnectingLabel.setText(resStrings.getString("syncConnectingString"));
                this.ivjConnectingLabel.setEnabled(true);
                this.ivjConnectingLabel.setForeground(Color.darkGray);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjConnectingLabel;
    }

    private ImageCanvas getConnNormalCanvas() {
        if (this.ivjConnNormalCanvas == null) {
            try {
                this.ivjConnNormalCanvas = new ImageCanvas();
                this.ivjConnNormalCanvas.setName("ConnNormalCanvas");
                URL resURL = this.getClass().getResource("Resources/Images/start.gif");
                if (resURL == null) {
                    return this.ivjConnNormalCanvas;
                }
                this.syncStartNormal = Toolkit.getDefaultToolkit().getImage(resURL);
                this.mt.addImage(this.syncStartNormal, 0);
                this.ivjConnNormalCanvas.setImage(this.syncStartNormal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjConnNormalCanvas;
    }

    private ImageCanvas getDoneDimCanvas() {
        if (this.ivjDoneDimCanvas == null) {
            try {
                this.ivjDoneDimCanvas = new ImageCanvas();
                this.ivjDoneDimCanvas.setName("DoneDimCanvas");
                URL resURL = this.getClass().getResource("Resources/Images/done-dim.gif");
                if (resURL == null) {
                    return this.ivjDoneDimCanvas;
                }
                this.syncDoneDim = Toolkit.getDefaultToolkit().getImage(resURL);
                this.mt.addImage(this.syncDoneDim, 0);
                this.ivjDoneDimCanvas.setImage(this.syncDoneDim);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjDoneDimCanvas;
    }

    private Label getDoneLabel() {
        if (this.ivjDoneLabel == null) {
            try {
                this.ivjDoneLabel = new Label();
                this.ivjDoneLabel.setName("DoneLabel");
                this.ivjDoneLabel.setAlignment(1);
                this.ivjDoneLabel.setText(resStrings.getString("syncFinishingString"));
                this.ivjDoneLabel.setForeground(Color.darkGray);
                this.ivjDoneLabel.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDoneLabel;
    }

    private ImageCanvas getDoneNormalCanvas() {
        if (this.ivjDoneNormalCanvas == null) {
            try {
                this.ivjDoneNormalCanvas = new ImageCanvas();
                this.ivjDoneNormalCanvas.setName("DoneNormalCanvas");
                URL resURL = this.getClass().getResource("Resources/Images/done.gif");
                if (resURL == null) {
                    return this.ivjDoneNormalCanvas;
                }
                this.syncDoneNormal = Toolkit.getDefaultToolkit().getImage(resURL);
                this.mt.addImage(this.syncDoneNormal, 0);
                this.ivjDoneNormalCanvas.setImage(this.syncDoneNormal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjDoneNormalCanvas;
    }

    private Panel getDoSyncCanvas() {
        if (this.ivjDoSyncCanvas == null) {
            try {
                this.ivjDoSyncCanvas = new Panel();
                this.ivjDoSyncCanvas.setName("DoSyncCanvas");
                this.ivjDoSyncCanvas.setLayout(new CardLayout());
                this.ivjDoSyncCanvas.setBackground(new Color(0, 0, 80));
                this.ivjDoSyncCanvas.setEnabled(false);
                this.getDoSyncCanvas().add((Component)this.getSyncDimCanvas(), this.getSyncDimCanvas().getName());
                this.getDoSyncCanvas().add((Component)this.getSyncNormalCanvas(), this.getSyncNormalCanvas().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjDoSyncCanvas;
    }

    private Panel getEndSyncCanvas() {
        if (this.ivjEndSyncCanvas == null) {
            try {
                this.ivjEndSyncCanvas = new Panel();
                this.ivjEndSyncCanvas.setName("EndSyncCanvas");
                this.ivjEndSyncCanvas.setLayout(new CardLayout());
                this.ivjEndSyncCanvas.setBackground(new Color(0, 0, 80));
                this.ivjEndSyncCanvas.setEnabled(false);
                this.getEndSyncCanvas().add((Component)this.getDoneDimCanvas(), this.getDoneDimCanvas().getName());
                this.getEndSyncCanvas().add((Component)this.getDoneNormalCanvas(), this.getDoneNormalCanvas().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjEndSyncCanvas;
    }

    Button getHideButton() {
        if (this.ivjHideButton == null) {
            try {
                this.ivjHideButton = new Button();
                this.ivjHideButton.setName("HideButton");
                this.ivjHideButton.setBackground(SystemColor.control);
                this.ivjHideButton.setVisible(true);
                this.ivjHideButton.setEnabled(true);
                this.ivjHideButton.setLabel(resStrings.getString("syncHideBtnString"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjHideButton;
    }

    private TextField getInfoChoice() {
        if (this.ivjInfoChoice == null) {
            try {
                this.ivjInfoChoice = new TextField();
                this.ivjInfoChoice.setName("InfoChoice");
                this.ivjInfoChoice.setText(resStrings.getString("WelcomeString"));
                this.ivjInfoChoice.setBackground(Color.white);
                this.ivjInfoChoice.setForeground(Color.black);
                this.ivjInfoChoice.setEditable(false);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInfoChoice;
    }

    private Panel getInfoPanel() {
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        if (this.ivjInfoPanel == null) {
            try {
                this.ivjInfoPanel = new Panel();
                this.ivjInfoPanel.setName("InfoPanel");
                this.ivjInfoPanel.setLayout(new GridBagLayout());
                this.ivjInfoPanel.setBackground(SystemColor.control);
                gridbagconstraints.gridx = 0;
                gridbagconstraints.gridy = 0;
                gridbagconstraints.gridwidth = 1;
                gridbagconstraints.gridheight = 1;
                gridbagconstraints.fill = 2;
                gridbagconstraints.anchor = 10;
                gridbagconstraints.weightx = 0.8;
                gridbagconstraints.weighty = 0.0;
                gridbagconstraints.insets = new Insets(5, 10, 5, 10);
                this.getInfoPanel().add((Component)this.getInfoChoice(), gridbagconstraints);
                gridbagconstraints1.gridx = 1;
                gridbagconstraints1.gridy = 0;
                gridbagconstraints1.gridwidth = 1;
                gridbagconstraints1.gridheight = 1;
                gridbagconstraints1.anchor = 10;
                gridbagconstraints1.weightx = 0.0;
                gridbagconstraints1.weighty = 0.0;
                gridbagconstraints1.insets = new Insets(0, 0, 0, 10);
                this.getInfoPanel().add((Component)this.getHideButton(), gridbagconstraints1);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjInfoPanel;
    }

    private Panel getMainPanel() {
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints2 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints3 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints4 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints5 = new GridBagConstraints();
        if (this.ivjMainPanel == null) {
            try {
                this.ivjMainPanel = new Panel();
                this.ivjMainPanel.setName("MainPanel");
                this.ivjMainPanel.setLayout(new GridBagLayout());
                gridbagconstraints.gridx = 1;
                gridbagconstraints.gridy = 2;
                gridbagconstraints.gridwidth = 1;
                gridbagconstraints.gridheight = 1;
                gridbagconstraints.anchor = 10;
                gridbagconstraints.weightx = 0.0;
                gridbagconstraints.weighty = 0.0;
                gridbagconstraints.ipadx = -1;
                gridbagconstraints.insets = new Insets(6, 36, 13, 9);
                this.getMainPanel().add((Component)this.getConnectingLabel(), gridbagconstraints);
                gridbagconstraints1.gridx = 2;
                gridbagconstraints1.gridy = 2;
                gridbagconstraints1.gridwidth = 1;
                gridbagconstraints1.gridheight = 1;
                gridbagconstraints1.anchor = 10;
                gridbagconstraints1.weightx = 0.0;
                gridbagconstraints1.weighty = 0.0;
                gridbagconstraints1.ipadx = 18;
                gridbagconstraints1.insets = new Insets(6, 10, 13, 9);
                this.getMainPanel().add((Component)this.getSyncLabel(), gridbagconstraints1);
                gridbagconstraints2.gridx = 3;
                gridbagconstraints2.gridy = 2;
                gridbagconstraints2.gridwidth = 1;
                gridbagconstraints2.gridheight = 1;
                gridbagconstraints2.anchor = 10;
                gridbagconstraints2.weightx = 0.0;
                gridbagconstraints2.weighty = 0.0;
                gridbagconstraints2.ipadx = 30;
                gridbagconstraints2.insets = new Insets(6, 9, 13, 37);
                this.getMainPanel().add((Component)this.getDoneLabel(), gridbagconstraints2);
                gridbagconstraints3.gridx = 1;
                gridbagconstraints3.gridy = 1;
                gridbagconstraints3.gridwidth = 1;
                gridbagconstraints3.gridheight = 1;
                gridbagconstraints3.anchor = 10;
                gridbagconstraints3.weightx = 0.0;
                gridbagconstraints3.weighty = 0.0;
                gridbagconstraints3.insets = new Insets(31, 36, 6, 9);
                this.getMainPanel().add((Component)this.getStartSyncCanvas(), gridbagconstraints3);
                gridbagconstraints4.gridx = 2;
                gridbagconstraints4.gridy = 1;
                gridbagconstraints4.gridwidth = 1;
                gridbagconstraints4.gridheight = 1;
                gridbagconstraints4.anchor = 10;
                gridbagconstraints4.weightx = 0.0;
                gridbagconstraints4.weighty = 0.0;
                gridbagconstraints4.insets = new Insets(31, 27, 6, 27);
                this.getMainPanel().add((Component)this.getDoSyncCanvas(), gridbagconstraints4);
                gridbagconstraints5.gridx = 3;
                gridbagconstraints5.gridy = 1;
                gridbagconstraints5.gridwidth = 1;
                gridbagconstraints5.gridheight = 1;
                gridbagconstraints5.anchor = 10;
                gridbagconstraints5.weightx = 0.0;
                gridbagconstraints5.weighty = 0.0;
                gridbagconstraints5.insets = new Insets(31, 9, 6, 37);
                this.getMainPanel().add((Component)this.getEndSyncCanvas(), gridbagconstraints5);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjMainPanel;
    }

    private Panel getStartSyncCanvas() {
        if (this.ivjStartSyncCanvas == null) {
            try {
                this.ivjStartSyncCanvas = new Panel();
                this.ivjStartSyncCanvas.setName("StartSyncCanvas");
                this.ivjStartSyncCanvas.setLayout(new CardLayout());
                this.ivjStartSyncCanvas.setBackground(new Color(0, 0, 80));
                this.ivjStartSyncCanvas.setEnabled(false);
                this.getStartSyncCanvas().add((Component)this.getConnDimCanvas(), this.getConnDimCanvas().getName());
                this.getStartSyncCanvas().add((Component)this.getConnNormalCanvas(), this.getConnNormalCanvas().getName());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjStartSyncCanvas;
    }

    private ImageCanvas getSyncDimCanvas() {
        if (this.ivjSyncDimCanvas == null) {
            try {
                this.ivjSyncDimCanvas = new ImageCanvas();
                this.ivjSyncDimCanvas.setName("SyncDimCanvas");
                URL resURL = this.getClass().getResource("Resources/Images/sync-dim.gif");
                if (resURL == null) {
                    return this.ivjSyncDimCanvas;
                }
                this.syncSyncDim = Toolkit.getDefaultToolkit().getImage(resURL);
                this.mt.addImage(this.syncSyncDim, 0);
                this.ivjSyncDimCanvas.setImage(this.syncSyncDim);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjSyncDimCanvas;
    }

    private Label getSyncLabel() {
        if (this.ivjSyncLabel == null) {
            try {
                this.ivjSyncLabel = new Label();
                this.ivjSyncLabel.setName("SyncLabel");
                this.ivjSyncLabel.setAlignment(1);
                this.ivjSyncLabel.setText(resStrings.getString("syncSynchronizingString"));
                this.ivjSyncLabel.setForeground(Color.darkGray);
                this.ivjSyncLabel.setEnabled(true);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSyncLabel;
    }

    private ImageCanvas getSyncNormalCanvas() {
        if (this.ivjSyncNormalCanvas == null) {
            try {
                this.ivjSyncNormalCanvas = new ImageCanvas();
                this.ivjSyncNormalCanvas.setName("SyncNormalCanvas");
                URL resURL = this.getClass().getResource("Resources/Images/sync.gif");
                if (resURL == null) {
                    return this.ivjSyncNormalCanvas;
                }
                this.syncSyncNormal = Toolkit.getDefaultToolkit().getImage(resURL);
                this.mt.addImage(this.syncSyncNormal, 0);
                this.ivjSyncNormalCanvas.setImage(this.syncSyncNormal);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.ivjSyncNormalCanvas;
    }

    private void handleException(Throwable throwable) {
    }

    private void initialize() {
        this.setName("SyncWindow");
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.control);
        this.add((Component)this.getInfoPanel(), "South");
        this.add((Component)this.getMainPanel(), "Center");
        this.validate();
        this.getInfoPanel().validate();
        try {
            this.mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.mt.isErrorID(0)) {
            System.out.println("Graphic Loading Error encountered!");
        }
    }

    void setConnectingEnabled(boolean flag) {
        String s = flag ? this.getConnNormalCanvas().getName() : this.getConnDimCanvas().getName();
        Color color = flag ? Color.blue : Color.darkGray;
        this.getConnectingLabel().setForeground(color);
        ((CardLayout)this.getStartSyncCanvas().getLayout()).show(this.getStartSyncCanvas(), s);
    }

    void setDoneEnabled(boolean flag) {
        String s = flag ? this.getDoneNormalCanvas().getName() : this.getDoneDimCanvas().getName();
        Color color = flag ? Color.blue : Color.darkGray;
        this.getDoneLabel().setForeground(color);
        ((CardLayout)this.getEndSyncCanvas().getLayout()).show(this.getEndSyncCanvas(), s);
    }

    void setHideEnabled(boolean flag) {
        this.getHideButton().setEnabled(flag);
    }

    void setHideVisible(boolean flag) {
        this.getHideButton().setVisible(flag);
        this.getInfoPanel().validate();
    }

    void setStatus(String s) {
        this.getInfoChoice().setText(s);
    }

    void setSynchronizingEnabled(boolean flag) {
        String s = flag ? this.getSyncNormalCanvas().getName() : this.getSyncDimCanvas().getName();
        Color color = flag ? Color.blue : Color.darkGray;
        this.getSyncLabel().setForeground(color);
        ((CardLayout)this.getDoSyncCanvas().getLayout()).show(this.getDoSyncCanvas(), s);
    }
}

