/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import org.jSyncManager.Client.LegacyClient.JSyncManagerFrame;

public class SecurityDialog
extends Dialog
implements ActionListener,
WindowListener {
    private Button ivjAddID = null;
    private Panel ivjContentsPane = null;
    private Button ivjRemoveID = null;
    private Checkbox ivjSecurityEnabledCB = null;
    private TextField ivjTextField1 = null;
    private List ivjUserIDList = null;
    private static ResourceBundle resEnglish;
    private Button ivjCloseButton = null;
    private Button ivjAddLastID = null;
    private JSyncManagerFrame manager = null;

    public SecurityDialog(Frame frame, ResourceBundle language) {
        super(frame);
        resEnglish = language;
        this.initialize();
    }

    public void actionPerformed(ActionEvent actionevent) {
        if (actionevent.getSource() == this.getAddID()) {
            this.connEtoC2(actionevent);
        }
        if (actionevent.getSource() == this.getRemoveID()) {
            this.connEtoM1(actionevent);
        }
        if (actionevent.getSource() == this.getAddID()) {
            this.connEtoM2(actionevent);
        }
        if (actionevent.getSource() == this.getCloseButton()) {
            this.connEtoM3(actionevent);
        }
        if (actionevent.getSource() == this.getAddLastID()) {
            this.connEtoC3(actionevent);
        }
    }

    public void addLastID() {
        int i = this.manager.getUserIDNumber();
        if (i == 0) {
            return;
        }
        this.getUserIDList().add("" + i);
    }

    public void addNewID(int id) {
        if (id < 1 | id > 9999) {
            return;
        }
        this.getUserIDList().add("" + id);
    }

    public void addUserID(String id) {
        try {
            int i = Integer.parseInt(id);
            if (i > 9999 | i < 1) {
                throw new NumberFormatException();
            }
            this.getUserIDList().add("" + i);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void connEtoC1(WindowEvent windowevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC2(ActionEvent actionevent) {
        try {
            this.addUserID(this.getTextField1().getText());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoC3(ActionEvent actionevent) {
        try {
            this.addLastID();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM1(ActionEvent actionevent) {
        try {
            this.getUserIDList().remove(this.getUserIDList().getSelectedItem());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM2(ActionEvent actionevent) {
        try {
            this.getTextField1().setText(new String());
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void connEtoM3(ActionEvent actionevent) {
        try {
            this.dispose();
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private Button getAddID() {
        if (this.ivjAddID == null) {
            try {
                this.ivjAddID = new Button();
                this.ivjAddID.setName("AddID");
                this.ivjAddID.setLabel(resEnglish.getString("Security_add"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAddID;
    }

    private Button getAddLastID() {
        if (this.ivjAddLastID == null) {
            try {
                this.ivjAddLastID = new Button();
                this.ivjAddLastID.setName("AddLastID");
                this.ivjAddLastID.setLabel(resEnglish.getString("Security_AddLastID"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjAddLastID;
    }

    private Button getCloseButton() {
        if (this.ivjCloseButton == null) {
            try {
                this.ivjCloseButton = new Button();
                this.ivjCloseButton.setName("CloseButton");
                this.ivjCloseButton.setLabel(resEnglish.getString("Security_button"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjCloseButton;
    }

    private Panel getContentsPane() {
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints2 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints3 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints4 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints5 = new GridBagConstraints();
        GridBagConstraints gridbagconstraints6 = new GridBagConstraints();
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new GridBagLayout());
                gridbagconstraints.gridx = 0;
                gridbagconstraints.gridy = 0;
                gridbagconstraints.gridwidth = 5;
                gridbagconstraints.gridheight = 1;
                gridbagconstraints.fill = 2;
                gridbagconstraints.anchor = 17;
                gridbagconstraints.weightx = 1.0;
                gridbagconstraints.weighty = 0.0;
                gridbagconstraints.insets = new Insets(0, 5, 0, 5);
                this.getContentsPane().add((Component)this.getSecurityEnabledCB(), gridbagconstraints);
                gridbagconstraints1.gridx = 0;
                gridbagconstraints1.gridy = 1;
                gridbagconstraints1.gridwidth = 5;
                gridbagconstraints1.gridheight = 1;
                gridbagconstraints1.fill = 1;
                gridbagconstraints1.anchor = 10;
                gridbagconstraints1.weightx = 1.0;
                gridbagconstraints1.weighty = 1.0;
                gridbagconstraints1.insets = new Insets(5, 10, 5, 10);
                this.getContentsPane().add((Component)this.getUserIDList(), gridbagconstraints1);
                gridbagconstraints2.gridx = 0;
                gridbagconstraints2.gridy = 2;
                gridbagconstraints2.gridwidth = 1;
                gridbagconstraints2.gridheight = 1;
                gridbagconstraints2.fill = 2;
                gridbagconstraints2.anchor = 10;
                gridbagconstraints2.weightx = 1.0;
                gridbagconstraints2.weighty = 0.0;
                this.getContentsPane().add((Component)this.getTextField1(), gridbagconstraints2);
                gridbagconstraints3.gridx = 1;
                gridbagconstraints3.gridy = 2;
                gridbagconstraints3.gridwidth = 1;
                gridbagconstraints3.gridheight = 1;
                gridbagconstraints3.anchor = 10;
                gridbagconstraints3.weightx = 0.0;
                gridbagconstraints3.weighty = 0.0;
                this.getContentsPane().add((Component)this.getAddID(), gridbagconstraints3);
                gridbagconstraints4.gridx = 2;
                gridbagconstraints4.gridy = 2;
                gridbagconstraints4.gridwidth = 1;
                gridbagconstraints4.gridheight = 1;
                gridbagconstraints4.anchor = 10;
                gridbagconstraints4.weightx = 0.0;
                gridbagconstraints4.weighty = 0.0;
                this.getContentsPane().add((Component)this.getRemoveID(), gridbagconstraints4);
                gridbagconstraints5.gridx = 4;
                gridbagconstraints5.gridy = 2;
                gridbagconstraints5.gridwidth = 1;
                gridbagconstraints5.gridheight = 1;
                gridbagconstraints5.anchor = 10;
                gridbagconstraints5.weightx = 0.0;
                gridbagconstraints5.weighty = 0.0;
                this.getContentsPane().add((Component)this.getCloseButton(), gridbagconstraints5);
                gridbagconstraints6.gridx = 3;
                gridbagconstraints6.gridy = 2;
                gridbagconstraints6.gridwidth = 1;
                gridbagconstraints6.gridheight = 1;
                gridbagconstraints6.anchor = 10;
                gridbagconstraints6.weightx = 0.0;
                gridbagconstraints6.weighty = 0.0;
                this.getContentsPane().add((Component)this.getAddLastID(), gridbagconstraints6);
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjContentsPane;
    }

    public int[] getIDList() {
        int[] ai = new int[this.getUserIDList().getItemCount()];
        int i = 0;
        while (i < ai.length) {
            try {
                ai[i] = Integer.parseInt(this.getUserIDList().getItem(i));
            }
            catch (NumberFormatException ex) {
                ai[i] = 0;
            }
            ++i;
        }
        return ai;
    }

    private JSyncManagerFrame getManager() {
        return this.manager;
    }

    private Button getRemoveID() {
        if (this.ivjRemoveID == null) {
            try {
                this.ivjRemoveID = new Button();
                this.ivjRemoveID.setName("RemoveID");
                this.ivjRemoveID.setLabel(resEnglish.getString("Security_remove"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjRemoveID;
    }

    private Checkbox getSecurityEnabledCB() {
        if (this.ivjSecurityEnabledCB == null) {
            try {
                this.ivjSecurityEnabledCB = new Checkbox();
                this.ivjSecurityEnabledCB.setName("SecurityEnabledCB");
                this.ivjSecurityEnabledCB.setLabel(resEnglish.getString("Security_enablement"));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjSecurityEnabledCB;
    }

    private TextField getTextField1() {
        if (this.ivjTextField1 == null) {
            try {
                this.ivjTextField1 = new TextField();
                this.ivjTextField1.setName("TextField1");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjTextField1;
    }

    private List getUserIDList() {
        if (this.ivjUserIDList == null) {
            try {
                this.ivjUserIDList = new List();
                this.ivjUserIDList.setName("UserIDList");
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
        return this.ivjUserIDList;
    }

    private void handleException(Throwable throwable) {
    }

    public boolean idAllowed(int id) {
        if (!this.getSecurityEnabledCB().getState()) {
            return true;
        }
        int j = 0;
        while (j < this.getUserIDList().getItemCount()) {
            try {
                if (Integer.parseInt(this.getUserIDList().getItem(j)) == id) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++j;
        }
        return false;
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getAddID().addActionListener(this);
        this.getRemoveID().addActionListener(this);
        this.getCloseButton().addActionListener(this);
        this.getAddLastID().addActionListener(this);
    }

    private void initialize() {
        this.setName("SecurityDialog");
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(408, 180);
        this.setTitle(resEnglish.getString("Security_title"));
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setBounds((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2, this.getBounds().width, this.getBounds().height);
    }

    public boolean isSecurityEnabled() {
        return this.getSecurityEnabledCB().getState();
    }

    public void setManager(JSyncManagerFrame jsm) {
        this.manager = jsm;
    }

    public void setSecurityOption(boolean flag) {
        this.getSecurityEnabledCB().setState(flag);
    }

    public void windowActivated(WindowEvent windowevent) {
    }

    public void windowClosed(WindowEvent windowevent) {
    }

    public void windowClosing(WindowEvent windowevent) {
        if (windowevent.getSource() == this) {
            this.connEtoC1(windowevent);
        }
    }

    public void windowDeactivated(WindowEvent windowevent) {
    }

    public void windowDeiconified(WindowEvent windowevent) {
    }

    public void windowIconified(WindowEvent windowevent) {
    }

    public void windowOpened(WindowEvent windowevent) {
    }
}

