/*
 * Decompiled with CFR 0.152.
 */
package org.jSyncManager.Client.LegacyClient;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ResourceBundle;

public class LogFrame
extends Frame
implements ClipboardOwner,
ActionListener,
WindowListener {
    private Panel ivjContentsPane = null;
    private TextArea ivjLogData = null;
    private static ResourceBundle resEnglish;
    private MenuItem ivjClearLogMenuItem = null;
    private MenuItem ivjCloseLogMenuItem = null;
    private MenuItem ivjCopyLogMenuItem = null;
    private MenuBar ivjLogFrameMenuBar = null;
    private Menu ivjLogMenu = null;
    private MenuItem ivjSaveLogMenuItem = null;
    private FileDialog ivjFileDialog = null;

    public LogFrame(ResourceBundle language) {
        resEnglish = language;
        this.initialize();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getCloseLogMenuItem()) {
            this.connEtoM1(e);
        }
        if (e.getSource() == this.getClearLogMenuItem()) {
            this.connEtoM2(e);
        }
        if (e.getSource() == this.getCopyLogMenuItem()) {
            this.connEtoC2(e);
        }
        if (e.getSource() == this.getSaveLogMenuItem()) {
            this.connEtoC3(e);
        }
    }

    public void appendToLog(String data) {
        this.getLogData().append(data + "\n");
    }

    private void connEtoC1(WindowEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.CopyLogToClipboard();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.saveLog();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM2(ActionEvent arg1) {
        try {
            this.getLogData().setText(new String());
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void CopyLogToClipboard() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection text = new StringSelection(this.getLogData().getText());
        clip.setContents(text, this);
    }

    public void dispose() {
        ((Component)this).setVisible(false);
    }

    private MenuItem getClearLogMenuItem() {
        if (this.ivjClearLogMenuItem == null) {
            try {
                this.ivjClearLogMenuItem = new MenuItem();
                this.ivjClearLogMenuItem.setLabel(resEnglish.getString("log_clear_button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearLogMenuItem;
    }

    private MenuItem getCloseLogMenuItem() {
        if (this.ivjCloseLogMenuItem == null) {
            try {
                this.ivjCloseLogMenuItem = new MenuItem();
                this.ivjCloseLogMenuItem.setLabel(resEnglish.getString("log_close_button"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseLogMenuItem;
    }

    private Panel getContentsPane() {
        if (this.ivjContentsPane == null) {
            try {
                this.ivjContentsPane = new Panel();
                this.ivjContentsPane.setName("ContentsPane");
                this.ivjContentsPane.setLayout(new BorderLayout());
                this.getContentsPane().add((Component)this.getLogData(), "Center");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjContentsPane;
    }

    private MenuItem getCopyLogMenuItem() {
        if (this.ivjCopyLogMenuItem == null) {
            try {
                this.ivjCopyLogMenuItem = new MenuItem();
                this.ivjCopyLogMenuItem.setLabel(resEnglish.getString("log_copy_menuitem"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCopyLogMenuItem;
    }

    private FileDialog getFileDialog() {
        if (this.ivjFileDialog == null) {
            try {
                this.ivjFileDialog = new FileDialog(this);
                this.ivjFileDialog.setName("FileDialog");
                this.ivjFileDialog.setLayout(null);
                this.ivjFileDialog.setMode(1);
                ((Dialog)this.ivjFileDialog).setTitle(resEnglish.getString("log_filedlg_title"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileDialog;
    }

    private TextArea getLogData() {
        if (this.ivjLogData == null) {
            try {
                this.ivjLogData = new TextArea();
                this.ivjLogData.setName("LogData");
                this.ivjLogData.setEnabled(true);
                this.ivjLogData.setEditable(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogData;
    }

    private MenuBar getLogFrameMenuBar() {
        if (this.ivjLogFrameMenuBar == null) {
            try {
                this.ivjLogFrameMenuBar = new MenuBar();
                this.ivjLogFrameMenuBar.add(this.getLogMenu());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogFrameMenuBar;
    }

    private Menu getLogMenu() {
        if (this.ivjLogMenu == null) {
            try {
                this.ivjLogMenu = new Menu();
                this.ivjLogMenu.setLabel(resEnglish.getString("LogMenuLabel"));
                this.ivjLogMenu.add(this.getSaveLogMenuItem());
                this.ivjLogMenu.add(this.getCopyLogMenuItem());
                this.ivjLogMenu.add(this.getClearLogMenuItem());
                this.ivjLogMenu.add(this.getCloseLogMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogMenu;
    }

    private MenuItem getSaveLogMenuItem() {
        if (this.ivjSaveLogMenuItem == null) {
            try {
                this.ivjSaveLogMenuItem = new MenuItem();
                this.ivjSaveLogMenuItem.setLabel(resEnglish.getString("log_save_menuitem"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSaveLogMenuItem;
    }

    private void handleException(Throwable exception) {
    }

    private void initConnections() {
        this.addWindowListener(this);
        this.getCloseLogMenuItem().addActionListener(this);
        this.getClearLogMenuItem().addActionListener(this);
        this.getCopyLogMenuItem().addActionListener(this);
        this.getSaveLogMenuItem().addActionListener(this);
    }

    private void initialize() {
        this.setName("LogFrame");
        this.setMenuBar(this.getLogFrameMenuBar());
        this.setLayout(new BorderLayout());
        ((Component)this).setSize(426, 240);
        this.setTitle(resEnglish.getString("log_title"));
        this.add((Component)this.getContentsPane(), "Center");
        this.initConnections();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void saveLog() {
        try {
            this.getFileDialog().setFile("jsyncmanager.log");
            ((Component)this.getFileDialog()).setVisible(true);
            String path = this.getFileDialog().getDirectory();
            String file = this.getFileDialog().getFile();
            String seperator = System.getProperty("file.separator");
            String saveAs = path + (path.endsWith(seperator) ? "" : seperator) + file;
            try {
                FileOutputStream fos = new FileOutputStream(saveAs);
                DataOutputStream dos = new DataOutputStream(fos);
                dos.writeBytes(this.getLogData().getText());
                dos.flush();
                dos.close();
                fos.flush();
                fos.close();
                return;
            }
            catch (IOException e) {
                this.appendToLog("*** Error writing log: " + e.toString());
            }
        }
        catch (Exception e1) {
            this.appendToLog("*** Save log encountered exception: " + e1.toString());
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.connEtoC1(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

